;;; This work is licensed under the Creative Commons
;;; Attribution-NonCommercial-ShareAlike 4.0 International License.
;;; To view a copy of this license, visit
;;; http://creativecommons.org/licenses/by-nc-sa/4.0/ or send a letter to
;;; Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

;;; Code developed after analysis of, and drawing on the content of, ACT-R code
;;; published by Lewis & Vasishth 2005 and Engelmann 2016
;;; https://github.com/felixengelmann/act-r-sentence-parser-em

;;; Procedural memory for lfgmodel.lisp

(p create-verb-for-nv
    !safe-eval! (buffer-set-empty 'vp)
    !safe-eval! (compilable-empty 'vp)
    !safe-eval! (not-neg 'v 'ma.cat 'np)
    !safe-eval! (attachablep 'np)
    =goal>
      isa       parse
      goal-state attach
    =np>
      isa       f-rep
      predreqd  nil
    ==>
    +vp>
      isa       f-rep
      cat       ((v plus) (adjcv minus) (adv minus) (n minus) (p minus))
      ma        t
      predreqd  t
      deps      0
    =np>
)

(p fill-vp-from-multibuffer
    !safe-eval! (one-chunk-in-buffer-set 'vp)
    !safe-eval! (compilable-empty 'vp)
    !safe-eval! (not-neg 'v 'ma.cat 'np)
    !safe-eval! (attachablep 'np)
    =goal>
      isa       parse
      goal-state attach
    =np>
      isa       f-rep
      predreqd  nil
    ==>
    !safe-eval! (fill-buffer-from-set 'vp)
    =np>
)


(p attach-np-to-vp-prehead-as-dep1
    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (attachablep 'np)
    !safe-eval! (congruentp 'pre.ma.cat 'np 'cat 'vp)
    =goal>
      isa       parse
      goal-state attach
    =np>
      isa       f-rep
      predreqd  nil
;      ma        nil
;      ma.cat    Verb
      pre.ma.gf     =word.pre.ma.gf
    =vp>
      isa       f-rep
      predreqd  t
      dep1      nil
    ==>
    =goal>
      goal-state wrapup
    =vp>
      isa       f-rep
      dep1      =np
      dep1.gf   =word.pre.ma.gf
      deps      1
    =np>
      ma        =vp
     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'np)
     !safe-eval! (add-to-chunk-set 'vp)
;     !safe-eval! (increment-deps 'vp)
)

(p attach-np-to-vp-prehead-as-dep2

    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (congruentp 'pre.ma.cat 'np 'cat 'vp)
    !safe-eval! (attachablep 'np)
    =goal>
      isa       parse
      goal-state attach
    =np>
      isa       f-rep
      predreqd  nil
;      ma        nil
;      ma.cat    Verb
      pre.ma.gf     =word.pre.ma.gf
    =vp>
      isa       f-rep
      predreqd  t
      dep1      =anychunk0
    - dep1.gf   =word.pre.ma.gf
      dep2      nil
    ==>
    =goal>
      goal-state wrapup
    =vp>
      dep2      =np
      dep2.gf   =word.pre.ma.gf
      deps      2
    =np>
      ma        =vp
     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'np)
     !safe-eval! (add-to-chunk-set 'vp)
;     !safe-eval! (increment-deps 'vp)
)

(p attach-np-to-vp-prehead-as-dep3

    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (congruentp 'pre.ma.cat 'np 'cat 'vp)
    !safe-eval! (attachablep 'np)
    =goal>
      isa       parse
      goal-state attach
    =np>
      isa       f-rep
      predreqd  nil
;      ma        nil
;      ma.cat    Verb
      pre.ma.gf     =word.pre.ma.gf
    =vp>
      isa       f-rep
      predreqd  t
      dep1      =anychunk0
    - dep1.gf   =word.pre.ma.gf
      dep2      =anychunk1
    - dep2.gf   =word.pre.ma.gf
      dep3      nil
    ==>
    =goal>
      goal-state wrapup
    =vp>
      dep3      =np
      dep3.gf   =word.pre.ma.gf
      deps      3
    =np>
      ma        =vp
     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'np)
     !safe-eval! (add-to-chunk-set 'vp)
;     !safe-eval! (increment-deps 'vp)
)



(p attach-np-to-vp-posthead-as-dep1

    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (congruentp 'post.ma.cat 'np 'cat 'vp)
    !safe-eval! (congruentp 'post.ma.gf 'np 'dep1.gf 'vp)
    !safe-eval! (attachablep 'np)
    !bind! =thisgf (find-gf-match *ugflist* 'post.ma.gf 'np 'dep1.gf 'vp)
    =goal>
      isa       parse
      goal-state attach
      locus     np
    =np>
      isa       f-rep
      predreqd  nil
;      ma        nil
    =vp>
      isa       f-rep
      predreqd  nil
      dep1      nil
    ==>
    =goal>
      goal-state wrapup
    =vp>
      dep1      =np
      dep1.gf   =thisgf
      deps      1
    =np>
      ma        =vp
     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'np)
     !safe-eval! (add-to-chunk-set 'vp)
)

(p attach-np-to-vp-posthead-as-dep2

    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (congruentp 'post.ma.cat 'np 'cat 'vp)
    !safe-eval! (congruentp 'post.ma.gf 'np 'dep2.gf 'vp)
    !safe-eval! (attachablep 'np)
    !bind! =thisgf (find-gf-match *ugflist* 'post.ma.gf 'np 'dep2.gf 'vp)
    =goal>
      isa       parse
      goal-state attach
      locus     np
    =np>
      isa       f-rep
      predreqd  nil
;      ma        nil
;      ma.cat    Verb
      post.ma.gf     =word.post.ma.gf
    =vp>
      isa       f-rep
      predreqd  nil
      dep1      =anychunk0
      dep2      nil
    ==>
    =goal>
      goal-state wrapup
    =vp>
      dep2      =np
      dep2.gf   =thisgf
      deps      2
    =np>
      ma        =vp
;     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'np)
;     !safe-eval! (add-to-chunk-set 'vp)
)

(p attach-np-to-vp-posthead-as-dep3

    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (congruentp 'post.ma.cat 'np 'cat 'vp)
    !safe-eval! (congruentp 'post.ma.gf 'np 'dep3.gf 'vp)
    !safe-eval! (attachablep 'np)
    !bind! =thisgf (find-gf-match *ugflist* 'post.ma.gf 'np 'dep3.gf 'vp)
    =goal>
      isa       parse
      goal-state attach
      locus     np
    =np>
      isa       f-rep
      predreqd  nil
;      ma        nil
;      ma.cat    Verb
      post.ma.gf     =word.post.ma.gf
    =vp>
      isa       f-rep
      predreqd  nil
      dep1      =anychunk0
      dep2      =anychunk1
      dep3      nil
    ==>
    =goal>
      goal-state wrapup
    =vp>
      dep3      =np
      dep3.gf   =thisgf
      deps      3
    =np>
      ma        =vp
;     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'np)
;     !safe-eval! (add-to-chunk-set 'vp)
)

(p attach-np-to-vp-posthead-as-dep4

    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (congruentp 'post.ma.cat 'np 'cat 'vp)
    !safe-eval! (congruentp 'post.ma.gf 'np 'dep4.gf 'vp)
    !safe-eval! (attachablep 'np)
    !bind! =thisgf (find-gf-match *ugflist* 'post.ma.gf 'np 'dep4.gf 'vp)
    =goal>
      isa       parse
      goal-state attach
      locus     np
    =np>
      isa       f-rep
      predreqd  nil
;      ma        nil
;      ma.cat    Verb
      post.ma.gf     =word.post.ma.gf
    =vp>
      isa       f-rep
      predreqd  nil
      dep1      =anychunk0
      dep2      =anychunk1
      dep3      =anychunk2
      dep4      nil
    ==>
    =goal>
      goal-state wrapup
    =vp>
      dep4      =np
      dep4.gf   =thisgf
      deps      4
    =np>
      ma        =vp
;     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'np)
;     !safe-eval! (add-to-chunk-set 'vp)
)

(p np-nonunique-pushdown-in-new-vp
    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (congruentp 'pre.ma.cat 'np 'cat 'vp)
    !safe-eval! (nonuniquep 'np 'vp)
    =goal>
      isa       parse
      goal-state attach
    =np>
    =vp>
      isa       f-rep
      predreqd  t
    ==>
    =goal>
    @vp>
    isa         f-rep
    cat         ((v plus) (n minus) (adjcv minus) (adv minus) (p minus))
    predreqd    t
    =np>
      ma        =vp
;     !safe-eval! (increment-deps 'vp)
)






(p attach-np-to-ap-posthead-as-dep1

    !safe-eval! (congruentp 'post.ma.cat 'np 'cat 'ap)
    !safe-eval! (congruentp 'post.ma.gf 'np 'dep1.gf 'ap)
    !safe-eval! (attachablep 'np)
    !bind! =thisgf (find-gf-match *ugflist* 'post.ma.gf 'np 'dep1.gf 'ap)
    =goal>
      isa       parse
      goal-state attach
      locus     np
    =np>
      isa       f-rep
      predreqd  nil
;      ma        nil
    =ap>
      isa       f-rep
      predreqd  nil
      dep1      nil
    ==>
    =goal>
      goal-state wrapup
    =ap>
      dep1      =np
      dep1.gf   =thisgf
      deps      1
    =np>
      ma        =ap
     !safe-eval! (add-to-chunk-set 'np)
     !safe-eval! (add-to-chunk-set 'ap)
)



(p leave-vp-unattached
    =goal>
      isa        parse
      goal-state attach
      locus      vp
    =vp>
      isa        f-rep
    - ma         reqd
      adj.post   t
    ==>
    =goal>
      goal-state find
    =vp>
)

(p vp-unattached-wrapup
    =goal>
      isa        parse
      goal-state attach
      locus      vp
    =vp>
      isa        f-rep
    - ma         reqd
      adj.post   no
    ==>
    =goal>
      goal-state wrapup
    =vp>
)

(p create-np-for-vn
    !safe-eval! (compilable-empty 'np)
    !safe-eval! (not-neg 'n 'ma.cat 'vp)
    =goal>
      isa        parse
      goal-state attach
      locus      vp
    =vp>
      isa        f-rep
      ma         reqd
    ==>
    +np>
      isa        f-rep
      cat        ((adjcv minus) (adv minus) (n plus) (p minus) (v minus))
      ma         t
      predreqd   t
      deps       0
    =vp>
)

(p attach-vp-to-np-as-dep1-prehead
    !safe-eval! (congruentp 'ma.cat 'vp 'cat 'np)
    =goal>
      isa        parse
      goal-state attach
      locus      vp
    =vp>
      isa        f-rep
      ma         reqd
      pre.ma.gf =word.ma.gf
    =np>
      isa        f-rep
      predreqd   t
      deps       0
      dep1       nil
    ==>
    =goal>
    =vp>
      ma         =np
    =np>
      dep1       =vp
      dep1.gf    =word.ma.gf
      deps       1
    !safe-eval! (add-to-chunk-set 'np)
    !safe-eval! (add-to-chunk-set 'vp)
)

(p attach-vp-to-np-as-dep1-posthead
    !safe-eval! (congruentp 'ma.cat 'vp 'cat 'np)
    =goal>
      isa        parse
      goal-state attach
      locus      vp
    =vp>
      isa        f-rep
      ma         reqd
      post.ma.gf =word.ma.gf
    =np>
      isa        f-rep
      predreqd   nil
      deps       0
      dep1       nil
    ==>
    =goal>
    =vp>
      ma         =np
    =np>
      dep1       =vp
      dep1.gf    =word.ma.gf
      deps       1
    !safe-eval! (add-to-chunk-set 'np)
    !safe-eval! (add-to-chunk-set 'vp)
)

(p attach-ap-to-vp-posthead-as-dep2

    !safe-eval! (compilable-empty 'np)
    !safe-eval! (congruentp 'post.ma.cat 'ap 'cat 'vp)
    !safe-eval! (congruentp 'post.ma.gf 'ap 'dep2.gf 'vp)
    !safe-eval! (attachablep 'ap)
    !bind! =thisgf (find-gf-match *ugflist* 'post.ma.gf 'ap 'dep2.gf 'vp)
    =goal>
      isa       parse
      goal-state attach
      locus     ap
    =ap>
      isa       f-rep
      predreqd  nil
;      ma        nil
      post.ma.gf     =word.post.ma.gf
    =vp>
      isa       f-rep
      predreqd  nil
      dep1      =anychunk0
      dep2      nil
    ==>
    =goal>
      goal-state find
    =vp>
      dep2      =ap
      dep2.gf   =thisgf
      deps      2
    =ap>
      ma        =vp
;     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'ap)
;     !safe-eval! (add-to-chunk-set 'vp)
)

(p attach-ap-to-vp-posthead-as-dep3

    !safe-eval! (compilable-empty 'np)
    !safe-eval! (congruentp 'post.ma.cat 'ap 'cat 'vp)
    !safe-eval! (congruentp 'post.ma.gf 'ap 'dep3.gf 'vp)
    !safe-eval! (attachablep 'ap)
    !bind! =thisgf (find-gf-match *ugflist* 'post.ma.gf 'ap 'dep3.gf 'vp)
    =goal>
      isa       parse
      goal-state attach
      locus     ap
    =ap>
      isa       f-rep
      predreqd  nil
;      ma        nil
;      ma.cat    Verb
      post.ma.gf     =word.post.ma.gf
    =vp>
      isa       f-rep
      predreqd  nil
      dep1      =anychunk0
      dep2      =anychunk1
      dep3      nil
    ==>
    =goal>
      goal-state find
    =vp>
      dep3      =ap
      dep3.gf   =thisgf
      deps      3
    =ap>
      ma        =vp
    !safe-eval! (add-to-chunk-set 'ap)

)

(p attach-ap-to-vp-posthead-as-dep4

    !safe-eval! (compilable-empty 'np)
    !safe-eval! (congruentp 'post.ma.cat 'ap 'cat 'vp)
    !safe-eval! (congruentp 'post.ma.gf 'ap 'dep4.gf 'vp)
    !safe-eval! (attachablep 'ap)
    !bind! =thisgf (find-gf-match *ugflist* 'post.ma.gf 'ap 'dep4.gf 'vp)
    =goal>
      isa       parse
      goal-state attach
      locus     ap
    =ap>
      isa       f-rep
      predreqd  nil
      post.ma.gf     =word.post.ma.gf
    =vp>
      isa       f-rep
      predreqd  nil
      dep1      =anychunk0
      dep2      =anychunk1
      dep3      =anychunk2
      dep4      nil
    ==>
    =goal>
      goal-state find
    =vp>
      dep4      =ap
      dep4.gf   =thisgf
      deps      4
    =ap>
      ma        =vp
    !safe-eval! (add-to-chunk-set 'ap)
)

(p attach-ap-to-vp-prehead-as-dep1
    !safe-eval! (attachablep 'ap)
    !safe-eval! (congruentp 'cat 'vp 'ma.cat 'ap)
    =goal>
      isa       parse
      goal-state attach
    =ap>
      isa       f-rep
      predreqd  nil
      pre.ma.gf =wordgf
    =vp>
      isa       f-rep
      predreqd  t
      dep1      nil
    ==>
    =goal>
      goal-state find
    =vp>
      dep1      =ap
      dep1.gf   =wordgf
    =ap>
      ma        =vp
    -ap>
    !safe-eval! (add-to-chunk-set 'ap)
    !safe-eval! (add-to-chunk-set 'vp)
)


(p attach-ap-to-vp-prehead-as-dep2
    !safe-eval! (attachablep 'ap)
    !safe-eval! (congruentp 'cat 'vp 'ma.cat 'ap)
    =goal>
      isa       parse
      goal-state attach
    =ap>
      isa       f-rep
      predreqd  nil
      pre.ma.gf =wordgf
    =vp>
      isa       f-rep
      predreqd  t
      dep1      =anychunk1
      dep2      nil
    ==>
    =goal>
      goal-state find
    =vp>
      dep2      =ap
      dep2.gf   =wordgf
    =ap>
      ma        =vp
    -ap>
    !safe-eval! (add-to-chunk-set 'ap)
)



(p attach-ap-to-vp-prehead-as-dep3
    !safe-eval! (attachablep 'ap)
    !safe-eval! (congruentp 'cat 'vp 'ma.cat 'ap)
    =goal>
      isa       parse
      goal-state attach
    =ap>
      isa       f-rep
      predreqd  nil
      pre.ma.gf =wordgf
    =vp>
      isa       f-rep
      predreqd  t
      dep1      =anychunk1
      dep2      =anychunk2
      dep3      nil
    ==>
    =goal>
      goal-state find
    =vp>
      dep3      =ap
      dep3.gf   =wordgf
    =ap>
      ma        =vp
    -ap>
    !safe-eval! (add-to-chunk-set 'ap)
  )

(p attach-ap-to-np-prehead-as-dep1
    !safe-eval! (congruentp 'cat 'np 'pre.ma.cat 'ap)
    !safe-eval! (attachablep 'ap)
    =goal>
      isa        parse
      goal-state attach
      locus      ap
    =np>
      isa        f-rep
      predreqd   t
      adj.prec   t
      dep1       nil
    =ap>
      isa        f-rep
      predreqd   nil
;      ma         nil
    ==>
    =goal>
      goal-state find
    =np>
      dep1       =ap
      dep1.gf    adj
      deps       1
    =ap>
      ma         =np
    -ap>
    !safe-eval! (add-to-chunk-set 'ap)
    !safe-eval! (add-to-chunk-set 'np)
)



(p attach-ap-to-np-posthead-as-dep1
    !safe-eval! (congruentp 'adj.post.cat 'np 'post.ma.cat 'ap)
    !safe-eval! (attachablep 'ap)
    =goal>
      isa        parse
      goal-state attach
      locus      ap
    =np>
      isa        f-rep
      predreqd   nil
      adj.post   t
      dep1       nil
    =ap>
      isa        f-rep
      predreqd   nil
;      ma         nil
    ==>
    =goal>
      goal-state find
    =np>
      dep1       =ap
      dep1.gf    adj
      deps       1
    =ap>
      ma         =np
    -np>
    !safe-eval! (add-to-chunk-set 'ap)
    !safe-eval! (add-to-chunk-set 'np)
)
