;;; This work is licensed under the Creative Commons
;;; Attribution-NonCommercial-ShareAlike 4.0 International License.
;;; To view a copy of this license, visit
;;; http://creativecommons.org/licenses/by-nc-sa/4.0/ or send a letter to
;;; Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

;;; Procedural memory for lfgmodel.lisp
;;; Code developed after analysis of, and drawing on the content of, ACT-R code
;;; published by Lewis & Vasishth 2005 and Engelmann 2016
;;; https://github.com/felixengelmann/act-r-sentence-parser-em

;;; Productions for lexical retrieval


(p get-lex-ent-no-prov-ldd
    =goal>
      isa   parse
      goal-state lookup
    - lddopen prov
    =visual>
      isa   text
      value =word
    - value "*"
    - value "||"
    ?retrieval>
      state free
    ==>
    !safe-eval! (setf *this-word* (concatenate 'string "" =word))
;    !safe-eval! (setf *lex-retrieval-start* (mp-time-ms))
    =goal>
      goal-state create
    +retrieval>
      isa   lex-ent
      string =word
)

(p get-lex-ent-prov-ldd
    =goal>
      isa   parse
      goal-state lookup
      lddopen prov
    =visual>
      isa   text
      value =word
    - value "*"
    - value "||"
    ?retrieval>
      state free
    ==>
    !safe-eval! (setf *this-word* (concatenate 'string "" =word))
;    !safe-eval! (setf *lex-retrieval-start* (mp-time-ms))
    =goal>
      goal-state check-ldd
    +retrieval>
      isa   lex-ent
      string =word
)

(p new-frep-det
    =goal>
      isa   parse
      goal-state  create
    =retrieval>
      isa   lex-ent
      cat   ((n plus) (v minus) (p minus) (adv minus) (adjcv minus))
      predreqd t
      ma     =word.ma
      pred   =word.pred
      adj    =word.adj
      adj.prec =word.adj.prec
      adj.prec.cat =word.adj.prec.cat
    ?np>
      buffer empty
    ==>
    =goal>
      goal-state find
      locus   np
    +np>
      isa   f-rep
      cat   ((n plus) (v minus) (p minus) (adjcv minus) (adv minus))
      predreqd t
      deps 0
      ma    =word.ma
      pred  =word.pred
      adj   =word.adj
      adj.prec =word.adj.prec
      adj.prec.cat =word.adj.prec.cat
)

(p clear-np-for-np-as-dep3
    !safe-eval! (congruentp1 'dep3.gf 'vp 'post.ma.gf 'retrieval)
    =goal>
      isa    parse
      goal-state create
    =retrieval>
      isa    lex-ent
      cat    ((n plus) (v minus) (p minus) (adv minus) (adjcv minus))
    =np>
      isa    f-rep
      predreqd nil
    =vp>
      isa    f-rep
      predreqd nil
    ==>
    =goal>
    =retrieval>
    =vp>
)

(p np-after-np-triggers-rrc-vp-dep2
    !safe-eval! (not (congruentp1 'dep2.gf 'vp 'post.ma.gf 'retrieval))
    =goal>
      isa      parse
      goal-state create
    =retrieval>
      isa      lex-ent
      cat      ((n plus) (v minus) (p minus) (adv minus) (adjcv minus))
    =np>
      isa      f-rep
      predreqd nil
    =vp>
      isa      f-rep
      dep1     =anychunk0
      dep2     nil
    ==>
    =goal>
      goal-state rrc1
    @vp>
      isa      f-rep
      cat         ((adjcv minus) (adv minus) (n minus) (p minus) (v plus))
      predreqd    t
      ma          =np
      embedded    t
    =np>
    =retrieval>
)


(p np-after-np-triggers-rrc-vp-dep3
    !safe-eval! (not (congruentp1 'dep3.gf 'vp 'post.ma.gf 'retrieval))
    =goal>
      isa      parse
      goal-state create
    =retrieval>
      isa      lex-ent
      cat      ((n plus) (v minus) (p minus) (adv minus) (adjcv minus))
    =np>
      isa      f-rep
      predreqd nil
    =vp>
      isa      f-rep
      dep1     =anychunk0
      dep2     =anychunk1
      dep3     nil
    ==>
    =goal>
      goal-state rrc1
    @vp>
      isa      f-rep
      cat         ((adjcv minus) (adv minus) (n minus) (p minus) (v plus))
      predreqd    t
      ma          =np
      embedded    t
    =np>
    =retrieval>
)


(p np-after-np-triggers-rrc-vp-dep4
    !safe-eval! (not (congruentp1 'dep4.gf 'vp 'post.ma.gf 'retrieval))
    =goal>
      isa      parse
      goal-state create
    =retrieval>
      isa      lex-ent
      cat      ((n plus) (v minus) (p minus) (adv minus) (adjcv minus))
    =np>
      isa      f-rep
      predreqd nil
    =vp>
      isa      f-rep
      dep1     =anychunk0
      dep2     =anychunk1
      dep3     =anychunk2
      dep4     nil
    ==>
    =goal>
      goal-state rrc1
    @vp>
      isa      f-rep
      cat         ((adjcv minus) (adv minus) (n minus) (p minus) (v plus))
      predreqd    t
      ma          =np
      embedded    t
    =np>
    =retrieval>
)



(p rrc-attach-dep1
    =goal>
      isa        parse
      goal-state rrc1
    =retrieval>
      isa        f-rep
      post.ma.gf =rctype
    =np>
      isa        f-rep
      dep1       nil
    =vp>
      isa         f-rep
      predreqd    t
      ma          =np
    ==>
    !bind! =lddchunk (next-bigpro)
    =goal>
      goal-state  create
      ldd         =lddchunk
      lddopen     open
      lddtype     =rctype
    =retrieval>
    =np>
      dep1        =vp
      dep1.gf     adj
    =vp>
    -np>
     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'vp)
)

(p rrc-attach-dep2
    =goal>
      isa        parse
      goal-state rrc1
    =retrieval>
      isa        lex-ent
      post.ma.gf =rctype
    =np>
      isa        f-rep
      dep1       =anychunk0
      dep2       nil
    =vp>
      isa         f-rep
      predreqd    t
      ma          =np
    ==>
    !bind! =lddchunk (next-bigpro)
    =retrieval>
    =goal>
      goal-state  create
      ldd         =lddchunk
      lddopen     open
      lddtype     =rctype
    =np>
      dep2        =vp
      dep2.gf     adj
    =vp>
;      dep1        =prochunk
    -np>
    !safe-eval! (store-m-buffer-chunk 'vp =vp)
    !safe-eval! (add-to-chunk-set 'vp)
)


(p new-frep-noun
    !safe-eval! (list-slot-congruentp *noun* 'cat 'retrieval)
    =goal>
      isa  parse
      goal-state create
    =retrieval>
      isa   lex-ent
      predreqd no
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.cat =word.post.ma.cat
      post.ma.gf =word.post.ma.gf
      subcat =word.subcat
      pred   =word.pred
      subj   =word.subj
      obj    =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj    =word.adj
      adj.post =word.adj.post
      adj.post.cat =word.adj.post.cat
    ?np>
      buffer empty
    ==>
    =goal>
      locus  np
      goal-state attach
    +np>
      isa   f-rep
      cat   ((n plus) (v minus) (p minus) (adjcv minus) (adv minus))
      ma     =word.ma
      ma.cat =word.ma.cat
      deps 0
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.cat =word.post.ma.cat
      post.ma.gf =word.post.ma.gf
      predreqd nil
      pred  =word.pred
      subj  =word.subj
      obj   =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      adj.post =word.adj.post
      adj.post.cat =word.adj.post.cat
)

(p fill-vp-for-verb
  !safe-eval! (not (buffer-set-empty 'vp))
  !safe-eval! (not-neg 'v 'cat' retrieval)
  !safe-eval! (compilable-empty 'vp)
  =goal>
    isa        parse
    goal-state create
  ==>
  !safe-eval! (fill-buffer-from-set 'vp)
  =goal>
)

(p new-frep-verb
    !safe-eval! (compilable-empty 'vp)
    !safe-eval! (not-neg 'v 'cat 'retrieval)
    !safe-eval! (buffer-set-empty 'vp)
    =goal>
      isa  parse
      goal-state create
    =retrieval>
      isa   lex-ent
      predreqd no
      valency =word.valency
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pred   =word.pred
      subj   =word.subj
      obj    =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj    =word.adj
      pcase  =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
    ==>
    =goal>
      goal-state add-gfs
      locus  vp
    +vp>
      cat    ((v plus) (n minus) (adjcv minus) (adv minus) (p minus))
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      pred  =word.pred
      predreqd nil
      subj  =word.subj
      obj   =word.obj
      obl   =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pcase =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
)

(p new-frep-adverb
    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (not-neg 'v 'ma.cat 'retrieval)
    =goal>
      isa  parse
      goal-state create
    =retrieval>
      isa   lex-ent
      cat    =word.cat
      predreqd no
      valency 0
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pred   =word.pred
      subj   =word.subj
      obj    =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj    =word.adj
      pcase  =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
    ==>
    =goal>
      goal-state attach
      locus  ap
    +ap>
      cat    =word.cat
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      pred  =word.pred
      predreqd nil
      subj  =word.subj
      obj   =word.obj
      obl   =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pcase =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
)

(p new-frep-adjective
    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (not-neg 'n 'ma.cat 'retrieval)
    =goal>
      isa  parse
      goal-state create
    =retrieval>
      isa   lex-ent
      cat    =word.cat
      predreqd no
      valency 0
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pred   =word.pred
      subj   =word.subj
      obj    =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj    =word.adj
      pcase  =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
    ==>
    =goal>
      goal-state attach
      locus  ap
    +ap>
      cat    =word.cat
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      pred  =word.pred
      predreqd nil
      subj  =word.subj
      obj   =word.obj
      obl   =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pcase =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
)




(p add-noun-to-nopred-frep
    !safe-eval! (congruentp 'cat 'retrieval 'cat 'np)
    =goal>
      isa parse
      goal-state create
    =retrieval>
      isa   lex-ent
      predreqd no
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.cat =word.post.ma.cat
      post.ma.gf =word.post.ma.gf
      subcat =word.subcat
      pred  =word.pred
      subj  =word.subj
      obj   =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      adj.post =word.adj.post
      adj.post.cat =word.adj.post.cat
    =np>
      isa   f-rep
      predreqd t
    ==>
    =goal>
      goal-state attach
      locus np
    =np>
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.cat =word.post.ma.cat
      post.ma.gf =word.post.ma.gf
      subcat =word.subcat
      predreqd nil
      pred  =word.pred
      subj  =word.subj
      obj   =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      adj.post =word.adj.post
      adj.post.cat =word.adj.post.cat
    )

(p add-verb-to-nopred-frep-not-embedded
    !safe-eval! (compilable-empty 'np)
    !safe-eval! (congruentp 'cat 'retrieval 'cat 'vp)
    =goal>
      isa  parse
      goal-state create
    =retrieval>
      isa   lex-ent
      predreqd no
      valency =word.valency
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pred   =word.pred
      subj   =word.subj
      obj    =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj    =word.adj
      pcase  =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
    =vp>
      isa    f-rep
      embedded nil
      predreqd t
  <=  deps   =word.valency
    ==>
    =goal>
      goal-state add-gfs
      locus  vp
    =vp>
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      pred  =word.pred
      predreqd nil
      subj  =word.subj
      obj   =word.obj
      obl   =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pcase =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
)

(p add-verb-to-nopred-frep-embedded
    !safe-eval! (compilable-empty 'np)
    !safe-eval! (congruentp 'cat 'retrieval 'cat 'vp)
    !safe-eval! (congruentp 'ma.cat 'retrieval 'ma.cat 'vp)
    =goal>
      isa  parse
      goal-state create
    =retrieval>
      isa   lex-ent
      predreqd no
      valency =word.valency
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pred   =word.pred
      subj   =word.subj
      obj    =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj    =word.adj
      pcase  =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
    =vp>
      isa    f-rep
      embedded t
      predreqd t
  <=  deps   =word.valency
    ==>
    =goal>
      goal-state add-gfs
      locus  vp
    =vp>
      ma.cat =word.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.gf =word.post.ma.gf
      pred  =word.pred
      predreqd nil
      subj  =word.subj
      obj   =word.obj
      obl   =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      ggf1   =word.ggf1
      ggf2   =word.ggf2
      ggf3   =word.ggf3
      ggf1.stat =word.ggf1.stat
      ggf2.stat =word.ggf2.stat
      ggf3.stat =word.ggf3.stat
      pcase =word.pcase
      comp-poss =word.comp-poss
      gf.prec =word.gf.prec
      gf.post1 =word.gf.post1
      gf.post2 =word.gf.post2
      adj.post =word.adj.post
)



(p verb-closes-post-verb-attached-np
    !safe-eval! (not-neg 'v 'cat 'retrieval)
    =goal>
      isa        parse
      goal-state create
      locus      np
    =retrieval>
      isa        lex-ent
      cat        =anychunk1
    =np>
      isa        f-rep
      predreqd   nil
      ma         =anychunk0
    =vp>
      isa        f-rep
      predreqd   nil
    ==>
    =goal>
      goal-state wrapup
      locus      vp
    =retrieval>
    =vp>
    !safe-eval! (add-to-chunk-set 'np)
)

(p verb-closes-pre-verb-attached-np
    !safe-eval! (not-neg 'v 'cat 'retrieval)
    =goal>
      isa        parse
      goal-state create
      locus      np
    =retrieval>
;      isa        lex-ent
    =np>
      isa        f-rep
      predreqd   nil
      ma         =anychunk
    =vp>
      isa        f-rep
      predreqd   t
    ==>
    =goal>
      goal-state create
      locus      vp
    =retrieval>
    =vp>
    !safe-eval! (add-to-chunk-set 'np)
)


(p verb-closes-embedded-clause
    !safe-eval! (not-neg 'v 'cat 'retrieval)
    !safe-eval! (compilable-empty 'np)
    =goal>
      isa        parse
      goal-state create
    =retrieval>
      isa        lex-ent
      cat        =anychunk0
    =vp>
      isa        f-rep
      predreqd   nil
      ma         =anychunk1
    ==>
    =goal>
      goal-state wrapup
      locus      vp
    =retrieval>
    =vp>
)


(p new-frep-prep-np-empty
    !safe-eval! (list-slot-congruentp *prep* 'cat 'retrieval)
    =goal>
      isa  parse
      goal-state create
    =retrieval>
      isa   lex-ent
      predreqd no
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.cat =word.post.ma.cat
      post.ma.gf =word.post.ma.gf
      pred   =word.pred
      subj   =word.subj
      obj    =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj    =word.adj
      pcase  =word.pcase
      ggf1  =word.ggf1
      ggf1.stat =word.ggf1.stat
      gf.prec =word.gfprec
      gf.post1 =word.gfpost1
      adj.post =word.adj.post
      adj.post.cat =word.adj.post.cat
    ?np>
      buffer empty
    ?ap>
      buffer empty
    ==>
    =goal>
      locus  ap
      goal-state add-gfs
    +ap>
      isa   f-rep
      cat   ((n minus) (v minus) (p plus) (adjcv minus) (adv minus))
      ma     =word.ma
      ma.cat =word.ma.cat
      deps 0
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.cat =word.post.ma.cat
      post.ma.gf =word.post.ma.gf
      predreqd nil
      pred  =word.pred
      subj  =word.subj
      obj   =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      pcase =word.pcase
      ggf1 =word.ggf1
      ggf1.stat =word.ggf1.stat
      gf.prec =word.gfprec
      gf.post1 =word.gfpost1
      adj.post =word.adj.post
      adj.post.cat =word.adj.post.cat
)

(p vp-needs-prep-in-ap-dep2-clear-np
    !safe-eval! (list-slot-congruentp *prep* 'cat 'retrieval)
    !safe-eval! (congruentp 'post.ma.cat 'retrieval 'dep2.gf 'vp)
    =goal>
      isa     parse
      goal-state create
    =retrieval>
      isa      f-rep
      predreqd no
    =vp>
      isa      f-rep
      predreqd nil
      dep1     =anychunk0
      dep2     nil
    - dep2.gf  nil
    ?np>
      buffer   full
    ==>
    =goal>
      locus    ap
    =retrieval>
    =vp>
    -np>
)

(p vp-needs-prep-in-ap-dep3-clear-np
    !safe-eval! (list-slot-congruentp *prep* 'cat 'retrieval)
    !safe-eval! (congruentp 'post.ma.cat 'retrieval 'dep3.gf 'vp)
    =goal>
      isa     parse
      goal-state create
    =retrieval>
      isa      f-rep
      predreqd no
    =vp>
      isa      f-rep
      predreqd nil
      dep1     =anychunk0
      dep2     =anychunk1
      dep3     nil
    - dep3.gf  nil
    ?np>
      buffer   full
    ==>
    =goal>
      locus    ap
    =retrieval>
    =vp>
    -np>
)

(p vp-needs-prep-in-ap-dep4-clear-np
    !safe-eval! (list-slot-congruentp *prep* 'cat 'retrieval)
    !safe-eval! (congruentp 'post.ma.cat 'retrieval 'dep4.gf 'vp)
    =goal>
      isa     parse
      goal-state create
    =retrieval>
      isa      f-rep
      predreqd no
    =vp>
      isa      f-rep
      predreqd nil
      dep1     =anychunk0
      dep2     =anychunk1
      dep3     =anychunk2
      dep4     nil
    - dep4.gf  nil
    ?np>
      buffer   full
    ==>
    =goal>
      locus    ap
    =retrieval>
    =vp>
    -np>
)

(p new-frep-prep-np-full-no-vp-obl
    !safe-eval! (list-slot-congruentp *prep* 'cat 'retrieval)
    !safe-eval! (incongruent-or-not-cons 'post.ma.cat 'retrieval 'dep1.gf 'vp)
    !safe-eval! (incongruent-or-not-cons 'post.ma.cat 'retrieval 'dep2.gf 'vp)
    !safe-eval! (incongruent-or-not-cons 'post.ma.cat 'retrieval 'dep3.gf 'vp)
    !safe-eval! (incongruent-or-not-cons 'post.ma.cat 'retrieval 'dep4.gf 'vp)
    =goal>
      isa  parse
      goal-state create
    =retrieval>
      isa   lex-ent
      predreqd no
      ma     =word.ma
      ma.cat =word.ma.cat
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.cat =word.post.ma.cat
      post.ma.gf =word.post.ma.gf
      pred   =word.pred
      subj   =word.subj
      obj    =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj    =word.adj
      pcase  =word.pcase
      ggf1  =word.ggf1
      ggf1.stat =word.ggf1.stat
      gf.prec =word.gfprec
      gf.post1 =word.gfpost1
      adj.post =word.adj.post
      adj.post.cat =word.adj.post.cat
    ?np>
      buffer full
    ?ap>
      buffer empty
    ==>
    =goal>
      locus  ap
      goal-state add-gfs
    +ap>
      isa   f-rep
      cat   ((n minus) (v minus) (p plus) (adjcv minus) (adv minus))
      ma   =word.ma
      ma.cat =word.ma.cat
      deps 0
      pre.ma.cat =word.pre.ma.cat
      pre.ma.gf =word.pre.ma.gf
      post.ma.cat =word.post.ma.cat
      post.ma.gf =word.post.ma.gf
      predreqd nil
      pred  =word.pred
      subj  =word.subj
      obj   =word.obj
      obl    =word.obl
      obj-th =word.obj-th
      comp   =word.comp
      adj   =word.adj
      pcase =word.pcase
      ggf1 =word.ggf1
      ggf1.stat =word.ggf1.stat
      gf.prec =word.gfprec
      gf.post1 =word.gfpost1
      adj.post =word.adj.post
      adj.post.cat =word.adj.post.cat
)

(p start-embedded-comp-of-verb-dep2
    !safe-eval! (compilable-empty 'np)
    !safe-eval! (congruentp 'cat 'vp 'ma.cat 'retrieval)
    !safe-eval! (not-neg 'c 'dep2.gf 'vp)
    !bind! =thisgf (find-gf-match *ugflist* 'dep2.gf 'vp 'post.ma.gf 'retrieval)
    =goal>
      isa        parse
      goal-state create
    =retrieval>
      isa        lex-ent
      subcat     comp
      comp-poss  t
      string     =word.string
    =vp>
      isa        f-rep
      cat        =mother.cat
      predreqd   nil
      dep1       =anychunk0
      dep2       nil
    ==>
    =goal>
      goal-state setup-vcomp
      holdid1    =vp
      holdid2    dep2
      holdid3    dep2.gf
      holdid4    =thisgf
    @vp>
      isa        f-rep
      cat        ((adjcv minus) (adv minus) (n minus) (p minus) (v plus))
      predreqd    t
      ma          =vp
      ma.cat      =mother.cat
      embedded    t
      compform    =word.string
)


(p complete-embedding-comp-of-verb
  =goal>
    isa         parse
    goal-state  setup-vcomp
    holdid1     =chunk
    holdid2     =slot1
    holdid3     =slot2
    holdid4     =thisgf
  =vp>
    isa         f-rep
    ma          =chunk
  ==>
  =goal>
    goal-state  find
  =vp>
  !safe-eval! (set-chunk-slot-value-fct =chunk =slot1 =vp)
  !safe-eval! (set-chunk-slot-value-fct =chunk =slot2 =thisgf)
)


(p create-comp-of-noun
  !safe-eval! (compilable-empty 'ap)
  !safe-eval! (list-slot-congruentp *noun* 'cat 'retrieval)
  =goal>
    isa        parse
    goal-state create
  =retrieval>
    isa        lex-ent
    cat        =word.cat
    subcat     comp
    comp-poss  t
    pre.ma.cat =word.ma.cat
    pre.ma.gf  =word.ma.gf
    string     =thisstring
  =np>
    isa        f-rep
    cat        =mother.cat
    predreqd   nil
    comp       poss
  =vp>
  ==>
  =goal>
    goal-state setup-ncomp
  =np>
  @vp>
    isa         f-rep
    cat         ((adjcv minus) (adv minus) (n minus) (p minus) (v plus))
    predreqd    t
    ma          =np
    ma.cat      =mother.cat
    embedded    t
    compform    =thisstring
)

(p complete-comp-of-noun-gf1
  =goal>
    isa         parse
    goal-state  setup-ncomp
  =vp>
    isa         f-rep
    ma          =np
  =np>
    isa         f-rep
    dep1        nil
  ==>
  =goal>
    goal-state  find
  =vp>
  =np>
    dep1        =vp
    dep1.gf     comp
  -np>
;  !safe-eval! (add-chunk-to-chunk-set 'vp)
)


(p relpro-setup-np-comp-not-poss
    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (list-slot-congruentp *noun* 'cat 'retrieval)
    =goal>
      isa        parse
      goal-state create
    =retrieval>
      isa        lex-ent
      cat        =word.cat
      subcat     comp
      rel        poss
      pre.ma.cat =word.ma.cat
      pre.ma.gf  =word.ma.gf
    =np>
      isa        f-rep
      cat        =mother.cat
      predreqd   nil
      comp       no
    =vp>
;    ?aux>
;      buffer     empty
    ==>
    =goal>
      goal-state relpro
    =retrieval>
    @vp>
      isa         f-rep
      cat         ((adjcv minus) (adv minus) (n minus) (p minus) (v plus))
      predreqd    t
      ma          =np
      ma.cat      =mother.cat
      embedded    t
    =np>

)

(p relpro-setup-pron-comp-not-poss
    !safe-eval! (compilable-empty 'ap)
    !safe-eval! (list-slot-congruentp *noun* 'cat 'retrieval)
    =goal>
      isa        parse
      goal-state create
    =retrieval>
      isa        lex-ent
      cat        =word.cat
      subcat     comp
      rel        poss
      comp-poss  no
      pre.ma.cat =word.ma.cat
      pre.ma.gf  =word.ma.gf
    =np>
      isa        f-rep
      cat        =mother.cat
      predreqd   nil
    =vp>
    ==>
    =goal>
      goal-state relpro
    =retrieval>
    @vp>
      isa         f-rep
      cat         ((adjcv minus) (adv minus) (n minus) (p minus) (v plus))
      predreqd    t
      ma          =np
      ma.cat      =mother.cat
      embedded    t
    =np>

)


(p relclause-attach-dep1
    =goal>
      isa        parse
      goal-state relpro
    =retrieval>
      isa        lex-ent
      rel        poss
    =np>
      isa        f-rep
      dep1       nil
    =vp>
      isa         f-rep
      predreqd    t
      ma          =np
    ==>
    =goal>
      goal-state relpro1
    =retrieval>
    =np>
      dep1        =vp
      dep1.gf     adj
    =vp>
    -np>
     !safe-eval! (store-m-buffer-chunk 'vp =vp)
     !safe-eval! (add-to-chunk-set 'vp)
)

(p relclause-attach-dep2
    =goal>
      isa        parse
      goal-state relpro
    =retrieval>
      isa        lex-ent
      cat        relpro
      rel        poss
      pre.ma.cat =word.ma.cat
      pre.ma.gf  =word.ma.gf
    =np>
      isa        f-rep
      dep1       =anychunk0
      dep2       nil
    =vp>
      isa         f-rep
      predreqd    t
      ma          =np
    ==>
    =retrieval>
    =goal>
      goal-state relpro1
    =np>
      dep2        =vp
      dep2.gf     adj
    =vp>
    -np>
    !safe-eval! (store-m-buffer-chunk 'vp =vp)
    !safe-eval! (add-to-chunk-set 'vp)
)


(p create-relpro-chunk
  =goal>
    isa         parse
    goal-state relpro1
  =retrieval>
    isa        lex-ent
    cat        =word.cat
    rel        poss
    ma         =word.ma
    pre.ma.cat =word.ma.cat
    pre.ma.gf  =word.ma.gf
    post.ma.gf =word.post.ma.gf
    adj.post   =word.adj.post
  ?np>
    buffer     empty
  ==>
  !bind! =propred (next-smallpro)
  =goal>
    goal-state relpro2
    lddopen     open
  +np>
    isa         f-rep
    cat         =word.cat
    predreqd    nil
    pred        =propred
    ma          =word.ma
    pre.ma.cat  =word.ma.cat
    pre.ma.gf   =word.ma.gf
    post.ma.gf  =word.post.ma.gf
    adj.post    =word.adj.post
)


(p note-relpro-cat
  =goal>
    isa        parse
    goal-state relpro2
  =np>
    isa        f-rep
    post.ma.gf =word.post.ma.gf
  ==>
  =goal>
    goal-state attach
    ldd        =np
    lddtype    =word.post.ma.gf
  =np>
)
