;;; This work is licensed under the Creative Commons
;;; Attribution-NonCommercial-ShareAlike 4.0 International License.
;;; To view a copy of this license, visit
;;; http://creativecommons.org/licenses/by-nc-sa/4.0/ or send a letter to
;;; Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

;;; Core model developed as part of the DPhil thesis "Modelling an incremental
;;; theory of Lexical Functional Grammar" submitted by Stephen Jones to the
;;; University of Oxford on 3 July 2019

(clear-all)


;;; Lisp wraparound code
 (load "timestamp.lisp") ; Code to generate the output file
 (load "control.lisp") ; Experimental control code (Lisp)
 (load "test-items.lisp") ; Sentences to be modelled (as global functions)
 (load "output.lisp") ; Functions to output a graph structure

 (setf *run-directory* (create-output-directory (datestamp) (timestamp)))
 (setf *run-index* 0)



(define-model lfgmodel


;;; Model - settings
(new-output-file-set *run-directory* (timestamp)) ; resets *outputfile* and *outputfile-graph*

(update-message-csv1 *outputfile* 'Timestamp 'Run 'Sentence 'Index 'Word 'Cycle-time)
(sgp-fct (list :cmdt t ))
(load "settings.lisp") ; Chunk definitions and constants
(load "functions.lisp") ; Supplementary functions for !safe-eval!

; ensure that there can be production compilation
(specify-compilation-buffer-type vp goal)
(specify-compilation-buffer-type np goal)
(specify-compilation-buffer-type aux goal)

;;; Model - declarative memory

(load "lexicon-en.lisp") ; English lexical entries (as lexical chunks)
(load "lexicon-kr.lisp") ; Korean lexical entries (as lexical chunks)

;;; Model - procedural memory

(load "read-from-screen.lisp") ;
(load "process1b.lisp") ;
(load "process2b.lisp") ;
(load "process3b.lisp") ;
(load "process4b.lisp") ;

(spp end-parse :u 20 :fixed-utility t) ; massive utility for ending the parse at '*'


;;; TO RUN A TEST SENTENCE, UNCOMMENT IT BY REMOVING
;;; THE SEMICOLON FROM THE START OF THE RELEVANT LINE
;;; MAKE SURE ALL OTHER runtest LINES ARE COMMENTED OUT WITH A SEMICOLON
;;; OTHERWISE YOU GET A WARNING AND ONLY THE LAST UNCOMMENTED LINE RUNS


;;; ENGLISH MONOCLAUSAL SENTENCES

(runtest *testtrans1*)   ; ex (185)
;(runtest *testintrobl1*) ; ex (186)
;(runtest *testtrobl1*)   ; ex (187)
;(runtest *ditr-objth*)   ; ex (188)
;(runtest *ditr-datalt*)  ; ex (189)

;;; KOREAN MONOCLAUSAL SENTENCES

;(runtest *testktrans0*)   ; ex (190)
;(runtest *testktrans1*)   ; ex (191)
;(runtest *testkditrans0*) ; ex (192)

;;; ENGLISH COMPLEX SENTENCES

;(runtest *testrc7*)        ; ex (193) subject of matrix clause modified by SRC
;(runtest *testrc8*)        ; ex (194) subject of matrix clause modified by ORC
;(runtest *testrc1*)        ; ex (195) object of matrix clause modified by SRC
;(runtest *testrc9*)        ; ex (196) object of matrix clause modified by ORC

;(runtest *tr-rrc-on-subj*) ; ex (197) RRC on subj of matrix trans vb
;(runtest *tr-rrc-on-obj*)  ; ex (198) RRC on obj of matrix trans vb

;(runtest *kwoneng01a*)     ; ex (199)


;;; KOREAN COMPLEX SYNTAX - SENTENCE PAIRS FROM KWON 2010

;(runtest *kwon-smodorc*)       ; ex (201a)
;(runtest *kwon-smodsrc*)       ; ex (201b)

;(runtest *kwon-scram-omodorc*) ; ex (202a)
;(runtest *kwon-scram-omodsrc*) ; ex (202b)

;(runtest *kwon-insitu-omodorc*); ex (203a)
;(runtest *kwon-insitu-omodsrc*); ex (203b)


;;; ENGLISH - CONTEXT DEPENDENT PROCESSING OF RRCs

;(runtest *ditr-rrc-on-subj*)   ; ex (208)
;(runtest *ditr-rrc-on-objth*)  ; ex (209)
;(runtest *ditr-rrc-gpath*)     ; ex (210)


;;; KOREAN - IMPACT OF PROSODY
;;; SENTENCE PAIRS FROM KWON 2010 WITH PROSODIC BREAK AFTER FIRST NP

;(runtest *kwon-insitu-omodsrc-prosody*); ex (212) with prosodic break
;(runtest *kwon-insitu-omodorc-prosody*); ex (213) with prosodic break

;(runtest *kwon-smodorc-prosody*)       ;
;(runtest *kwon-smodsrc-prosody*)       ; ex (214) with prosodic break

;(runtest *kwon-scram-omodorc-prosody*) ;
;(runtest *kwon-scram-omodsrc-prosody*) ;

;;; END OF TEST SENTENCES



(goal-focus goal) ; sets the model to the initial state


  )
