;;; This work is licensed under the Creative Commons
;;; Attribution-NonCommercial-ShareAlike 4.0 International License.
;;; To view a copy of this license, visit
;;; http://creativecommons.org/licenses/by-nc-sa/4.0/ or send a letter to
;;; Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

;;; Auxiliary code for lfmodel.lisp
;;; Setup function to ensure that I always start at the same place
;;; Working directory needs to be the directory with the module and model

(defun startlfg ()

;; load ACT-R 7
          (load "[ABSOLUTE PATH TO ACT-R]/load-act-r.lisp")

;; load any modules that I've written
          (load "lfgsyntax.lisp")

;; wait for user confirmation envt is ready,
;; then start the environment
          (format t "Opening the environment: enter OK when done :-) ")
          (run-program "open" '("[ABSOLUTE PATH TO ACT-R]/environment/Start Environment OSX.app") )
          (read)
          (format t "Loading the current model")
          (start-environment)
          (sleep 10)

;; load the model
          (load "lfgmodel.lisp")

          )
