;;; This work is licensed under the Creative Commons
;;; Attribution-NonCommercial-ShareAlike 4.0 International License.
;;; To view a copy of this license, visit
;;; http://creativecommons.org/licenses/by-nc-sa/4.0/ or send a letter to
;;; Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.


;;; Once model is loaded, this allows multiple runs to take place automatically
;;; using the test sentence specified as the argument of (runtest) in
;;; framework.lisp

(defvar *window*)

;;; Chunk collection variable
(defvar *f-rep-chunks* ())

;;; Timing variables
(defvar *cycle-time*)
(defvar *cycle-start*)
(defvar *run-index-time* (timestamp))
(defvar *runtimes-index-time* *run-index-time*)

;;; Tracking variables
(defvar *this-word*)
(defvar *index*)
(defvar *sent-ref*)
(defvar *run-index*)


;; RUNTIMES has been amended from the original code: the two (reset) functions
;; have been deleted and instead the (goal-focus goal) allows the production
;; compilation elements to be stored between runs

(defun runtimes (iterations)
  (setf *runtimes-index-time* (timestamp))
  (dotimes (index iterations)
          ;(command-output "~A" "=======")
              ;(command-output "Run ~4d" iterations)
              (goal-focus goal) ;(reset)
              (run 10)
              (setf *run-index* (+ *run-index* 1))
    )

)




(defun runtest (display-variable)
     (let ((sentence-ref (first display-variable))
           (display-text (second display-variable)))


      (setf *sent-ref* sentence-ref)
      (setf *run-index-time* (timestamp))
      (new-output-graphfile *run-directory* *run-index-time*)
;      (sgp-fct (list :cmdt *outputfile* ))
      (setf *window* (open-exp-window "Sentence to parse" :width 1000 :height 200))
      (install-device *window*)
      (clear-exp-window)
      (add-text-to-exp-window :text display-text :x 20 :y 100)


      (proc-display :clear t)

      (setf *f-rep-chunks* ()) ; remove this if not capturing new chunks

))

;;; Production path

(defvar *production-path* ())

(defun production-path-increment (production)
        (setf *production-path* (cons production *production-path*)))





;;; Output functions

(defun update-message-retrieving (text)
      (command-output "~d - Retrieving ~a" (mp-time) text
        )
)

(defun update-message-retrieved (time text)
      (command-output "Retrieved ~A in ~D s" text (- (mp-time) time)
        )
)

(defun update-message-attached (index text length time non-prod-time reference)
      (command-output "~D,~A,~D,~D,~D,~A" index text length time non-prod-time reference)
 )

(defun update-message-timings (index text retrieve attachment)
      (command-output "~2D, ~13A, retrieved, ~4D, attached, ~4D" index text retrieve attachment
        )
)

(defun update-message-csv (thisrun thissent index word cycletime)
    (command-output "~20D,~5A,~3D,~20A,~5D" thisrun thissent index word cycletime))


(defun update-message-csv1 (filepath thisbatch thisrun thissent index word cycletime)
    (with-open-file (stream filepath
                     :direction :output
                     :if-exists :append
                     :if-does-not-exist :create)
        (format stream "~20D,~3D,~5A,~3D,~20A,~5D~%" thisbatch thisrun thissent index word cycletime)))

(defvar *refcode* "")
(defvar *this-word* "")
;(defun trial ()
;    (runtest *kj91-src*))
