colmap=load('colmap.dat','-ascii');
colordef white

fprintf(['[\bBy default, this script will plot all 20 panels \n]\b' ...
    '[\bin individual figures. This may take up to a minute.\n]\b'])


%% Zero field data (panel A) (adapted from Fig 3B of ref [5] R. Coldea et al, Science 327, 177 (2010))
f=figure;
plot_color_fig('0T_1.dat',1) %plot smoothed intensities
%plot_color_fig('0T5_2.dat',1,0) %plot raw intensities
%plot_color_fig('0T5_2.dat',1,-1) %plot errors
hold on
plot_color_fig('0T_2.dat',1,1,[1 3 -1]) 
% the last argument is such that the plotted horizontal widths of the bins at the edge of this data 
% set are wider, such that there are no gaps left in the region in-between the two plotted data sets  
format_figure(1);
colormap(colmap)
caxis([0 0.4])
children=get(gca,'children');
children(1).XData=-children(1).XData;
children(2).XData=-children(2).XData;

set(f,'Name','Paper Figure 2A')
drawnow;

%% 0T ED (panel B)
f=figure;
plot_color_fig('0T_ED.dat',0)
format_figure(0);
colormap(colmap);

set(f,'Name','Paper Figure 2B')
drawnow;

%% 0T two soliton (panel C)
f=figure;
plot_color_fig('0T_twosoliton.dat',0)
format_figure(0);
colormap(colmap)

set(f,'Name','Paper Figure 2C')
drawnow;

%% 0T perturbative about localized limit (panel D)
f=figure;
plot_color_fig('0T_analytic.dat',0)
format_figure(0);
colormap(colmap)
hold on
plot_patches('0T_analytic.xy')

set(f,'Name','Paper Figure 2D')
drawnow;

%% 0.5T data (panel E)
f=figure;
plot_color_fig('0T5_2.dat',1) %plot smoothed intensities
%plot_color_fig('0T5_2.dat',1,0) %plot raw intensities
%plot_color_fig('0T5_2.dat',1,-1) %plot errors
hold on
plot_color_fig('0T5_1.dat',1)
format_figure(1);
colormap(colmap)

set(f,'Name','Paper Figure 2E')
drawnow;

%% 0.5T ED (panel F)
f=figure;
plot_color_fig('0T5_ED.dat',0)
format_figure(0);
colormap(colmap);

set(f,'Name','Paper Figure 2F')
drawnow;

%% 0.5T two soliton (panel G)
f=figure;
plot_color_fig('0T5_twosoliton.dat',0)
format_figure(0);
colormap(colmap);

set(f,'Name','Paper Figure 2G')
drawnow;

%% 0.5T perturbative about localized limit (panel H)
f=figure;
plot_color_fig('0T5_analytic.dat',0)
format_figure(0);
colormap(colmap)
hold on
plot_patches('0T5_analytic.xy');

set(f,'Name','Paper Figure 2H')
drawnow;

%% 1.0T data (panel I)
f=figure;
plot_color_fig('1T0_2.dat',1) %plot smoothed intensities
hold on
plot_color_fig('1T0_1.dat',1)
format_figure(1);
colormap(colmap)

set(f,'Name','Paper Figure 2I')
drawnow;

%% 1.0T ED (panel J)
f=figure;
plot_color_fig('1T0_ED.dat',0)
format_figure(0);
colormap(colmap)

set(f,'Name','Paper Figure 2J')
drawnow;

%% 1.0T two soliton (panel K)
f=figure;
plot_color_fig('1T0_twosoliton.dat',0)
format_figure(0);
colormap(colmap)

set(f,'Name','Paper Figure 2K')
drawnow;

%% 1.0T perturbative about localized limit (panel L)
f=figure;
plot_color_fig('1T0_analytic.dat',0)
format_figure(0);
colormap(colmap)
hold on
plot_patches('1T0_analytic.xy')

set(f,'Name','Paper Figure 2L')
drawnow;

%% 1.5T data (panel M)
figure;
plot_color_fig('1T5_2.dat',1) %plot smoothed intensities
hold on
plot_color_fig('1T5_1.dat',1)
format_figure(1);
colormap(colmap)

set(f,'Name','Paper Figure 2M')
drawnow;

%% 1.5T ED (panel N)
f=figure;
plot_color_fig('1T5_ED.dat',0)
format_figure(0);
colormap(colmap)

set(f,'Name','Paper Figure 2N')
drawnow;

%% 1.5T two soliton (panel O)
f=figure;
plot_color_fig('1T5_twosoliton.dat',0)
format_figure(0);
colormap(colmap)

set(f,'Name','Paper Figure 2O')
drawnow;

%% 1.5T perturbative about localized limit (panel P)
f=figure;
plot_color_fig('1T5_analytic.dat',0)
format_figure(0);
colormap(colmap)
hold on
plot_patches('1T5_analytic.xy')

set(f,'Name','Paper Figure 2P')
drawnow;

%% 2.5T data (panel Q)
f=figure;
plot_color_fig('2T5_2.dat',1) %plot smoothed intensities
hold on
plot_color_fig('2T5_1.dat',1)
format_figure(1);
colormap(colmap)

set(f,'Name','Paper Figure 2Q')
drawnow;

%% 2.5T ED (panel R)
f=figure;
plot_color_fig('2T5_ED.dat',0)
format_figure(0);
colormap(colmap)

set(f,'Name','Paper Figure 2R')
drawnow;

%% 2.5T two soliton (panel S)
f=figure;
plot_color_fig('2T5_twosoliton.dat',0)
format_figure(0);
colormap(colmap)

set(f,'Name','Paper Figure 2S')
drawnow;

%% 2.5T perturbative about localized limit (panel T)
f=figure;
plot_color_fig('2T5_analytic.dat',0)
format_figure(0);
colormap(colmap)
hold on
plot_patches('2T5_analytic.xy')

set(f,'Name','Paper Figure 2T')
drawnow;

%% Plotting functions

function hout=plot_color_fig(fdata,isData,flag,xscale)
% Plots color data in .dat file, with isErr specifying if the input
% .dat file contains a column for errors (i.e. if experimental data); and
% flag specifying whether to plot smoothed intensities (flag=1 - default),
% raw intensities (flag=0), or errors (flag=-1).
% Additionally evaluates code strings specified as optional arguments.
% xscale =[p f side=+/-] is an optional scale factor for the xwidth of column number
% p on the + or - side=+/-1 (p = integer between 1 and size(X,2) number of columns) 
% this can be of the form [p1 f1 s1; p2 f2 s2;...] 

if ~exist('flag','var') %By default, set flag to 1
    flag=1;
end

if isData %Experimental data
    fdata=importdata(fdata,' ',1);
    sz=eval(fdata.textdata{1}); 
    % Reshape to 2D array for plotting
    X=reshape(fdata.data(:,1),sz);
    Y=reshape(fdata.data(:,end-3),sz);
switch flag
    case -1 %Plot errors
        C=reshape(fdata.data(:,end-1),sz);
    case 0 %Raw intensities
        C=reshape(fdata.data(:,end-2),sz);
    case 1 %Smoothed intensities
        C=reshape(fdata.data(:,end),sz);
end
else %Calculated energy levels
    fdata=importdata(fdata,' ',3);
    k=eval(fdata.textdata{1});
    E=eval(fdata.textdata{2});
    width=eval(fdata.textdata{3});
    [X,Y]=meshgrid(k,E);
    C=zeros(size(X));
    for ii=1:size(fdata.data,1)
        kidx=find(abs(k-fdata.data(ii,1))<1e-4,1);
        C(:,kidx)=C(:,kidx)+fdata.data(ii,3)*exp(-(E'-fdata.data(ii,2)).^2/width^2)/(width*sqrt(pi));
    end
end

% from (X,Y) bin centers construct arrays of bin edges (Xb,Yb) 
% X,Y,C(n,m)  Xb,Yb,Cb(n+1,m+1)
[Xb,Yb,Cb]=cen2edge(X,Y,C);  

if exist('xscale','var')&&~isempty(xscale)&&isnumeric(xscale)&&(size(xscale,2)==3)&&(all(xscale(:,1))<=size(X,2))
    [~,perm]=sort(xscale(:,1));
    xscale=xscale(perm,:);
    for i=1:size(xscale,1)
        j=xscale(i,1);
        xwidth=Xb(:,j+1)-Xb(:,j);
        cen=(Xb(:,j+1)+Xb(:,j))/2;
        switch xscale(i,3)
            case {-1}, Xb(:,j)=cen-xwidth/2*xscale(i,2);
            case {+1}, Xb(:,j+1)=cen+xwidth/2*xscale(i,2);
            otherwise
                fprintf(2,'xscale=[p f s]; s expected to be -/+1 for left/right side of boundary to be scaled\n');
                hout=[];
                return
        end
    end
end
h=pcolor(Xb,Yb,Cb);
shading flat

isNum=~isnan(Cb);
axis([min(Xb(isNum)) max(Xb(isNum)) min(Yb(isNum)) max(Yb(isNum))])

if nargout>0
    hout=h;
end
end

function [xb,yb,zz]=cen2edge(x,y,z)
xx=(x(:,1:(end-1))+x(:,2:end))/2;
x1=x(:,1)-(-x(:,1)+xx(:,1));
xn=x(:,end)+(x(:,end)-xx(:,end));
xb=[x1 xx xn];
xb(end+1,:)=xb(end,:);
yy=(y(1:(end-1),:)+y(2:end,:))/2;
y1=y(1,:)-(-y(1,:)+yy(1,:));
yn=y(end,:)+(y(end,:)-yy(end,:));
yb=[y1;yy;yn];
yb(:,end+1)=yb(:,end);
zz=z;
zz(end+1,:)=NaN;
zz(:,end+1)=NaN;
end

function plot_patches(filename)
try
    fdata=readmatrix(filename,'FileType','text');
catch % for older versions of Matlab
    fdata=load(filename,'-ascii');
end
kpoints=fdata(:,1);
Epoints=-2.5:0.05:5;

plot(kpoints,fdata(:,2:7),'Color',[0.5 0.5 0.5],'LineWidth',1)

[kk,EE]=meshgrid(kpoints,Epoints);
EE=EE+kk;
inpatch1=EE>fdata(:,2)'&EE<fdata(:,3)';
inpatch2=EE>fdata(:,4)'&EE<fdata(:,5)';
kk(~(inpatch1|inpatch2))=NaN;
plot(kk',EE','Color',[0.5 0.5 0.5],'LineWidth',1);

[kk,EE]=meshgrid(kpoints,Epoints);
EE=EE-kk;
inpatch3=EE>fdata(:,6)'&EE<fdata(:,7)';
kk(~(inpatch3))=NaN;
plot(kk',EE','Color',[0.5 0.5 0.5],'LineWidth',1);

end


function format_figure(isData)
a=gca;
f=gcf;
f.Color=[1 1 1];
a.Color=[1 1 1];
xlim([-0.3 1.45]);
ylim([0.94 3.25]);
axis normal;
a.DataAspectRatio=[ 0.82133         1.32      0.93867];
a.PlotBoxAspectRatio=[1.2175            1       1.2175];
a.XAxis.Color=[0 0 0];
a.YAxis.Color=[0 0 0];
set(gca,'Layer','top')
a.LineWidth=1.5;
f.Position=[764   260   615   477];
a.Position=[0.13         0.11      0.66263        0.815];
a.YLabel.String='Energy (meV)';
box on;
if isData
    caxis([0 0.00015])
else
    caxis([0 1])
end
a.FontSize=22;
a.YLabel.FontSize=24;
a.XLabel.FontSize=24;
a.XLabel.String='{\itl} \rm(r.l.u.)';
title('')
end
