function d = read_nxs_sextants(filename,varargin)
%
% d = read_nxs_sextants(filename);
%   reads nexus file
% d = read_nxs_sextants(filename,'info',info,...)
%   uses nexus structure from info (saves a lot of time)
% d = read_nxs_sextants(filename,...,fieldname1,fieldname2,...)
%   reads only specific fields from nexus file
% d = read_nxs_sextants(filename,...,'except',fieldname1,fieldname2,...)
%   reads all fields except specific fields (convenient to skip fields such as images)
%
% G Beutier 04.06.2014

% display('SO FAR WORKS ONLY ON LINUX SYSTEMS!!!')

info_flag = any(strcmp('info',varargin));
except_flag = any(strcmp('except',varargin));

if info_flag
    infotag = find(strcmp('info',varargin),1,'first');
    info = varargin{infotag+1};
else
    display(['reading structure of ',filename])
    info = h5info(filename);
end
display(['reading ',filename])
d.nxs_structure = info;
d.file.name = info.Filename;
for k=1:length(info.Attributes)
    name = info.Attributes(k).Name;
    value = info.Attributes(k).Value;
    eval(['d.file.',name,'=value;']);
end

for k=1:length(info.Groups.Datasets)
    groupname = info.Groups.Name;
    name = info.Groups.Datasets(k).Name;
    dataname = fullfile(groupname,name);
    %%% Windows dodgy workaround:
    dataname = [groupname '/' name];
    data = h5read(filename,dataname);
    eval(['d.scan.',name,'=data;']);
end

for g=1:numel(info.Groups.Groups)
    groupname = info.Groups.Groups(g).Name;
    if strcmp(groupname,'/unnamed_001/SEXTANTS')
        SEXTANTS = info.Groups.Groups(g).Groups;
        break
    end
end
% for s=1:length(SEXTANTS)
%     name1 = SEXTANTS(s).Name;
% for k=1:length(SEXTANTS(s).Datasets)
%     name = SEXTANTS(s).Datasets(k).Name;
%     data = h5read(filename,fullfile(groupname,name1,name));
%     eval(['d.SEXTANTS.',name1,'.',name,'=data;']);
% end
% end

% for g=numel(SEXTANTS.Groups):-1:1
%     String = SEXTANTS.Groups(g).Name;
%     String = regexprep(String,'/a/SEXTANTS/','SEXTANTS.');
%     String = regexprep(String,'/','.');
%     String = regexprep(String,'-','_');
%     String = regexprep(String,'#','');
%     try
%         eval([String,'=SEXTANTS.Groups(g);']);
%         SEXTANTS.Groups(g) = [];
%     end
% %     if strcmp(SEXTANTS.Groups(g).Name,fullfile(SEXTANTS.Name,'FiltersBPs'))
% %         SEXTANTS.FiltersBP = SEXTANTS.Groups(g);
% %         SEXTANTS.Groups(g) = [];
% %     elseif strcmp(SEXTANTS.Groups(g).Name,fullfile(SEXTANTS.Name,'Undulator'))
% %         SEXTANTS.Undulator = SEXTANTS.Groups(g);
% %         SEXTANTS.Groups(g) = [];
% %     elseif strcmp(SEXTANTS.Groups(g).Name,fullfile(SEXTANTS.Name,'diffractometer'))
% %         SEXTANTS.diffractometer = SEXTANTS.Groups(g);
% %         SEXTANTS.Groups(g) = [];
% %     elseif strcmp(SEXTANTS.Groups(g).Name,fullfile(SEXTANTS.Name,'Monochromator'))
% %         SEXTANTS.Monochromator = SEXTANTS.Groups(g);
% %         SEXTANTS.Groups(g) = [];
% %     end
% end

%%% FiltersBPs
% for k=1:numel(SEXTANTS.FiltersBPs.Groups)
%     groupname = SEXTANTS.FiltersBPs.Groups(k).Name;
%     name = SEXTANTS.FiltersBPs.Groups(k).Datasets.Name;
%     data = h5read(filename,fullfile(groupname,name));
%     eval(['d.filters(',num2str(k),')=data;']);
% end
% d.filters = d.filters(:);

%%% undulator
% for g=1:numel(SEXTANTS.Undulator.Groups)
%     group = SEXTANTS.Undulator.Groups(g);
%     for k=1:length(group.Datasets)
%         name = group.Datasets(k).Name;
%         data = h5read(filename,fullfile(group.Name,name));
%         String = regexprep(fullfile(group.Name,name),'/a/','d.');
%         String = regexprep(String,'/','.');
%         String = regexprep(String,'-','_');
%         String = regexprep(String,'#','');
%         eval([String,'=data;']);
%     end
% end

%%% diffractometer
% for k=1:length(SEXTANTS.diffractometer.Datasets)
%     name = SEXTANTS.diffractometer.Datasets(k).Name;
%     data = h5read(filename,fullfile(SEXTANTS.diffractometer.Name,name));
%     String = regexprep(fullfile(SEXTANTS.diffractometer.Name,name),'/a/','d.');
%     String = regexprep(String,'/','.');
%     eval([String,'=data;']);
% %     eval(['d.SEXTANTS.diffractometer.',name,'=data;']);
% end
% for g=1:numel(SEXTANTS.diffractometer.Groups)
%     group = SEXTANTS.diffractometer.Groups(g);
%     for k=1:length(group.Datasets)
%         name = group.Datasets(k).Name;
%         data = h5read(filename,fullfile(group.Name,name));
% %         String = regexprep(fullfile(group.Name,name),'/a/','d.');
% %         String = regexprep(String,'/','.')
% %         eval([String,'=data;']);
%        eval(['d.SEXTANTS.diffractometer.pseudomotor(',num2str(g),').',name,'=data;']);
%     end
% end
% d.chi = d.SEXTANTS.diffractometer.pseudomotor(1).position;
% d.omega = d.SEXTANTS.diffractometer.pseudomotor(3).position;
% d.phi = d.SEXTANTS.diffractometer.pseudomotor(5).position;
% % d.euler = [d.omega d.chi d.phi];
% d.psi = d.SEXTANTS.diffractometer.pseudomotor(7).position;
% d.Q = d.SEXTANTS.diffractometer.pseudomotor(9).position;
% d.tth = d.SEXTANTS.diffractometer.pseudomotor(11).position;
% 
%%% data
group = info.Groups.Groups(4);
% groupname = 'scan_data';
groupname = 'data';
if (nargin-2*info_flag)==1
    for k=1:length(group.Datasets)
        name = group.Datasets(k).Name;
        dataname = fullfile(group.Name,name);
        %%% Windows dodgy workaround:
        dataname = [group.Name '/' name];
        data = h5read(filename,dataname);
        eval(['d.',groupname,'.',name,'=data;']);
    end
else
    if except_flag
        v = find(strcmp('except',varargin),1,'first');
        for k=1:length(group.Datasets)
            name = group.Datasets(k).Name;
            if ~any(strcmp(name,varargin(v+1:end)))
                dataname = fullfile(group.Name,name);
                %%% Windows dodgy workaround:
                dataname = [group.Name '/' name];
                data = h5read(filename,dataname);
                eval(['d.',groupname,'.',name,'=data;']);
            end
        end
    else
        for v=(1+2*info_flag):(nargin-1)
            name = varargin{v};
            dataname = fullfile(group.Name,name);
            %%% Windows dodgy workaround:
            dataname = [group.Name '/' name];
            data = h5read(filename,dataname);
            eval(['d.',groupname,'.',name,'=data;']);
        end
    end
end
