%% 12.01.2017 by Nicholas Bukin and Erick Burgos-Parra

location = 'D:\Beamtime Data\Soleil Jul22\';
cd(location)

%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Get Images  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ang = 45;
% RF_width = 20;
% energy = 707;

delay = 874.25;

file1 = 527;
file2 = 528;

% Image 1
pos = ['scan_0',num2str(file1),'.nxs'];
nxs = read_nxs_sextants(pos);
ccdP = nxs.data.data_20;
ccdP = double(ccdP);

minccdP = min(ccdP(:));
maxccdP = max(ccdP(:));
medccdP = median(ccdP(:));
meanccdP = mean(ccdP(:));
meanccdP = round(meanccdP);
sumccdP = sum(ccdP(:));

impc = ccdP'; clear ccdP
MINimpc = min(impc(:));
MAXimpc = max(impc(:));

% threshold = 0;
% figure('name', 'Positive Histogram')
% hist(ccdP(:),minccdP:(medccdP-minccdP)/1000:meanccdP)
% hold all, plot(threshold,0:100:1e4,'-r'), hold off
% xlim([minccdP meanccdP])

figure('name','Pos Diffraction Pattern')
imagesc(max(0,impc)), axis image xy, colormap jet

figure('name','Pos Diffraction Pattern log')
imagesc(log10(max(0,impc))), axis image xy, colormap jet, % logcolorbar


% Image 2
neg = ['scan_0',num2str(file2),'.nxs'];
nxs = read_nxs_sextants(neg);
ccdN = nxs.data.data_20;
ccdN = double(ccdN);

minccdN = min(ccdN(:));
maxccdN = max(ccdN(:));
medccdN = median(ccdN(:));
meanccdN = mean(ccdN(:));
meanccdN = round(meanccdN);
sumccdN = sum(ccdN(:));

imnc = ccdN';clear ccdN
MINimnc = min(imnc(:)); 

MAXimnc = max(imnc(:));

% threshold = 0;
% figure('name', 'Negative Histogram')
% hist(ccdN(:),minccdN:(medccdN-minccdN)/1000:meanccdN)
% hold all, plot(threshold,0:100:1e4,'-r'), hold off
% xlim([minccdN meanccdN])
clear nxs
figure('name','Neg Diffraction Pattern')
imagesc(max(0,imnc)), axis image xy, colormap jet

figure('name','Neg Diffraction Pattern Log')
imagesc(log10(max(0,imnc))), axis image xy, colormap jet, % logcolorbar

%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Normalize  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% py is x, px is y
normpy = 1022; normpx = 1023;  % 43 degree
dy = 150; dx = 200;  % dy is x, dx is y
xregion = 750; yregion = 2000;

hologram_c = (impc+imnc)/2;

pos_norm = impc(normpx-dx/2:normpx+dx/2,normpy-dy/2:normpy+dy/2);
neg_norm = imnc(normpx-dx/2:normpx+dx/2,normpy-dy/2:normpy+dy/2);

%pos_n = n*((impc)/mean(pos_norm(:))); clear impc
%neg_n = imnc/mean(neg_norm(:)); clear imnc
scaledpos = impc/mean(pos_norm(:)); clear impc
scaledneg = imnc/mean(neg_norm(:)); clear imnc

cropped1 = scaledpos(1:yregion, 1:xregion);
cropped2 = scaledneg(1:yregion, 1:xregion);
%figure('name','Pos Diffraction Pattern Log')
%imagesc(log10(max(0,cropped1))), axis image xy, colormap jet
%figure('name','Neg Diffraction Pattern Log')
%imagesc(log10(max(0,cropped2))), axis image xy, colormap jet

avg1 = mean(cropped1,'all');
avg2 = mean(cropped2,'all');
%display([avg1, avg2]);
n = avg2/avg1;
%n = 1.15;
display(n);

pos_n = n*scaledpos;
neg_n = scaledneg;

hologram_n = pos_n-neg_n;
hologram_c_n = pos_n+neg_n;

image_pos_n = pos_n;
image_pos_n(normpx+dx/2-2:normpx+dx/2+2,normpy-dy/2:normpy+dy/2) = max(pos_n(:));
image_pos_n(normpx-dx/2-2:normpx-dx/2+2,normpy-dy/2:normpy+dy/2) = max(pos_n(:));
image_pos_n(normpx-dx/2:normpx+dx/2,normpy-dy/2-2:normpy-dy/2+2) = max(pos_n(:));
image_pos_n(normpx-dx/2:normpx+dx/2,normpy+dy/2-2:normpy+dy/2+2) = max(pos_n(:));
clear pos_n neg_n
ROI = image_pos_n(normpx-dx:normpx+dx,normpy-dy:normpy+dy);
clear image_pos_n
figure ('Name','Normalization')
imagesc(ROI); axis image xy

figure ('Name', 'Normalized Difference')
imagesc(hologram_n); axis image xy, colormap jet

figure ('Name', 'Log Normalized Difference')
imagesc(log10(abs(hologram_n))); axis image xy, colormap jet

%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%  Smooth Beamstop Application  %%%%%%%%%%%%%%%%%%%%%%%

R0_X = 25; R0_Y = 40; K = 10; % rayon BS
%R0_X = 0; R0_Y = 0;K = 0;
S = 8;
F = zeros(K,K);

py = 1022; px = 1023;  %centre du BS


SizeX = size(hologram_n,1);
SizeY = size(hologram_n,2);

A = zeros(SizeX,SizeY);

for X = -SizeY/2:SizeY/2-1
    for VCslice = -SizeX/2:SizeX/2-1
    
        if (VCslice^2/R0_Y^2 + X^2/R0_X^2) < 1
            A(VCslice+px,X+1+py) = 1;
        end
    end
end

for Y = -K/2:K/2
    for X = -K/2:K/2
    
           F(Y+K/2+1,X+1+K/2) = exp(-(Y^2+X^2)/(2*(S^2)));

    end
end

A = filter2(F,A, 'same');
A = A/max(max(A));

A = ones(size(A))-A;
hologram_s = hologram_n.*abs(A); clear hologram_n
hologram_c_n = hologram_c_n.*abs(A);
hologram_c = hologram_c.*abs(A);
clear A


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%  Crosshair for Defining Center of Hologram  %%%%%%%%%%%%%%%%

L = 110;  
% FF(px-L:px-2,py-1:py+1) = max(hologram_n(:)/9);
% FF(px+2:px+L,py-1:py+1) = max(hologram_n(:)/9);
% FF(px-1:px+1,py-L:py-2) = max(hologram_n(:)/9);
% FF(px-1:px+1,py+2:py+L) = max(hologram_n(:)/9);
ROI = hologram_s(px-150:px+150,py-150:py+150);


figure('Name','Crosshair and Beamstop Applied')
imagesc(log10(abs(ROI))); axis equal; xlabel('x'); ylabel('y')
axis image xy, colormap jet

%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%  Filter Application  %%%%%%%%%%%%%%%%%%%%%%%%%%%

% changing fy and fx allows altering of contrast of the final image
% this is a crucial step to ensure the exact centre of the hologramn is put
% in

phi = 90.8583;
%phi = 0.57;% Rotation of Filter
fy = 1022; fx = 1023;    % fy is x, fx is y

[nx,ny] = size(hologram_s);
[x,y] = ndgrid(1:nx,1:ny);

hm = 1i.*(-(x-fx).*cosd(phi)+(y-fy).*sind(phi)); %gradient (filtre linaire)
HR = hologram_s.*hm;
HR_c_n = hologram_c_n.*hm; % charge = somme de desux polarisations, normalis
HR_c = hologram_c.*hm; % mme chose, sans normalisation

figure('Name','Filter to Apply');
imagesc(log10(abs(hm)))
colormap jet, axis image xy

figure('Name','Differential Filter Applied');
imagesc(log10(abs(HR)))
colormap jet, axis image xy

%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  FFT  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = fftshift(fft2(HR));
r_c = fftshift(fft2(HR_c_n));
PHI = exp(2i*pi*(x.*fx/nx+y.*fy/ny));
r1 = PHI.*r;
r1_c = PHI.*r_c;

save r1 r1
                                                                                                                                             
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%  Real & Imaginary Charge  %%%%%%%%%%%%%%%%%%%%%%%%%

figure('Name', 'Charge')

% imagesc(real(r1_c))
subplot(2,1,1), imagesc(real(r1_c(100:2000,100:2000)))  % 92.5 degrees
set(gca,'DataAspectRatio',[1 sqrt(2) 1])
title([(num2str(file1)),'-',num2str(file2),' Real Charge, ', 'Delay=',num2str(delay)]); %,'Sample Angle=',num2str(ang),'deg, ','RF Width=',num2str(RF_width),'ns, ','Delay=',num2str(delay),'ns'])

caxis ([-1e4 1e4]), axis image xy, colormap gray

% imagesc(imag(r1_c))
subplot(2,1,2), imagesc(real(r1_c(100:2000,100:2000)))  % 92.5 degrees
set(gca,'DataAspectRatio',[1 sqrt(2) 1])
title([(num2str(file1)),'-',num2str(file2),' Imaginary Charge, ', 'Delay=',num2str(delay)]); %,'Sample Angle=',num2str(ang),'deg, ','RF Width=',num2str(RF_width),'ns, ','Delay=',num2str(delay),'ns'])

caxis ([-1e4 1e4]), axis image xy, colormap gray

%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%  Real & Imaginary Magnetism  %%%%%%%%%%%%%%%%%%%%%%%

figure('Name', 'Magnetism')
% imagesc(real(r1))
% 
subplot(2,1,1), imagesc(real(r1(500:1500,500:1500)))   % 43 degrees
set(gca,'DataAspectRatio',[1 sqrt(2) 1])
title([num2str(file1),'-',num2str(file2),' Real Magnetism, ', 'Delay=',num2str(delay)])
% title([(num2str(file1)),'-',num2str(file2),' Real Magnetism, ','Sample Angle=',num2str(ang),'deg, ','RF Width=',num2str(RF_width),'ns, ','Delay=',num2str(delay),'ns'])
caxis ([-1e3 1e3]), axis image xy, colormap gray

% imagesc(imag(r1))
subplot(2,1,2), imagesc(imag(r1(500:1500,500:1500)))   % 43 degrees
set(gca,'DataAspectRatio',[1 sqrt(2) 1])
title([num2str(file1),'-',num2str(file2),' Imag Magnetism, ', 'Delay=',num2str(delay)])
% title([(num2str(file1)),'-',num2str(file2),' Imaginary Magnetism, ','Sample Angle=',num2str(ang),'deg, ','RF Width=',num2str(RF_width),'ns, ','Delay=',num2str(delay),'ns'])
caxis ([-1e3 1e3]), axis image xy, colormap gray

avgImage = (real(r1) + imag(r1))/2;
figure('Name','Average of real and imaginary parts');
imagesc(avgImage(500:1500,500:1500))
caxis ([-1e3 1e3]), axis image xy, colormap gray

figure('Name','Real Magnetism');
imagesc(imag(r1(500:1500,500:1500)))
caxis ([-1e3 1e3]), axis image xy, colormap gray

% 
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%  All 4 Squares Real Magnetic  %%%%%%%%%%%%%%%%%%%%%%%

figure('Name','All 4 Squares')
subplot(2,2,1), imagesc(avgImage(1200:1450,675:925)), title('TL'), colormap gray, axis xy, caxis([-1000 1000])
subplot(2,2,2), imagesc(avgImage(1200:1450,1075:1325)), title('TR'), colormap gray, axis xy, caxis([-1000 1000])
subplot(2,2,3), imagesc(avgImage(580:830,715:965)), title('BL'), colormap gray, axis xy, caxis([-1000 1000])
subplot(2,2,4), imagesc(avgImage(580:830,1125:1375)), title('BR'), colormap gray, axis xy, caxis([-1000 1000])

%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%  Apply Gaussian Smoothing Filter  %%%%%%%%%%%%%%%%%%%%

hsize = [1 1];
sigma = 1;

h = fspecial('gaussian', hsize, sigma);

figure()
subplot(2,1,1),imagesc(imfilter(real(r1(500:1500,500:1500)), h))
title([(num2str(file1)),'-',num2str(file2),' Real Magnetism, ', 'Delay=',num2str(delay)]); %,'Sample Angle=',num2str(ang),'deg, ','RF Width=',num2str(RF_width),'ns, ','Delay=',num2str(delay),'ns'])
caxis([-1000 1000]),axis image xy,colormap gray
set(gca,'DataAspectRatio',[1 sqrt(2) 1])
subplot(2,1,2),imagesc(imfilter(imag(r1(500:1500,500:1500)), h))
title([(num2str(file1)),'-',num2str(file2),' Imag Magnetism, ', 'Delay=',num2str(delay)]); %,'Sample Angle=',num2str(ang),'deg, ','RF Width=',num2str(RF_width),'ns, ','Delay=',num2str(delay),'ns'])
caxis([-1000 1000]),axis image xy,colormap gray
set(gca,'DataAspectRatio',[1 sqrt(2) 1])


%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%  Choose Coordinates for Region of Interest (ROI)  %%%%%%%%%%%%

roiy_tl = 500:1500;
roix_tl = 500:1500;

roiy_tl_slit = 500:1500;
roix_tl_slit = 500:1500;

%350:750,350:800
%1040:1200,200:400
%1000:1200,400:600

%roix_tr = 215:545;
%roiy_tr = 1033:1293;
%roix_br = 1455:1785;
%roiy_br = 1160:1420;
%roix_bl = 1455:1785;
%roiy_bl = 895:1155;

%% 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%  Phase Optimization  %%%%%%%%%%%%%%%%%%%%%%%%%%%

ROI1 = r1(roiy_tl,roix_tl); % magnetic
ROI_slit = r1(roiy_tl_slit,roix_tl_slit); % magnetic
% ROI1_c = r1_c(roiy_tl,roix_tl); % charge


froi1 = figure('Name','ROI1');
subplot(2,2,1), imagesc(abs(ROI1)),   set(gca,'DataAspectRatio',[1 sqrt(2) 1]), axis image xy,caxis ([-2e3 2e3]), colormap gray;
subplot(2,2,2), imagesc(angle(ROI1)), set(gca,'DataAspectRatio',[1 sqrt(2) 1]), axis image xy,caxis ([-4 4]), colormap gray;
subplot(2,2,3), imagesc(real(ROI1)),  set(gca,'DataAspectRatio',[1 sqrt(2) 1]), axis image xy,caxis ([-1e3 1e3]), colormap gray;
subplot(2,2,4), imagesc(imag(ROI1)),  set(gca,'DataAspectRatio',[1 sqrt(2) 1]), axis image xy,caxis ([-1e3 1e3]), colormap gray;

%%
close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%  Phase Rotation to find Optimal Angle  %%%%%%%%%%%%%%%%%%

% ROI1 = r1(roiy_tl,roix_tl);
figk = figure('Name','Phase Rotation');

for k = 1:15:360
    
    M1 = ROI1.*exp(-2i*pi/360*k);
    M1_slit = ROI_slit.*exp(-2i*pi/360*k);
    % C1 = ROI1_c.*exp(-2i*pi/360*k);
    MR(k) = mean(abs(real(M1(:))));
    MI(k) = mean(abs(imag(M1(:))));
%     CR(k) = mean(abs(real(C1(:))));
%     CI(k) = mean(abs(imag(C1(:))));
    SR(k) = std(real(M1(:)));
    SI(k) = std(imag(M1(:)));

    figure(figk)
    imagesc(imfilter(real(M1_slit),h)), set(gca,'DataAspectRatio',[1 sqrt(2) 1])
    title(num2str(k)), axis xy, caxis([-1000 1000])
    colormap gray
    %subplot(2,1,2), imagesc(imag(ROI_slit.*exp(-2i*pi/360*k))), set(gca,'DataAspectRatio',[1 sqrt(2) 1])
    %subplot(2,1,2), imagesc(imfilter(imag(ROI_slit.*exp(-2i*pi/360*k)),h)), set(gca,'DataAspectRatio',[1 sqrt(2) 1])
    %title(num2str(k)), axis xy, caxis([-1000 1000])
    %colormap gray
    drawnow
    pause(1.5)
    
    %The trial function to do this with the real/imaginary average
    %avgImage = (real(M1) + imag(M1))/2;
    %imagesc(imfilter(avgImage, h))
    %title(num2str(k)), axis xy, caxis([-1000 1000])
    %colormap gray
    %drawnow
    %pause(1.5)
    
end

%%
k = input('Integer phase angle from 0 to 359 degrees: ') % Choose the angle that gives the best contrast
%k=0
M1 = ROI1.*exp(-2i*pi/360*k);
M1_slit = ROI_slit.*exp(-2i*pi/360*k);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%  Corrected Magnetism Image  %%%%%%%%%%%%%%%%%%%%%%%%
dimension = size(M1_slit)
profile_vertical = M1_slit(:,500);
profile_horizontal = M1_slit(500,:);
%dim_profile = size(profile)
pixels_vertical = 1:dimension(1);
pixels_horizontal = 1:dimension(2);
%size_pixel = size(pixels)

%close all

figure('Name', 'Magnetism')
% subplot(2,1,1), imagesc(real(M1))
%subplot(3,1,1),
imagesc(imfilter(real(M1_slit), h))
% title([(num2str(file1)),'-',num2str(file2),' Real Magnetism, ','Sample Angle=',num2str(ang),'deg, ','RF Width=',num2str(RF_width),'ns, ','Delay=',num2str(delay),'ns'])
title([num2str(file1),'-',num2str(file2),' Real Magnetism, ','k=', num2str(k)]);
caxis ([-1e3 1e3]), axis image xy, colormap gray
%set(gca,'DataAspectRatio',[1 sqrt(2) 1])

%avgImage = im2gray((real(M1) + imag(M1))/2);
%figure('Name','Average of real and imaginary parts');
%imagesc(imfilter(avgImage, h))
%title([num2str(file1),'-',num2str(file2),'Avg Magnetism, ','k=', num2str(k)]);
%caxis ([-1e3 1e3]), axis image xy, colormap gray
%filename = fullfile('Analysis\ProcessedFiles\',[(num2str(file1)),'-',num2str(file2),'_AvgMagnetism.tif']);
%textfile = fullfile('Analysis\ProcessedFiles\',[(num2str(file1)),'-',num2str(file2),'_AvgMagnetism.txt']);
%imwrite(avgImage, filename)
%print(filename, '-dtiff');


%subplot(3,1,2)
%plot(pixels_vertical,profile_vertical)

%subplot(3,1,3)
%plot(pixels_horizontal,profile_horizontal)


save M1 M1
%save avgImage avgImage

%dlmwrite(['Analysis\ProcessedFiles\SI\',(num2str(file1)),'-',num2str(file2),' Real Magnetism.txt'],imfilter(real(M1_slit), h),'delimiter','\t');
%dlmwrite(['Analysis\ProcessedFiles\SI\',(num2str(file1)),'-',num2str(file2),' Imag Magnetism.txt'],imfilter(imag(M1_slit), h),'delimiter','\t');
%dlmwrite(['Analysis\ProcessedFiles\SI\',(num2str(file1)),'-',num2str(file2),' Amp Magnetism.txt'],imfilter(abs(M1_slit), h),'delimiter','\t');
%dlmwrite(['Analysis\ProcessedFiles\SI\',(num2str(file1)),'-',num2str(file2),' Phase Magnetism.txt'],imfilter(angle(M1_slit), h),'delimiter','\t');

dlmwrite(['Analysis\ProcessedFiles\',(num2str(file1)),'-',num2str(file2),' Real Magnetism.txt'],imfilter(real(M1_slit), h),'delimiter','\t');
%textfile = fullfile('Analysis\ProcessedFiles\',[(num2str(file1)),'-',num2str(file2),' Real Magnetism .png']);
%writematrix(avgImage, textfile)

%%
