function [fooof_results] = plot_SEM_4Magill(PSD1,mPSD1,colorw)
m1_upp = mPSD1 + std(PSD1,0,1)/sqrt(size(PSD1,1));
m1_down = mPSD1 - std(PSD1,0,1)/sqrt(size(PSD1,1));
x_line = 1:size(PSD1,2);
shadedplot(x_line,m1_upp,m1_down,colorw); alpha(.2); grid off;

% fooof settings
f_range = [30 100];
return_model=1;
settings = struct();
settings.peak_threshold=2;
settings.aperiodic_mode='fixed';
settings.peak_width_limits=[2,12];
fooof_results = fooof(x_line', mPSD1, f_range, settings,return_model);
loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'k--');

disp(['exp = ' num2str(fooof_results.aperiodic_params(1,2))]);
end

