function [ON_meds] = Med_ONs(cm)

freq1=cm.freq1;
freq2=cm.freq2;

dir = 'D:\eLife_Data_Code\Data\Human\Meds\ON\';
fileNames = GetFileNames(dir, '.mat');
channel=[9,10,10,11,9,11,1,1,30,30,14,14,18,18,15,15,23,23,25,27,24,26,8,16,19,8,14,14,20,18];
time=[1,61;1,61;70,130;1460,1520;1,61;1,61;1,61;1,61;277,337;1,61;1,61;230,290;1,61;1,61;1,59;1,61;1,61;1,61;1,61;1,61;200,260;200,260;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61];

%fooof settings
return_model=1;
settings = struct();
settings.peak_threshold=2;
settings.aperiodic_mode='fixed';
settings.peak_width_limits=[2,12];

% vars
exponents = NaN(1,length(fileNames));
Rs = NaN(1,length(fileNames));
spectra = NaN(length(fileNames),freq2);

datON.alpha = NaN(1,length(fileNames));
datON.beta_whole = NaN(1,length(fileNames));
datON.low_beta = NaN(1,length(fileNames));
datON.high_beta = NaN(1,length(fileNames));
datON.gamma_whole = NaN(1,length(fileNames));
datON.low_gamma = NaN(1,length(fileNames));
datON.high_gamma = NaN(1,length(fileNames));
datON.beta_per = NaN(1,length(fileNames));

it=1; figure(1);
for sub =1:length(fileNames)  %[1:6,9:28]
    
    % Load data
    load(fileNames{sub});
    disp(fileNames{sub});
    
    % Get lfp traces
    SelData = SmrData.WvData(channel(sub),:);
    SelData = detrend(SelData);
    fs=SmrData.Fs;
    
    % signal
    signal=SelData(time(sub,1)*fs:time(sub,2)*fs);
    
    % wavelet
    nData=size(signal,2);
    stfr=1;   enfr=freq2;  dfr=1.0;
    froi=stfr:dfr:enfr;
    tmoi=(1:nData)*(1/fs);
    cfg.width=50;
    cfg.gwidth=3;
    cfg.pad = ceil(nData/fs);
    cfg.Method='Wavlet';
    [cmmatall,f,~] = ft_specest_wavelet(signal,tmoi,'freqoi',froi,'width', cfg.width,'gwidth',cfg.gwidth, 'pad', cfg.pad, 'verbose', 0);
    cmmatall=squeeze(cmmatall);
    temppower=abs(cmmatall).^2;
    spec = nanmean(temppower,2);
    
    %remove mains noise
    spec(47:54)=NaN;
    spec = fillmissing(spec,'linear');
    
    %normalise
    spec = spec./mean(spec);
    
    % 1/F remove
    f_range = [1, 90];
    fooof_results = fooof(f, spec, f_range, settings,return_model);
    
    %figure; loglog(f,spec); hold on; loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'r');
    rel_spec = spec(1:90)';
    f_rem_spec = rel_spec - 10.^(fooof_results.ap_fit);
    %figure; plot(f_rem_spec);
    
    
    figure(1); subplot(5,6,it);
    loglog(spec); hold on; title(['Hem: ' num2str(it)]);
    % other frequencies
    settings.aperiodic_mode='knee';
    [datON] = more_frequencies(f_rem_spec,f,settings,return_model,sub,datON,spec);
    

    
    % get aperiodic component
    settings.aperiodic_mode='fixed';
    f_range = [freq1, freq2];
    fooof_results = fooof(f, spec, f_range, settings,return_model);
    loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'r');
    %fooof_plot_inv(fooof_results); grid off; legend off; 
     text(1,3,['beta ON: ' num2str(datON.beta_per(it))],'Color','r');
     if ~isnan(datON.beta_freq(it))
         loglog(datON.beta_freq(it),spec(floor(datON.beta_freq(it))),'r*');
     end

    if contains(settings.aperiodic_mode,'fixed')
        exponents(it) = fooof_results.aperiodic_params(1,2);
    else
        exponents(it) = fooof_results.aperiodic_params(1,3);
    end
    spectra(it,:) = spec;
    Rs(it) = fooof_results.r_squared;
    it=it+1;
end
sgtitle('blue = OFF; yellow = ON meds');
% store
ON_meds.exponents = exponents;
ON_meds.datON = datON;
ON_meds.spectra = spectra;
ON_meds.R = Rs;
end



