function [OFF_meds] = Med_OFFs(cm)

freq1=cm.freq1;
freq2=cm.freq2;

dir = 'D:\eLife_Data_Code\Data\Human\Meds\OFF\';
fileNames = GetFileNames(dir, '.mat');
channel=[9,11,10,11,9,11,1,1,1,1,7,10,9,7,7,10,6,7,20,22,24,26,3,16,19,12,7,9,9,8];
time=[760,820;2360,2420;1,61;1550,1610;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;1,61;200,260;200,260;1,61;1,61;1,61;1,61;70,130;70,130;1,61;1,61];

%fooof settings
return_model=1;
settings = struct();
settings.peak_threshold=2;
settings.aperiodic_mode='fixed';
settings.peak_width_limits=[2,12];

% vars
beta_per = NaN(1,length(fileNames));
beta_whole = NaN(1,length(fileNames));
exponents = NaN(1,length(fileNames));
Rs = NaN(1,length(fileNames));
gamma = NaN(1,length(fileNames));
low_beta = NaN(1,length(fileNames));
high_beta = NaN(1,length(fileNames));
spectra = NaN(length(fileNames),freq2);

datOFF.alpha = NaN(1,length(fileNames));
datOFF.beta_whole = NaN(1,length(fileNames));
datOFF.low_beta = NaN(1,length(fileNames));
datOFF.high_beta = NaN(1,length(fileNames));
datOFF.gamma_whole = NaN(1,length(fileNames));
datOFF.low_gamma = NaN(1,length(fileNames));
datOFF.high_gamma = NaN(1,length(fileNames));
datOFF.beta_per = NaN(1,length(fileNames));

it=1; figure;
for sub =1:length(fileNames)  %[1:6,9:28]
    
    % Load data
    load(fileNames{sub});
    disp(fileNames{sub});
    
    % Get lfp traces
    SelData = SmrData.WvData(channel(sub),:);
    SelData = detrend(SelData);
    fs=SmrData.Fs;
    
    % signal
    signal=SelData(time(sub,1)*fs:time(sub,2)*fs);
    
    % wavelet
    nData=size(signal,2);
    stfr=1;   enfr=freq2;  dfr=1.0;
    froi=stfr:dfr:enfr;
    tmoi=(1:nData)*(1/fs);
    cfg.width=50;
    cfg.gwidth=3;
    cfg.pad = ceil(nData/fs);
    cfg.Method='Wavlet';
    [cmmatall,f,~] = ft_specest_wavelet(signal,tmoi,'freqoi',froi,'width', cfg.width,'gwidth',cfg.gwidth, 'pad', cfg.pad, 'verbose', 0);
    cmmatall=squeeze(cmmatall);
    temppower=abs(cmmatall).^2;
    spec = nanmean(temppower,2);
    
    %remove mains noise
    spec(47:54)=NaN;
    spec = fillmissing(spec,'linear');
    
    %normalise
    spec = spec./mean(spec);
    
    % 1/F remove
    f_range = [1, 90];
    fooof_results = fooof(f, spec, f_range, settings,return_model);
    
    %figure; loglog(f,spec); hold on; loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'r');
    rel_spec = spec(1:90)';
    f_rem_spec = rel_spec - 10.^(fooof_results.ap_fit);
    %figure; plot(f_rem_spec);
    
    subplot(5,6,it);
    loglog(spec); hold on; title(['Hem: ' num2str(it)]);
    % other frequencies
    settings.aperiodic_mode='knee';
    [datOFF] = more_frequencies(f_rem_spec,f,settings,return_model,sub,datOFF,spec);
    
    
    % get periodic beta
%     f_range = [5, 90];
%     fooof_results = fooof(f, spec, f_range, settings,return_model);
%     
%     low_cut=find(fooof_results.peak_params(:,1) > 12);
%     up_cut=find(fooof_results.peak_params(:,1) < 35);
%     val=intersect(low_cut,up_cut);
%     
%     if ~isempty(val)
%         if numel(val) > 1
%             [~,max_beta]=max(fooof_results.peak_params(val,2));
%             beta_per(it) = fooof_results.peak_params(val(max_beta),2);
%         else
%             beta_per(it) = fooof_results.peak_params(val,2);
%         end
%     else
%         beta_per(it) = NaN;
%     end
    
    
    % get aperiodic component
    settings.aperiodic_mode='fixed';
    f_range = [freq1, freq2];
    fooof_results = fooof(f, spec, f_range, settings,return_model);
    loglog(fooof_results.freqs, 10.^(fooof_results.ap_fit), 'k');
    %fooof_plot_inv(fooof_results); grid off; legend off;  
    text(1,1,['beta OFF: ' num2str(datOFF.beta_per(it))],'Color','b');
    loglog(datOFF.beta_freq(it),spec(floor(datOFF.beta_freq(it))),'b*');

    if contains(settings.aperiodic_mode,'fixed')
        exponents(it) = fooof_results.aperiodic_params(1,2);
    else
        exponents(it) = fooof_results.aperiodic_params(1,3);
    end
    spectra(it,:) = spec;
    Rs(it) = fooof_results.r_squared;
    it=it+1;
end
sgtitle('OFF meds');
% store
OFF_meds.exponents = exponents;
OFF_meds.datOFF = datOFF;
OFF_meds.beta_per = beta_per;
OFF_meds.spectra = spectra;
OFF_meds.R = Rs;
end



