% This file is to check whether the spectrometer specification is sufficient to retrieve the phase modulation.
% (Update 23 April 2015: deprecated, can be replaced using get_sssi_pattern.m function)
% Author: M. F. Kasim (University of Oxford)
% Date: 16 February 2015

% experimental parameters for:
% * TA2 experiment:
%   * alpha = 7.69e25;
%   * tau0 = 1e-12;
%   * tau = .5e-3/c;
%   * n = 3e18*1e6;
%   * 
%   * lmbdaRange = 160e-9;
%   * lmbdaCentre = 800e-9;
%   * lmbdaRes = 0.1e-9;
%   * 
% * AWAKE experiment:
%   * alpha = 4.8077e23;
%   * tau0 = 160e-12;
%   * tau = .5e-3/c;
%   * n = 7e14*1e6;
%   * 
%   * lmbdaRange = 160e-9;
%   * lmbdaCentre = 800e-9;
%   * lmbdaRes = 0.1e-9;
%   * 

addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\experiments');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% fundamental variables
c = 3e8;
e = 1.6e-19;
m = 9.1e-31;
e0 = 8.85e-12;

% experimental variables
TA2 = 0;
AWAKE = 1;
import_parameters;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the x-axes
lmbda = [lmbdaCentre-lmbdaRange/2:lmbdaRes:lmbdaCentre+lmbdaRange/2];
w = 2*pi*c./lmbda;
t = linspace(-1, 1, length(lmbda)) * lmbdaCentre^2/c/lmbdaRes / 2;

% computed parameters
w0 = 2*pi*c/lmbdaCentre;
wp = (n*e*e/m/e0)^.5;
tp = 2*pi/wp;
y = [-Ny*dyRes/2:dyRes:Ny*dyRes/2];

% define the blank image
IwImage  = zeros(length(y), length(lmbda));
Iw0Image = zeros(length(y), length(lmbda));

for (yIdx = [1:Ny])
    % constructing the phase spectrum of the signal
    Erw = exp(-(y(yIdx))^2/2/r0^2) * tau0/(1+1i*alpha*tau0^2).^5 .* exp(-(w-w0).^2*tau0^2/2/(1+1i*alpha*tau0^2));
    dphiw = exp(-(y(yIdx))^2/2/r^2) * phi0 * sin((w-w0)/alpha * wp); % phase modulation

    % modulus of the phase spectrum of the signal
    Iw = 2*abs(Erw).^2 .* (1 + cos(dphiw + w*tau));
    Iw0 = 2*abs(Erw).^2 .* (1 + cos(w*tau));

    % camera bits resolution
    % maxCamValue = (2^cameraBits - 1);
    % normalisedValue = 1 / max([Iw Iw0]) * maxCamValue;
    % Iw  = (Iw  * normalisedValue);
    % Iw0 = (Iw0 * normalisedValue);
    % Iw  = Iw  .* (Iw  <= maxCamValue) + maxCamValue * (Iw  > maxCamValue);
    % Iw0 = Iw0 .* (Iw0 <= maxCamValue) + maxCamValue * (Iw0 > maxCamValue);
    % Iw  = int64(Iw );
    % Iw0 = int64(Iw0);

    % processing in the computer in double precision
    Iw  = double(Iw );
    Iw0 = double(Iw0);
    
    IwImage(yIdx,:)  = Iw ;
    Iw0Image(yIdx,:) = Iw0;
end

toDraw = IwImage;
imagesc(lmbda*1e9, y*1e3, max(max(toDraw)) - toDraw);
colormap gray;
xlabel('Wavelength (nm)');
ylabel('Vertical position (mm)');
title('Expected pattern on the spectrometer (approximately)');
