% This file is to read the measurement from 3D oblique-angle project and valid only for proof-of-concept (POC) part.
% The script reads the final intensity and frequency maps for an x2-sliced E-data and compare it to its initial value.
% The obtained dw/w0 frequency maps are then applied to inverse modified abel transform to get the derivative of wakefield profile.
% There are 4 modes in this file:
%   * 'wigner': to see the wigner transform of the middle axis electric field and to see the initial values.
%   * 'intensity_freq': to see the intensity and frequency change maps for the electric field at the x2=yFrac plane.
%   * 'density': to see the density profile distribution according to the measurement at the x2=yFrac plane.
%   * 'movie': to create a movie of wakefield density changes based on the measurement.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% START OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
refreshFilter = 0;
sampFac = 1;
Nfilter = 10000; % x1-spacing 65/13000
Nperiod = 1.2551e+03;
% Nfilter = 7500; % x1-spacing 65/9750
% Nperiod = 940.4478;
% Nfilter = 5000; % obtained by running wigner mode (x1-spacing 65/6500)
% Nperiod = 625.0872; % period of a linear plasma wave (in downsampled wave). should be the Nperiod value after the first run
if (~exist('df','var') || isempty(df) || refreshFilter)
    % double integrator filter
    nfir = 8000*Nfilter/5000;
    f = linspace(0, 1, Nfilter);
    f0 = 1./Nperiod * 2;
    fbound = f0 * 3/4;
    a = (f > fbound) .* (f0*f0./f./f) + (f <= fbound) .* (f0*f0/fbound/fbound);
    a(1) = f0*f0/fbound/fbound;
    % a = fbound^2 ./ (fbound^2 + f.^2) * f0^2;
    d = fdesign.arbmag('N,F,A', nfir, f, a);
    hd1 = design(d, 'equiripple');
    dly1 = mean(grpdelay(hd1));
    
    % differentiator filter
    df = fdesign.differentiator('N,Fp,Fst', nfir, 6*f0, 6.5*f0);
    hdf = design(df, 'equiripple');
    dlyf = mean(grpdelay(hdf));
    dphi = 2*pi / Nperiod;
    disp('Filter created');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% BEGINNING OF THE PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

w0wps = [20]; %9.8436826981031498;
thetads = [20];
projectNames = ['51-taking-data-freq-020'];


for (jj = [1:length(w0wps)])
w0wp = w0wps(jj);
thetad = thetads(jj);
projectName = projectNames(jj,:);

% ifiles = [1:1];
ifiles = [1:5];
if      (thetad == 25) filesNums = [12, 13, 15, 16, 17]; % angle 025
elseif  (thetad == 20) filesNums = [13, 14, 16, 18, 19]; % angle 020
elseif  (thetad == 15) filesNums = [15, 18, 20, 22, 24]; % angle 015
elseif  (thetad == 10) filesNums = [21, 24, 27, 30, 33]; % angle 010
elseif  (thetad ==  5) filesNums = [32, 38, 44, 50, 55]; % angle 005
end
% filesNums2 = filesNums + 4;
filesNums2 = -1;

for (ifile = ifiles)

% File information for electric field and electron density distribution
fdir = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/h5-e3-slice-%02d/', projectName, ifile);
fformat = strcat(sprintf('e3-slice-x2-%02d-', ifile), '%06d.h5');
datasetname = '/e3 x2 slice';
dirOut = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/freq-slice-%02d/', projectName, ifile);
initEFile = 0;
finalEFile = filesNums(ifile); %13;
wlimit = 0.01;

information = 'density';

theta = thetad*pi/180;
xROI = [0 50];
if      (w0wp <= 5 ) kROI = [1.1 3.5]; % freq 5
elseif  (w0wp <= 10) kROI = [2.4 3.8]; % freq 10
elseif  (w0wp <= 15) kROI = [3.5 6.0]; % freq 15
elseif  (w0wp <= 20) kROI = [5.0 7.5]; % freq 20
elseif  (w0wp <= 25) kROI = [6.5 9.5]; % freq 25
elseif  (w0wp <= 30) kROI = [8.0 11.0]; % freq 30
end
% xROI = [-999999999999999 999999999999999];
% kROI = [-999999999999999 999999999999999];

yFrac = 0.5;
zFrac = 0.5;
% densLimit = -9999; %[-.25 .2];
% dww0Limit = -9999;
densLimit = [-.5 .5];
dww0Limit = [-5 5]*1e-3;

vp = 44000/(1+44000^2)^.5;
vg = w0wp/(1+w0wp^2)^.5;
a = abs((cos(theta) - vp/vg)/sin(theta));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF THE PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\oblique-angle\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\abel_transform\');

if ((length(filesNums2) <= 1) | (filesNums2 == filesNums)) filesToBeExtracted = [initEFile finalEFile];
else filesToBeExtracted = [initEFile filesNums(ifile):filesNums2(ifile)]; end;

for (i = filesToBeExtracted)
    % construct the full address of the file
    fname = sprintf(fformat, i);
    filename = strcat(fdir, fname);
    
    % read the attributes
    time = h5readatt(filename, '/', 'TIME');
    posMin = h5readatt(filename, '/', 'XMIN');
    posMax = h5readatt(filename, '/', 'XMAX');
    
    % get the E data
    data = h5read(filename, datasetname);
    [N1 N3] = size(data);
    
    % set the x, y, z axis
    x = linspace(posMin(1), posMax(1), N1);
    z = linspace(posMin(3), posMax(3), N3);
    % kx = [0:N1-1]/N1/(x(2)-x(1));
    
    % resample the array and matrix
    rdata = data(1:sampFac:end, 1:sampFac:end);
    rx = x(1:sampFac:end);
    rz = z(1:sampFac:end);
    N1 = length(rx);
    N3 = length(rz);
    
    % crop the x axis
    xMinIdx = find(rx - rx(1) >= xROI(1)); xMinIdx = xMinIdx(1);
    xMaxIdx = find(rx - rx(1) <= xROI(2)); xMaxIdx = xMaxIdx(end);
    ex = rx(xMinIdx:xMaxIdx);
    
    % set the k axis
    k = [0:length(ex)-1] / length(ex) / (ex(2) - ex(1));
    kMinIdx = find(k >= kROI(1)); kMinIdx = kMinIdx(1);
    kMaxIdx = find(k <= kROI(2)); kMaxIdx = kMaxIdx(end);
    ek = k(kMinIdx:kMaxIdx);
    
    if (strcmp(information, 'wigner'))
        data1D = rdata(xMinIdx:xMaxIdx,round(N3*zFrac));
        wigner = tfrwv(data1D);
        wigner = wigner(end:-1:1,:);
        wigner = wigner(kMinIdx:kMaxIdx,:);
        imagesc(ex, ek, wigner);
        Nfilter = length(ex)
        Nperiod = 2*pi/(posMax(1) - posMin(1)) * length(rx) * posMin(1) / time
        break;
        
    else
        if (i == initEFile)
            % read the initial file just to get the initial frequency
            data1D = data(:,[round(N3*zFrac):round(N3*zFrac)+1]);
            % data1D = permute(data1D, [1,3,2]);
            [ex, ez, wMap, s2Map] = getWS2Map(rx, [rz(1) rz(2)], data1D', wlimit, xROI, kROI);
            w0 = wMap(1,round(size(wMap,2)/2));
            
        else
            if (strcmp(information, 'intensity_freq'))
                % read the intensity and frequency change map on the x2 plane
                display = 1;
                data2D = double(rdata);
                % data2D = permute(data2D, [1,3,2]);
                [ex, ez, wMap, s2Map] = getWS2Map(rx, rz, data2D', wlimit, xROI, kROI, display);
                dww0Map = (wMap - w0) / w0 .* (wMap ~= 0);
                
                h = figure;
                if (length(dww0Limit) == 2)
                    imagesc(ex, ez, dww0Map, dww0Limit);
                else
                    imagesc(ex, ez, dww0Map);
                end
                colorbar;
                saveas(h, strcat(dirOut, sprintf('freq-%06d.png', i)), 'png');
                close(h);
                
                h = figure;
                imagesc(ex, ez, s2Map);
                colorbar;
                saveas(h, strcat(dirOut, sprintf('intensity-%06d.png', i)), 'png');
                close(h);
                
            elseif (strcmp(information, 'density'))
                % read the intensity and frequency change map on the x2 plane
                display = 1;
                data2D = double(data);
                % data2D = permute(data2D, [1,3,2]);
                [ex, ez, wMap, s2Map] = getWS2Map(rx, rz, data2D', wlimit, xROI, kROI, display);
                
                % get the half of dww0Map
                dww0Map = (wMap - w0) / w0 .* (wMap ~= 0);
                dww0MapSymm = (dww0Map + dww0Map(end:-1:1,:)) / 2;
                % dww0MapHalf = dww0MapSymm(round(0.5*size(dww0Map,1)):end,:);
                dww0MapHalf = dww0Map(floor(0.5*size(dww0Map,1))+1:end,:);
                
                % obtain the dnn0/dz map from the inverse abel transform
                % [x2, z2, dnn0dzMap] = mod_abel_transform2(ex, ez(round(0.5*size(dww0Map,1)):end), dww0MapHalf * (-2) * w0wp^2*abs(sin(theta)), a, 1);
                [x2, z2, dnn0dzMap] = mod_abel_inversion_3_pts(ex, ez(round(0.5*size(dww0Map,1)):end), dww0MapHalf * (-2) * w0wp^2*abs(sin(theta)), a);
                
                % integrate horizontally dnn0/dz map to get dnn0 profile
                dnn0MeasMap = dnn0dzMap*1;
                for (j = [1:size(dnn0dzMap,1)])
                    dnn0dz = dnn0dzMap(j,:);
                    dnn0Meas = filter(hd1, [dnn0dz, zeros(1, dly1)]);
                    dnn0Meas = dnn0Meas(dly1+1:end);
                    dnn0Meas = filter(hdf, [dnn0Meas, zeros(1, dlyf)]);
                    dnn0Meas = dnn0Meas(dlyf+1:end) / (2*pi/Nperiod);
                    dnn0MeasMap(j,:) = dnn0Meas;
                end
                
                h = figure;
                if (length(densLimit) == 2)
                    imagesc(x2, [-z2(end:-1:2) z2(1:end)], [dnn0MeasMap(end:-1:2,:);dnn0MeasMap(1:end,:)], densLimit); %, [-0.03 0.02]);
                else
                    imagesc(x2, [-z2(end:-1:2) z2(1:end)], [dnn0MeasMap(end:-1:2,:);dnn0MeasMap(1:end,:)]);
                end
                colorbar;
                saveas(h, strcat(dirOut, sprintf('density-%06d.png', i)), 'png');
                close(h);
                
                % save the data
                save(strcat(dirOut, sprintf('data-%06d.mat', i)), 'x2', 'z2', 'dnn0MeasMap', 'dww0Map');
            end
            
        end
    end
    
    % save memory by clearing the huge matrix
    clear data;
end

end

end
