addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\oblique-angle\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\abel_transform\');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fdir = 'C:\Users\kasim\Desktop\Simulation\oblique-angle\30-wakefield-test\h5-ne-slice-z\';
fdirOut = 'C:\Users\kasim\Desktop\Simulation\oblique-angle\30-wakefield-test\img-abel-density\';
fformat = 'charge-slice-electrons-x3-01-%06d.h5';
datasetname = '/charge x3 slice';
initFile = 14;
finalFile = 14;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% geometry parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
theta = -20*pi/180*1;
w0wp = 9.8436826981031498;
a = 0.0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% START OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
refreshFilter = 0;
sampFac = 1;
Nfilter = 5000; % obtained by running wigner mode
Nperiod = 625.1286; % period of a linear plasma wave (in downsampled wave). should be the Nperiod value after the first run
if (~exist('df','var') || isempty(df) || refreshFilter)
    % double integrator filter
    nfir = 8000;
    f = linspace(0, 1, Nfilter);
    f0 = 1./Nperiod * 2;
    fbound = f0 * 3/4;
    a = (f > fbound) .* (f0*f0./f./f) + (f <= fbound) .* (f0*f0/fbound/fbound);
    a(1) = f0*f0/fbound/fbound;
    % a = fbound^2 ./ (fbound^2 + f.^2) * f0^2;
    d = fdesign.arbmag('N,F,A', nfir, f, a);
    hd1 = design(d, 'equiripple');
    dly1 = mean(grpdelay(hd1));
    
    % differentiator filter
    df = fdesign.differentiator('N,Fp,Fst', nfir, 6*f0, 6.5*f0);
    hdf = design(df, 'equiripple');
    dlyf = mean(grpdelay(hdf));
    dphi = 2*pi / Nperiod;
    disp('Filter created');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for (i = [initFile:1:finalFile])
    i
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% forward (from dnn0 to dww0) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % construct the full address of the file
    fname = sprintf(fformat, i);
    filename = strcat(fdir, fname);
    
    % read the attributes
    time = h5readatt(filename, '/', 'TIME');
    posMin = h5readatt(filename, '/', 'XMIN');
    posMax = h5readatt(filename, '/', 'XMAX');
    
    % get the data
    data = h5read(filename, datasetname);
    [N1 N2] = size(data);
    data = (-data'-1);
    
    % take the derivation of the data
    ddata = data;
    for (j = [1:size(data,1)])
        linedata = data(j,:);
        lineddata = filter(hdf, [linedata, zeros(1, dlyf)]);
        lineddata = lineddata(dlyf+1:end) / (2*pi/Nperiod);
        ddata(j,:) = lineddata;
    end
    
    % set the x, y, z axis
    x = linspace(posMin(1), posMax(1), N1);
    y = linspace(posMin(2), posMax(2), N2);
    
    halfData = ddata(round(length(y)/2):end,:);
    halfY = y(round(length(y)/2):end);
    [x2, r2, abel_data] = mod_abel_transform(x, halfY(1:sampFac:end), halfData(1:sampFac:end,1:sampFac:end), a, 0);
    abel_data = -(1/w0wp)^2/2/abs(sin(theta)) * abel_data;
    
    % save the figure
    h = figure;
    fout = strcat(fdirOut, sprintf('abel-%06d.png', i));
    imagesc(x2(500:end), [-r2(end:-1:1) r2(2:end)], [abel_data(end:-1:1,500:end) ; abel_data(2:end,500:end)]);
    colorbar;
    saveas(h, fout, 'png');
    close(h);
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% inversion (from dww0 to dnn0) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    i + .5
    % now inverse the abel_data
    dww0MapHalf = abel_data;
    if (size(r2,1) ~= 1) r2 = r2'; end;
    [x2, r2, dnn0dzMap] = mod_abel_transform(x2, r2, dww0MapHalf * (-2) * w0wp^2*abs(sin(theta)), a, 1);
    
    dnn0MeasMap = dnn0dzMap;
    for (j = [1:size(dnn0dzMap,1)])
        dnn0dz = dnn0dzMap(j,:);
        dnn0Meas = filter(hd1, [dnn0dz, zeros(1, dly1)]);
        dnn0Meas = dnn0Meas(dly1+1:end);
        dnn0Meas = filter(hdf, [dnn0Meas, zeros(1, dlyf)]);
        dnn0Meas = dnn0Meas(dlyf+1:end) / (2*pi/Nperiod);
        dnn0MeasMap(j,:) = dnn0Meas;
    end
    
    % save the data
    save(strcat(fdirOut, sprintf('data-%06d.mat', i)), 'dww0MapHalf', 'dnn0MeasMap', 'x2', 'r2');
    
    % save the figure
    h = figure;
    fout = strcat(fdirOut, sprintf('meas-%06d.png', i));
    imagesc(x2(500:end), [-r2(end:-1:1) r2(2:end)], [dnn0MeasMap(end:-1:1,500:end) ; dnn0MeasMap(2:end,500:end)]);
    colorbar;
    saveas(h, fout, 'png');
    close(h);
end
plot(x2, [data(150,:);-dnn0MeasMap(1,:)]);
