%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% RUN THE WAKEFIELD_EVOLUTION.M FILE FIRST!!! %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\oblique-angle\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\abel_transform\');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% START OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
refreshFilter = 1;
Nfilter = 749; %5817; % obtained by running wigner mode (= size(rotatedData,2))
Nperiod = 62.8; %587.4287+2; % period of a linear plasma wave (in downsampled wave). should be the Nperiod value after the first run
if (~exist('df','var') || isempty(df) || refreshFilter)
    % double integrator filter
    nfir = 200;
    f = linspace(0, 1, Nfilter);
    f0 = 1./Nperiod * 2;
    
    % differentiator filter
    df = fdesign.differentiator('N,Fp,Fst', nfir, 8*f0, 10*f0);
    hdf = design(df, 'equiripple');
    dlyf = mean(grpdelay(hdf));
    dphi = 2*pi / Nperiod;
    disp('Filter created');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% simulation parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
theta = -20*pi/180;
y0 = 10 - 55*tan(theta);
w0wp = 20; %9.8436826981031498 or 15 or other w0wp-s;
xdownsample = 15; % 10 or 15 only
yMax = 20;
xMin = 15;
xMax = 50;
xMinSymm = 90;
dww0Lim = [-1 1]*1e-2; %[-3 3] * 1e-2 or 1e-3;

vp = 44000/(1+44000^2)^.5;
vg = w0wp/(1+w0wp^2)^.5;
a = abs((cos(theta) - vp/vg)/sin(theta));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fdir = 'C:/Users/kasim/Desktop/Simulation/oblique-angle/a31-freq-020-theta-020-amp-015/h5-ne-slice-z/';
fdirOut = 'C:/Users/kasim/Desktop/Simulation/oblique-angle/a31-freq-020-theta-020-amp-015/img-slice-z-rotated-7/';
fformat = 'charge-slice-electrons-x3-01-%06d.h5';
datasetname = '/charge x3 slice';
initFile = 13;
finalFile = 20;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for (i = [initFile:finalFile])
    % i = initFile;
    i
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% rotate the image %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % construct the full address of the file
    fname = sprintf(fformat, i);
    filename = strcat(fdir, fname);
    
    % read the attributes
    time = h5readatt(filename, '/', 'TIME');
    posMin = h5readatt(filename, '/', 'XMIN');
    posMax = h5readatt(filename, '/', 'XMAX');
    
    % read the data
    data = h5read(filename, datasetname);
    [N1 N2] = size(data);
    
    % set the x, y, z axis
    x = linspace(posMin(1), posMax(1), N1+1); x = x(1:end-1);
    y = linspace(posMin(2), posMax(2), N2+1); y = y(1:end-1);
    x = x(1:xdownsample:end);
    data = data(1:xdownsample:end, 1:end);
    
    % get the rotated image
    y0Image = y0 + x(1) * tan(theta);
    % [xNew, yNew, rotatedData] = rotateHalfImage(x(1), y0Image, theta, x, y, data');
    [xNew, yNew, rotatedData] = rotateHalfImage2(x(1), y0Image, theta, x, y, -data'-1);
    
    % make it smooth first
    Nsmooth = 5;
    ssmooth = 1;
    [xsmooth, ysmooth] = meshgrid([1:Nsmooth]-ceil(Nsmooth/2),[1:Nsmooth]-ceil(Nsmooth/2));
    Bsmooth = exp(-(xsmooth.*xsmooth + ysmooth.*ysmooth) / 2 / ssmooth / ssmooth);
    Bsmooth = Bsmooth / sum(sum(Bsmooth));
    rotatedData = conv2(rotatedData, Bsmooth, 'same');
    
    % make the symmetry at the first row
    symmetryFirstRow = 1;
    if (symmetryFirstRow)
        xc = (x(end) + x(1)) / 2;
        symmDefault = round(size(rotatedData,1)/2 + (y0Image + (xc-x(1))*tan(theta)) * cos(theta) / (y(2) - y(1)));
        symmDelta = 10;
        
        symmIdx = [];
        symmMax = [];
        xSymm = find(xNew > xMinSymm);
        for j = xSymm
            colConv = conv(rotatedData(:,j), rotatedData(:,j));
            [m, sIdx] = max(colConv((symmDefault-symmDelta)*2:(symmDefault+symmDelta)*2));
            symmMax(j) = m;
            symmIdx(j) = (sIdx + (symmDefault-symmDelta)*2 - 1)/2;
        end
        
        if (abs(sum(symmMax)) > 1e-9)
            ySymmIdx = round(sum(symmIdx .* symmMax) / sum(symmMax));
        else
            ySymmIdx = symmDefault;
        end
        
        yNew = yNew(ySymmIdx:end);
        yNew = [1:length(yNew)] * (yNew(2) - yNew(1));
        rotatedData = rotatedData(ySymmIdx:end,:);
    end
    
    % interpolate using cubic spline
    interpolate = 1;
    if (interpolate > 1)
        yNewNew = linspace(yNew(1),yNew(end),interpolate*length(yNew));
        
        rotatedDataNew = zeros(size(rotatedData,1)*interpolate, size(rotatedData,2));
        for j = [1:size(rotatedData,2)]
            rotatedDataNew(:,j) = spline(yNew, rotatedData(:,j), yNewNew);
        end
        
        rotatedData = rotatedDataNew;
        yNew = yNewNew;
    end
    
    % show the new image
    imagesc(xNew, yNew, rotatedData);
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% transform from dnn0 to dww0 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    i + .5
    
    % crop the image vertically
    yIdx = (yNew < yMax);
    dnn0Map = rotatedData(yIdx , :);
    yNew = yNew(yIdx);
    
    % take the derivation of the data
    dnn0dzMap = dnn0Map;
    for (j = [1:size(dnn0Map,1)])
        dnn0Line = dnn0Map(j,:);
        dnn0Line = filter(hdf, [dnn0Line, zeros(1, dlyf)]);
        dnn0Line = dnn0Line(dlyf+1:end) / (2*pi/Nperiod);
        dnn0dzMap(j,:) = dnn0Line;
    end
    
    % abel transform
    % [xAbel, yAbel, abel_data] = mod_abel_transform(xNew/cos(theta), yNew, dnn0dzMap, a, 0);
    [xAbel, yAbel, abel_data] = mod_abel_transform(xNew, yNew, dnn0dzMap, a, 0);
    xdww0 = xAbel * cos(theta);
    ydww0 = yAbel;
    dww0Map = -(1/w0wp)^2/2/abs(sin(theta))* (vp/vg) * abel_data;
    
    % crop the image horizontally
    xIdx = (xdww0 <= (xdww0(1) + xMax)) & (xdww0 >= (xdww0(1) + xMin));
    xdww0 = xdww0(xIdx);
    dww0Map = dww0Map(:,xIdx);
    
    % construct the full map
    dww0MapFull = [dww0Map(end:-1:1,1:end) ; dww0Map(2:end,1:end)];
    ydww0Full = [-ydww0(end:-1:1) , ydww0(2:end)];
    
    % save the dnn0 figure
    h = figure;
    fout = strcat(fdirOut, sprintf('dnn0-%06d.png', i));
    imagesc(xNew, yNew, dnn0Map);
    colorbar;
    saveas(h, fout, 'png');
    close(h);
    
    % save the dww0 figure
    h = figure;
    fout = strcat(fdirOut, sprintf('dww0-%06d.png', i));
    imagesc(xdww0(1:end), ydww0Full, dww0MapFull(:,1:end), dww0Lim);
    colorbar;
    saveas(h, fout, 'png');
    close(h);
    
    % save the data
    save(strcat(fdirOut, sprintf('data-%06d.mat', i)), 'dww0Map', 'xdww0', 'ydww0', 'dnn0Map', 'xNew', 'yNew');
    
    % save the h5 file
    %%% the dataset first
    h5filename = strcat(fdirOut, sprintf('dww0-%06d.h5', i));
    datasetname2 = '/dww0';
    h5create(h5filename, datasetname2, size(dww0MapFull'));
    h5write(h5filename, datasetname2, dww0MapFull');
    
    %%% the attributes
    location = '/';
    h5writeatt(h5filename, location, 'TIME', time);
    h5writeatt(h5filename, location, 'XMIN', [min(xdww0) min(ydww0Full)]);
    h5writeatt(h5filename, location, 'XMAX', [max(xdww0) max(ydww0Full)]);
end
% plot(xdww0, dww0Map(1,:));
