% physical parameters
c = 3e8;
n0 = 1.5;
n1 = 1.5;
n2 = 1; % ???
lmbda = 800e-9;
T = lmbda/c;
sigma = 3.5*lmbda;
phi = 1; % amplitude of the phase modulation
vg = c/n1;
w0 = 2*pi*c/lmbda;
k0 = w0/c*n0;
kp = w0/c/8;

% simulation parameters
N = 3000;
x = linspace(-1,1,N) * 10e-6;
f = linspace(-1,1,N) * 1/(x(2)-x(1))/2;
kMinIdx = 2850;
kMaxIdx = 3000;
xMinIdx = 1;
xMaxIdx = 3000;

% image parameters
fdirOut = '\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\photon-acc\phot-acc-in-disperse-medium\';
zMin = -500;
zMax = 1000;
labelxWigner = 'Position (m)';
labelyWigner = '\Delta f/f_0';
titleWigner  = 'Wigner transform of the signal at n2*t = %f * 1e-15';

yMinS = 0;
yMaxS = 1e4;
labelxS2 = labelxWigner;
labelyS2 = 'Intensity (arb. units)';
titleS2  = 'Intensity at n2*t = %f * 1e-15';

% yMinW = -;
labelxW = labelxWigner;
labelyW = '\Delta f/f_0';
titleW  = 'Frequency change profile at n2*t = %f * 1e-15';

% electric field
for (j = [0:10:1000])
    t = j*T;
    sigmat = (sigma^2 + (n2*t/sigma)^2)^.5;

    besselSum = [0];
    besselSumP = [inf];
    p = 0;
    while (max(abs(besselSum - besselSumP)) > 1e-16)
        besselSumP = besselSum;
        a = -kp * (sigma^2 - 1i*n2*t) / sigmat^2 * x;
        b = -kp^2 * (sigma^2 - 1i*n2*t) / 2 / sigmat^2 * n2*t;
        besselSum = besselSum + besselj(p, phi) * (1i)^p * exp(1i*a*p + 1i*b*p*p);
        p = p + 1;
    end

    besselSumP = [inf];
    p = -1;
    while (max(abs(besselSum - besselSumP)) > 1e-16)
        besselSumP = besselSum;
        a = -kp * (sigma^2 - 1i*n2*t) / sigmat^2 * x;
        b = -kp^2 * (sigma^2 - 1i*n2*t) / 2 / sigmat^2 * n2*t;
        besselSum = besselSum + besselj(p, phi) * (1i)^p * exp(1i*a*p + 1i*b*p*p);
        p = p - 1;
    end

    E = exp(1i*(k0*x + k0*vg*t - w0*t)) * (sigmat/sigma)^.5 * exp(-.5*1i*atan(n2*t/sigma^2)) .* exp(-x.^2/2/sigmat^2) .* exp(1i*x.^2*n2*t/2/sigma^2/sigmat^2) .* besselSum;
    
    wigner = tfrwv(E');
    wignerCrop = wigner(kMinIdx:kMaxIdx , xMinIdx:xMaxIdx);
    fCrop = f(kMinIdx:kMaxIdx);
    
    s2 = sum(wignerCrop,1);
    fs2 = sum(wignerCrop .* repmat(fCrop', 1, size(wignerCrop,2)), 1);
    f0 = sum(fs2) / sum(s2);
    fx = (fs2 ./ s2 - f0)/f0 .* (s2 > 0.005*max(s2));
    
    % save the wigner image
    h = figure;
    imagesc(x, (fCrop-f0)/f0, wignerCrop, [zMin, zMax]);
    xlabel(labelxWigner);
    ylabel(labelyWigner);
    title(sprintf(titleWigner, n2*t*1e15));
    saveas(h, strcat(fdirOut, sprintf('wigner-%04d.png', j)), 'png');
    close(h);
    
    % save the intensity image
    h = figure;
    plot(x, s2);
    ylim([yMinS, yMaxS]);
    xlim([min(x) max(x)]);
    xlabel(labelxS2);
    ylabel(labelyS2);
    title(sprintf(titleS2, n2*t*1e15));
    saveas(h, strcat(fdirOut, sprintf('intensity-%04d.png', j)), 'png');
    close(h);
    
    % save the frequency image
    h = figure;
    plot(x, fx);
    xlim([min(x) max(x)]);
    xlabel(labelxW);
    ylabel(labelyW);
    title(sprintf(titleW, n2*t*1e15));
    saveas(h, strcat(fdirOut, sprintf('freq-%04d.png', j)), 'png');
    close(h);
end
