% This file is to read dw/w0 from .mat data processed from the 3D simulations and process it further to obtain the density profile.
% Author: Muhammad F. Kasim

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% START OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
refreshFilter = 0;
sampFac = 1;
% Nfilter = 10000;
% Nperiod = 1.2551e+03;
% Nfilter = 7500;
% Nperiod = 940.4478;
Nfilter = 5000; % obtained by running wigner mode
Nperiod = 625.0872; % period of a linear plasma wave (in downsampled wave). should be the Nperiod value after the first run
if (~exist('df','var') || isempty(df) || refreshFilter)
    % double integrator filter
    nfir = 8000*Nfilter/5000;
    f = linspace(0, 1, Nfilter);
    f0 = 1./Nperiod * 2;
    fbound = f0 * 3/4;
    a = (f > fbound) .* (f0*f0./f./f) + (f <= fbound) .* (f0*f0/fbound/fbound);
    a(1) = f0*f0/fbound/fbound;
    % a = fbound^2 ./ (fbound^2 + f.^2) * f0^2;
    d = fdesign.arbmag('N,F,A', nfir, f, a);
    hd1 = design(d, 'equiripple');
    dly1 = mean(grpdelay(hd1));
    
    % differentiator filter
    df = fdesign.differentiator('N,Fp,Fst', nfir, 6*f0, 6.5*f0);
    hdf = design(df, 'equiripple');
    dlyf = mean(grpdelay(hdf));
    dphi = 2*pi / Nperiod;
    disp('Filter created');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% BEGINNING OF THE PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ifiles = [1:5];
% filesNums = [12, 13, 15, 16, 17]; % angle 025
filesNums = [13, 14, 16, 18, 19]+1; % angle 020
% filesNums = [15, 18, 20, 22, 24]; % angle 015
% filesNums = [21, 24, 27, 30, 33]; % angle 010
% filesNums = [32, 38, 44, 50, 55]; % angle 005
% filesNums2 = filesNums + 1;
% filesNums = [19];
filesNums2 = -1;

for (ifile = ifiles)
ifile

% File information for electric field and electron density distribution
fdir = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/37-taking-data-1ppc-015/freq-slice-%02d/', ifile);
fformat = 'data-%06d.mat';
dirOut = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/37-taking-data-1ppc-015/freq-slice-%02d/', ifile);
abel_inverse = @(x, z, data, a) mod_abel_inversion_3_pts(x, z, data, a);
% abel_inverse = @(x, z, data, a) mod_abel_transform2(x, z, data, a, 1);

theta = 20*pi/180;
w0wp = 9.8436826981031498; %9.8436826981031498;
% densLimit = -9999; %[-.25 .2];
% dww0Limit = -9999;
densLimit = [-.5 .5];
dww0Limit = [-5 5]*1e-3;

vp = 44000/(1+44000^2)^.5;
vg = w0wp/(1+w0wp^2)^.5;
a = abs((cos(theta) - vp/vg)/sin(theta));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF THE PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\oblique-angle\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\abel_transform\');

    i = filesNums(ifile);
    
    % construct the full address of the file
    fname = sprintf(fformat, i);
    filename = strcat(fdir, fname);
    
    % load the variables
    load(filename, 'x2', 'z2', 'dww0Map');
    dww0MapOriginal = dww0Map;
    
    % normalise the dww0Map
    nonZeroIdx = find(sum(dww0Map.^2, 1) ~= 0);
    midNonZeroIdx = nonZeroIdx(round(length(nonZeroIdx)/2));
    dww0Map(:,nonZeroIdx) = dww0Map(:,nonZeroIdx) - mean((dww0Map(1,midNonZeroIdx) + dww0Map(end,midNonZeroIdx))/2);
    
    dww0MapSymm = (dww0Map + dww0Map(end:-1:1,:)) / 2;
    % dww0MapHalf = dww0MapSymm(floor(0.5*size(dww0Map,1))+1:end,:);
    dww0MapHalf = dww0Map(floor(0.5*size(dww0Map,1))+1:end,:);
    
    % obtain the dnn0/dz map from the inverse abel transform
    [x2, z2, dnn0dzMap] = abel_inverse(x2, z2, dww0MapHalf * (-2) * w0wp^2*abs(sin(theta)), a);
    
    % integrate horizontally dnn0/dz map to get dnn0 profile
    dnn0MeasMap = dnn0dzMap*1;
    for (j = [1:size(dnn0dzMap,1)])
        dnn0dz = dnn0dzMap(j,:);
        dnn0Meas = filter(hd1, [dnn0dz, zeros(1, dly1)]);
        dnn0Meas = dnn0Meas(dly1+1:end);
        dnn0Meas = filter(hdf, [dnn0Meas, zeros(1, dlyf)]);
        dnn0Meas = dnn0Meas(dlyf+1:end) / (2*pi/Nperiod);
        dnn0MeasMap(j,:) = dnn0Meas;
    end
    
    h = figure;
    if (length(densLimit) == 2)
        imagesc(x2, [-z2(end:-1:2) z2(1:end)], [dnn0MeasMap(end:-1:2,:);dnn0MeasMap(1:end,:)], densLimit); %, [-0.03 0.02]);
    else
        imagesc(x2, [-z2(end:-1:2) z2(1:end)], [dnn0MeasMap(end:-1:2,:);dnn0MeasMap(1:end,:)]);
    end
    colorbar;
    saveas(h, strcat(dirOut, sprintf('density-%06d.png', i)), 'png');
    close(h);
    
    % save the data
    dww0Map = dww0MapOriginal;
    save(strcat(dirOut, sprintf('data-%06d.mat', i)), 'x2', 'z2', 'dnn0MeasMap', 'dww0Map');

end
