addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\oblique-angle\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\abel_transform\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\fourier-optics\');

fdir = 'C:\Users\kasim\Desktop\Simulation\oblique-angle\34-poc-20deg-3d-highf-larger-grid\h5-ne\';
fformat = 'charge-savg-electrons-%06d.h5';
datasetname = '/charge';
filenum = 12;

slice = 3; % 1 for x, 2 for y, and 3 for z 
pos = 0;

%%%%%%%%%%%%%%%%%%% read the file %%%%%%%%%%%%%%%%%%%
fname = sprintf(fformat, filenum);
filename = strcat(fdir, fname);

% read the attributes
time = h5readatt(filename, '/', 'TIME');
posMin = h5readatt(filename, '/', 'XMIN');
posMax = h5readatt(filename, '/', 'XMAX');

% get the E data
data = h5read(filename, datasetname);
[N1 N2 N3] = size(data);

% set the x, y, z axis
x = linspace(posMin(1), posMax(1), N1);
y = linspace(posMin(2), posMax(2), N2);
z = linspace(posMin(3), posMax(3), N3);

p0 = posMin(slice);
p1 = posMax(slice);
idx = round((pos - p0) * (size(data,slice) - 1) / (p1 - p0));

if (slice == 1)
    data2d = permute(data(idx,1:end,1:end), [3 2 1]);
    xgraph = y;
    ygraph = z;
elseif (slice == 2)
    data2d = permute(data(1:end,idx,1:end), [3 1 2]);
    xgraph = x;
    ygraph = z;
else
    data2d = permute(data(1:end,1:end,idx), [2 1 3]);
    xgraph = x;
    ygraph = y;
end

imagesc(xgraph, ygraph, data2d);
