%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% RUN THE WAKEFIELD_EVOLUTION.M FILE FIRST!!! %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% basic parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
thetad = 25;
Nx1 = 9750;
projectName = 'a13-freq-015-theta-025';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
projectNameSplit = strsplit(projectName, '-');
fdirformat = strcat('C:/Users/kasim/Desktop/Simulation/oblique-angle/', projectName, '/freq-slice-%02d/');
fdirOut = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/', projectName);
fcode = cell2mat(projectNameSplit(1));
fformat = 'data-%06d.mat';

if      (thetad == 25) files = [12, 13, 15, 16, 17]; % angle 025
elseif  (thetad == 20) files = [13, 14, 16, 18, 19]; % angle 020
elseif  (thetad == 15) files = [15, 18, 20, 22, 24]; % angle 015
elseif  (thetad == 10) files = [21, 24, 27, 30, 33]; % angle 010
elseif  (thetad ==  5) files = [32, 38, 44, 50, 55]; % angle 005
end;

% files = [21, 24, 27, 31, 33]+0;
% files = [13, 14, 16, 18, 19]+0;
% files = [13, 14];%, 16, 18, 19];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% simulation parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
yposs = [0, -3, -6, -9, -11];
% yposs = [0, -3];%, -6, -9, -11];
toRead = 'density'; % 'frequency' or 'density';
theta = -thetad*pi/180;
y0 = 10 - 55*tan(theta);

if (Nx1 == 13000)
    xminIdx = 4000; % f = 20
    xmaxIdx = 7500;
elseif (Nx1 == 9750)
    xminIdx = 3000; % f = 15
    xmaxIdx = 5500;
else
    xminIdx = 2400; % f = 10
    xmaxIdx = 3800;
end
    
centredGraph = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

xposs = (yposs - y0) / tan(theta);
peaksMeas = files*0;
troughsMeas = files*0;
for (i = [1:length(files)])
% for (i = 5)
    i;
    % construct the full address of the file
    ifile = files(i);
    fdir = sprintf(fdirformat, i);
    fname = sprintf(fformat, ifile);
    filename = strcat(fdir, fname);
    
    load(filename, 'x2', 'z2', 'dnn0MeasMap', 'dww0Map');
    
    if (strcmp(toRead, 'density'))
        if (xmaxIdx < 1) xmaxIdx = size(dnn0MeasMap, 2); end;
        data = -dnn0MeasMap(:,xminIdx:xmaxIdx);
        % data = -dnn0MeasMap(1,xminIdx:xmaxIdx);
    else
        if (xmaxIdx < 1) xmaxIdx = size(dww0Map, 2); end;
        data = dww0Map(round(size(dww0Map,1)/2),xminIdx:xmaxIdx);
    end;
    
    peaksMeas(i) = max(max(data));
    troughsMeas(i) = min(min(data));
end

if (centredGraph)
    centre = (mean(peaksMeas) + mean(troughsMeas)) / 2;
else
    centre = 0;
end

% plot the measured data
hold on;
plot(xposs, (peaksMeas-centre), 'mo', 'LineWidth', 2);
plot(xposs, (troughsMeas-centre), 'ko', 'LineWidth', 2);
hold off;

% save the data
save(strcat(fdirOut, fcode, '-', dataType, '-measured-data.mat'), 'xposs', 'peaksMeas', 'troughsMeas');
h = gcf; saveas(h, strcat(fdirOut, fcode, '-density-comparison.png'), 'png');

disp(1 - (mean(peaksMeas) - mean(troughsMeas)) / (mean(ypeaks) - mean(ytroughs)));

% troughsMeas(1)
% peaksMeas(1)
