addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\experiments');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% fundamental variables
c = 3e8;
e = 1.6e-19;
m = 9.1e-31;
e0 = 8.85e-12;

% experimental variables
TA2 = 1;
AWAKE = 0;
import_parameters;
if (TA2)
    minN0 = 1e18*1e6; % plasma density in m^-3
    maxN0 = 2e19*1e6; % plasma density in m^-3
    minDn = 0.1;
    maxDn = 0.8;
elseif (AWAKE)
    minN0 = .9*7e14*1e6;
    maxN0 = 1.1*7e14*1e6;
    minDn = 0.1;
    maxDn = 2.6;
else
    minN0 = 7e14*1e6;
    maxN0 = 7e14*1e6;
    minDn = 0.1;
    maxDn = 0.6;
end

N = 1000;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dnn0 = linspace(minDn, maxDn, N);
n0 = linspace(minN0, maxN0, N);
[N0, DNN0] = meshgrid(n0, dnn0);

w0 = 2*pi*c/lmbdaCentre;
WP = (N0*e*e/m/e0).^.5;
PHI0 = WP / w0 / 2 .* DNN0 .* WP / c * ((2*pi)^.5/2 * r / sin(theta));

NLAMBDA = (2*pi ./ WP) / (w0/alpha * lmbdaRes/lmbdaCentre);
DPHIRES = (tau + WP / alpha .* PHI0) * w0/lmbdaCentre * lmbdaRes;
NO_OVERLAP = alpha * (tau - 0*4*tau0) ./ WP - PHI0;
WAVECOVER = tau0*2 ./ (2*pi ./ WP);

NN = 5;
QNLAMBDA = .5 * (1 + erf((NLAMBDA - 6)/1*NN)); % the time resolution should be small enough to formed maximum 1/6 lambda_p
QDPHIRES = .5 * (1 - erf((DPHIRES - pi/2)/.1*NN)); % the maximum phase change in one voxel should not exceed pi/2
QNO_OVERLAP = .5 * (1 + erf((NO_OVERLAP-3.5)/2*NN)); % overlapping intensity from the oscillating part must not exceed 1%
QWAVECOVER = .5 * (1 + erf((WAVECOVER - 2)/.5*NN)); % the pulse duration should be long enough to cover 2 wavelength of the wakefield
QUALITY = (QNLAMBDA .* QDPHIRES .* QNO_OVERLAP .* QWAVECOVER);

imagesc(n0, dnn0, QUALITY, [0 1]);
xlabel('n_0 (m^{-3})');
ylabel('\Deltan/n_0');
colormap gray;
colorbar;
