%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
scanning = 'angle-freq'; % 'angle-freq'
fdir = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/scanning-%s/', scanning);
datatype = 'density'; % 'frequency' or 'density'
show = 'error'; % 'value' or 'error'
withMeasurement = 1;
withErrorbar = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% simulation parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if (strcmp(scanning, 'angle-freq'))
    %%% angle-freq scanning
    xlabelStr = 'Crossing angle (degrees)';
    ylabelStr = '\omega_0/\omega_p';
    simCodes = [47, 46, 45, 48, 44; 109, 68, 64, 50, 113; 110, 69, 65, 51, 114; 111, 70, 66, 52, 115; 112, 71, 67, 53, 116];
    xvalues = [5, 10, 15, 20, 25];
    yvalues = [10, 15, 20, 25, 30];
    
    simCodes = simCodes(:,1:end-1);
    xvalues = xvalues(1:end-1);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

measuredVals = zeros(size(simCodes));
actualVals = zeros(size(simCodes));
measuredStd = zeros(size(simCodes));
actualStd = zeros(size(simCodes));
for (y = [1:size(simCodes,1)])
    for (i = [1:size(simCodes,2)])
        simCode = sprintf('%02d', simCodes(y,i));
        if (simCodes(y,i) >= 100) simCode = sprintf('a%02d', simCodes(y,i)-100); end;
        
        fnameWakefield = strcat(fdir, simCode, '-', datatype, '-wakefield-data.mat');
        fnameMeasured  = strcat(fdir, simCode, '-', datatype,  '-measured-data.mat');
        
        % load the actual values and the measured values and its ordinates
        load(fnameWakefield, 'xpeaks', 'peaks', 'xtroughs', 'troughs');
        if (withMeasurement) load(fnameMeasured, 'peaksMeas', 'troughsMeas', 'xposs'); end
        
        % only keep the values within the range of the measurement
        if (withMeasurement)
            peaksFiltered = peaks((xpeaks <= max(xposs)) & (xpeaks >= min(xposs)));
            troughsFiltered = troughs((xtroughs <= max(xposs)) & (xtroughs >= min(xposs)));
        else
            peaksFiltered = peaks;
            troughsFiltered = troughs;
        end
        
        % get the actual peaks and troughs mean
        peaksMean = mean(peaksFiltered);
        troughsMean = mean(troughsFiltered);
        peaksStd = std(peaksFiltered);
        troughsStd = std(troughsFiltered);
        
        % save the actual average value of peaks and troughs 
        actualVals(y,i) = (peaksMean - troughsMean)/2;
        actualStd(y,i)  = (peaksStd^2 + troughsStd^2)^.5;
        
        if (withMeasurement)
            % getting the mean of measurement values
            peaksMeasMean = mean(peaksMeas);
            troughsMeasMean = mean(troughsMeas);
            peaksMeasStd = std(peaksMeas);
            troughsMeasStd = std(troughsMeas);
            
            % save the measured average value of peaks and troughs 
            measuredVals(y,i) = (peaksMeasMean - troughsMeasMean)/2;
            measuredStd(y,i) = (peaksMeasStd^2 + troughsMeasStd^2)^.5;
        end
    end
    
    % sort the measured and actual values according to x values
    [xvaluesTemp, xvaluesIdx] = sort(xvalues);
    actualVals(y,:) = actualVals(y,xvaluesIdx);
    actualStd(y,:) = actualStd(y,xvaluesIdx);
    if (withMeasurement)
        measuredVals(y,:) = measuredVals(y,xvaluesIdx);
        measuredStd(y,:) = measuredStd(y,xvaluesIdx);
    end
    
end
if (withMeasurement)
    % compute the errors and display the maximum error
    errors = abs(actualVals - measuredVals) ./ actualVals * 100;
    disp(max(max(errors)))
end

if (strcmp(show, 'value'))
    surf(xvalues, yvalues, measuredVals);
    hold on;
    surf(xvalues, yvalues, actualVals);
    hold off;
elseif (strcmp(show, 'error'))
    imagesc(xvalues, yvalues, errors);
end
xlabel(xlabelStr);
ylabel(ylabelStr);
