% This file is to read the measurement from 3D oblique-angle project and valid only for proof-of-concept (POC) part.
% The script reads the final intensity and frequency maps for an x2-sliced E-data and compare it to its initial value.
% The obtained dw/w0 frequency maps are then applied to inverse modified abel transform to get the derivative of wakefield profile.
% There are 4 modes in this file:
%   * 'wigner': to see the wigner transform of the middle axis electric field and to see the initial values.
%   * 'intensity_freq': to see the intensity and frequency change maps for the electric field at the x2=yFrac plane.
%   * 'density': to see the density profile distribution according to the measurement at the x2=yFrac plane.
%   * 'movie': to create a movie of wakefield density changes based on the measurement.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% START OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
refreshFilter = 0;
if (~exist('df','var') || isempty(df) || refreshFilter)
    % double integrator filter
    nfir = 8000;
    Nfilter = 5000; % obtained by running wigner mode
    Nperiod = 312.5623*2; % period of a linear plasma wave (in downsampled wave). should be the Nperiod value after the first run
    f = linspace(0, 1, Nfilter);
    f0 = 1./Nperiod * 2;
    fbound = f0 * 3/4;
    a = (f > fbound) .* (f0*f0./f./f) + (f <= fbound) .* (f0*f0/fbound/fbound);
    a(1) = f0*f0/fbound/fbound;
    d = fdesign.arbmag('N,F,A', nfir, f, a);
    hd1 = design(d, 'equiripple');
    dly1 = mean(grpdelay(hd1));
    
    % differentiator filter
    df = fdesign.differentiator('N,Fp,Fst', nfir, 6*f0, 6.5*f0);
    hdf = design(df, 'equiripple');
    dlyf = mean(grpdelay(hdf));
    dphi = 2*pi / Nperiod;
    disp('Filter created');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF THE FILTER SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% BEGINNING OF THE PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File information for electric field and electron density distribution
fdir = 'C:\Users\kasim\Desktop\Simulation\oblique-angle\28-poc-20deg-3d-var\h5-e3\';
fformat = 'e3-%06d.h5';
datasetname = '/e3';
dirOut = 'C:\Users\kasim\Desktop\Simulation\oblique-angle\28-poc-20deg-3d-var\intensity-freq\';
initEFile = 0;
finalEFile = 24;
wlimit = 0.01;
dispW = @(K) (1 + K.*K).^.5 .* ((-1) .* (K < 0) + (K > 0));

information = 'intensity_freq';

xROI = [0 50];
kROI = [2.2 4];
% kROI = [-999999999999999 999999999999999];

yFrac = 0.5;
zFrac = 0.5;
a = 0.19*0;
propagation = -110; % if < 0, it is back-propagation
theta = 20*pi/180;
w0wp = 9.8436826981031498;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF THE PARAMETERS SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\oblique-angle\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\abel_transform\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\fourier-optics\');
for (i = [initEFile finalEFile])
    % construct the full address of the file
    fname = sprintf(fformat, i);
    filename = strcat(fdir, fname);
    
    % read the attributes
    time = h5readatt(filename, '/', 'TIME');
    posMin = h5readatt(filename, '/', 'XMIN');
    posMax = h5readatt(filename, '/', 'XMAX');
    
    % get the E data
    data = h5read(filename, datasetname);
    data = data(1:2:end, 1:2:end, 1:2:end);
    [N1 N2 N3] = size(data);
    
    % set the x, y, z axis
    x = linspace(posMin(1), posMax(1), N1);
    y = linspace(posMin(2), posMax(2), N2);
    z = linspace(posMin(3), posMax(3), N3);
    kx = [0:N1-1]/N1/(x(2)-x(1));
    
    % crop the x axis
    xMinIdx = find(x - x(1) >= xROI(1)); xMinIdx = xMinIdx(1);
    xMaxIdx = find(x - x(1) <= xROI(2)); xMaxIdx = xMaxIdx(end);
    ex = x(xMinIdx:xMaxIdx);
    
    % set the k axis
    k = [0:length(ex)-1] / length(ex) / (ex(2) - ex(1));
    kMinIdx = find(k >= kROI(1)); kMinIdx = kMinIdx(1);
    kMaxIdx = find(k <= kROI(2)); kMaxIdx = kMaxIdx(end);
    ek = k(kMinIdx:kMaxIdx);
    
    if (strcmp(information, 'wigner'))
        data1D = data(xMinIdx:xMaxIdx,round(N2*yFrac),round(N3*zFrac));
        wigner = tfrwv(data1D);
        wigner = wigner(kMinIdx:kMaxIdx,:);
        imagesc(ex, ek, wigner);
        Nfilter = length(ex)
        Nperiod = 2*pi/(posMax(1) - posMin(1)) * length(x) * posMin(1) / time
        break;
        
    else
        if (i == initEFile)
            % read the initial file just to get the initial frequency
            data1D = data(:,round(N2*yFrac),[round(N3*zFrac):round(N3*zFrac)+1]);
            data1D = permute(data1D, [1,3,2]);
            [ex, ez, wMap, s2Map] = getWS2Map(x, [z(1) z(2)], data1D', wlimit, xROI, kROI);
            w0 = wMap(1,round(size(wMap,2)/2));
            
        elseif (i == finalEFile)
            if (strcmp(information, 'intensity_freq'))
                % read the intensity and frequency change map on the x2 plane
                display = 1;
                % data2D = double(data(:,round(N2*yFrac),:));
                data3D = permute(data, [2,1,3]);
                [ex, ey, ez, edata3D] = propagate3d(x, y, z, data3D, propagation); edata3D = permute(edata3D, [2,1,3]);
                edata2D = edata3D(:,round(N2*yFrac),:);
                edata2D = permute(edata2D, [1,3,2]);
                [ex, ez, wMap, s2Map] = getWS2Map(ex, ez, edata2D', wlimit, xROI, kROI, display);
                dww0Map = (wMap - w0) / w0 .* (wMap ~= 0);
                imagesc(ex, ez, dww0Map, [-0.03 0.03]);
                % imagesc(ex, ez, dww0Map);
                colorbar;
                figure;
                imagesc(ex, ez, s2Map);
                
            elseif (strcmp(information, 'density'))
                % read the intensity and frequency change map on the x2 plane
                display = 1;
                data2D = double(data(:,round(N2*yFrac),:));
                data2D = permute(data2D, [1,3,2]);
                [ex, ez, edata2D] = propagate(x, z, data2D', propagation, dispW); edata2D = edata2D';
                [ex, ez, wMap, s2Map] = getWS2Map(x, z, edata2D', wlimit, xROI, kROI, display);
                
                % get the half of dww0Map
                dww0Map = (wMap - w0) / w0 .* (wMap ~= 0);
                dww0MapHalf = dww0Map(round(0.5*N3):end,:);
                
                % obtain the dnn0/dz map from the inverse abel transform
                [x2, z2, dnn0dzMap] = mod_abel_transform(x, z(round(0.5*N3):end), dww0MapHalf, a, 1);
                dnn0dzMap = dnn0dzMap * (-2*w0wp^2*sin(theta));
                % imagesc(x2, [-z2(end:-1:1) z2(2:end)], [dnn0dzMap(end:-1:1,:);dnn0dzMap(2:end,:)]);
                
                % integrate horizontally dnn0/dz map to get dnn0 profile
                dnn0MeasMap = dnn0dzMap*0;
                for (i = [1:size(dnn0dzMap,1)])
                    dnn0dz = dnn0dzMap(i,:);
                    dnn0Meas = filter(hd1, [dnn0dz, zeros(1, dly1)]);
                    dnn0Meas = dnn0Meas(dly1+1:end);
                    dnn0Meas = filter(hdf, [dnn0Meas, zeros(1, dlyf)]);
                    dnn0Meas = dnn0Meas(dlyf+1:end) / (2*pi/Nperiod);
                    dnn0MeasMap(i,:) = dnn0Meas;
                end
                imagesc(x2, [-z2(end:-1:1) z2(2:end)], [dnn0MeasMap(end:-1:1,:);dnn0MeasMap(2:end,:)], [-0.03 0.02]);
            end
            
        end
    end
    
    % save memory by clearing the huge matrix
    clear data;
end
