N = 100;
theta = linspace(0.00001, 100 * pi/180, N);
x = [2;3;4];
[THETA, X] = meshgrid(theta, x);

Y = (THETA./tan(THETA) + X .* (1-cos(THETA)).^2 ./ sin(THETA).^2 .* THETA);

plot(theta * 180 / pi, Y(1,:), 'k-', 'LineWidth', 3); hold on;
plot(theta * 180 / pi, Y(2,:), 'k--', 'LineWidth', 3);
plot(theta * 180 / pi, Y(3,:), 'k.', 'LineWidth', 3); hold off;

set(gca, 'FontSize', 20);
xlabel('\theta (degrees)');
ylabel('Error contribution'); % from the angle');
legend('\beta = 2', '\beta = 3', '\beta = 4', 'Location', 'northwest');
