%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
scanning = 'angle'; % 'amplitude', 'angle', or 'freq'
fdir = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/scanning-%s/', scanning);
datatype = 'density'; % 'frequency' or 'density'
show = 'error'; % 'value' or 'error'
withMeasurement = 1;
withErrorbar = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% simulation parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
colors = ['k', 'k'; 'k', 'k'; 'k', 'k'];
dotType = '*';
lineTypes = ['- ';'--';': '];
measTypes = ['o';'s';'d'];

mode = 1; % plot mode
if (strcmp(scanning, 'amplitude'))
    %%% amplitude scanning
    if (strcmp(show, 'value')) titleStr = 'Measurement comparison vs driver beam density';
    else titleStr = 'Relative error of the measurement and calculated values'; end;
    
    xlabelStr = 'Driver beam density (2\times10^{19} cm^{-3})';
    simCodes = [19, 33, 37, 38, 39, 40, 41, 42, 43, 48, 49];
    xvalues = [0.30, 0.10, 0.15, 0.20, 0.25, 0.27, 0.22, 0.13, 0.18, 0.33, 0.35];
elseif (strcmp(scanning, 'angle'))
    %%% angle scanning
    if (strcmp(show, 'value')) titleStr = 'Measurement comparison vs angle for various driver beam density';
    else titleStr = 'Relative error of the measurement and calculated values'; end;
    
    xlabelStr = 'Angle (degrees)';
    simCodes = [44, 45, 46, 47, 48; 56, 57, 58, 59, 39; 60, 61, 62, 63, 37];
    xvalues = [25, 15, 10, 5, 20; 25, 15, 10, 5, 20; 25, 15, 10, 5, 20];
    % simCodes = [44, 45, 46, 48; 56, 57, 58, 39; 60, 61, 62, 37];
    % xvalues = [25, 15, 10, 20; 25, 15, 10, 20; 25, 15, 10, 20];
elseif (strcmp(scanning, 'freq'))
    %%% freq scanning
    if (strcmp(show, 'value')) titleStr = 'Measurement comparison vs frequency';
    else titleStr = 'Relative error of the measurement and calculated values'; end;
    
    xlabelStr = '\omega_0/\omega_p';
    simCodes = [48, 50, 51, 52, 53; 45, 64, 65, 66, 67]; %; 46, 68, 69, 70, 71];
    xvalues = [9.8, 15, 20, 25, 30; 9.8, 15, 20, 25, 30]; % 9.8, 15, 20, 25, 30];
    % if (strcmp(show, 'value')) mode = 3; end;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if (strcmp(show, 'value'))
    if (strcmp(datatype, 'frequency')) ylabelStr = '\Delta\omega/\omega_0';
    else ylabelStr = '\Deltan/n_0'; end
elseif (strcmp(show, 'error'))
    ylabelStr = 'Relative error';
end

if (length(simCodes) ~= length(xvalues))
    disp('Warning! simCodes and xvalues variables do not have the same length');
end

if (mode > 1) numPlotsVert = size(simCodes,1);
else numPlotsVert = 1; end
numPlotsHorz = 1;

measuredVals = [];
actualVals = [];
measuredStd = [];
actualStd = [];
for (y = [1:size(simCodes,1)])
    for (i = [1:size(simCodes,2)])
        fnameWakefield = strcat(fdir, int2str(simCodes(y,i)), '-', datatype, '-wakefield-data.mat');
        fnameMeasured  = strcat(fdir, int2str(simCodes(y,i)), '-', datatype,  '-measured-data.mat');
        
        % load the actual values and the measured values and its ordinates
        load(fnameWakefield, 'xpeaks', 'peaks', 'xtroughs', 'troughs');
        if (withMeasurement) load(fnameMeasured, 'peaksMeas', 'troughsMeas', 'xposs'); end
        
        % only keep the values within the range of the measurement
        if (withMeasurement)
            peaksFiltered = peaks((xpeaks <= max(xposs)) & (xpeaks >= min(xposs)));
            troughsFiltered = troughs((xtroughs <= max(xposs)) & (xtroughs >= min(xposs)));
        else
            peaksFiltered = peaks;
            troughsFiltered = troughs;
        end
        
        % get the actual peaks and troughs mean
        peaksMean = mean(peaksFiltered);
        troughsMean = mean(troughsFiltered);
        peaksStd = std(peaksFiltered);
        troughsStd = std(troughsFiltered);
        
        % save the actual average value of peaks and troughs 
        actualVals(y,i) = (peaksMean - troughsMean)/2;
        actualStd(y,i)  = (peaksStd^2 + troughsStd^2)^.5;
        
        if (withMeasurement)
            % getting the mean of measurement values
            peaksMeasMean = mean(peaksMeas);
            troughsMeasMean = mean(troughsMeas);
            peaksMeasStd = std(peaksMeas);
            troughsMeasStd = std(troughsMeas);
            
            % save the measured average value of peaks and troughs 
            measuredVals(y,i) = (peaksMeasMean - troughsMeasMean)/2;
            measuredStd(y,i) = (peaksMeasStd^2 + troughsMeasStd^2)^.5;
        end
    end
    
    % sort the measured and actual values according to x values
    [xvalues(y,:), xvaluesIdx] = sort(xvalues(y,:));
    actualVals(y,:) = actualVals(y,xvaluesIdx);
    actualStd(y,:) = actualStd(y,xvaluesIdx);
    if (withMeasurement)
        measuredVals(y,:) = measuredVals(y,xvaluesIdx);
        measuredStd(y,:) = measuredStd(y,xvaluesIdx);
    end
    
    if (withMeasurement)
        % compute the errors
        errors = abs(actualVals - measuredVals) ./ actualVals * 100;
    end
    
    % plot the graph
    if (mode > 1)
        subplot(numPlotsVert, numPlotsHorz, y);
        yk = 1;
    else
        yk = y;
    end
    
    if (strcmp(show,'value'))
        if (withErrorbar)
            errorbar(xvalues(y,:), actualVals(y,:), actualStd(y,:), strcat(colors(yk,1),dotType,lineTypes(yk,:)), 'LineWidth', 2);
            hold on;
            if (withMeasurement)
                errorbar(xvalues(y,:), measuredVals(y,:), measuredStd(y,:), strcat(colors(yk,2), measTypes(yk,:)), 'LineWidth', 2);
            end
        else
            plot(xvalues(y,:), actualVals(y,:), strcat(colors(yk,1),dotType,lineTypes(yk,:)), 'LineWidth', 2);
            hold on;
            if (withMeasurement)
                plot(xvalues(y,:), measuredVals(y,:), strcat(colors(yk,2), measTypes(yk,:)), 'LineWidth', 2);
            end
        end
    elseif (withMeasurement) % show the error
        plot(xvalues(y,:), errors(y,:), strcat(colors(yk,1), dotType,lineTypes(yk,:)), 'LineWidth', 2);
        ylim([0 50]);
        hold on;
    end
    
    if ((mode > 1))
        % set the y label
        set(gca, 'FontSize', 12);
        if (y == floor(size(simCodes,1)/2)+1) ylabel(ylabelStr); end
    end
    
    % set the x label special for freq scanning
    if (strcmp(scanning, 'freq'))
        xlim([9 31]);
        if (strcmp(show, 'value')) ylim([0.45 0.7]); end
    end
end
hold off;

if (mode == 1)
    if (strcmp(show, 'value'))
        if (strcmp(scanning, 'amplitude'))
            ax = legend('Actual values', 'Measured values', 'Location', 'northwest');
        elseif (strcmp(scanning, 'angle'))
            ax = legend('Actual values for n_e = 0.33 n_0', 'The measured values', ...
                   'Actual values for n_e = 0.25 n_0', 'The measured values', ...
                   'Actual values for n_e = 0.15 n_0', 'The measured values');
        elseif (strcmp(scanning, 'freq'))
            ax = legend('Actual values for \theta = 20^o', 'The measured values', ...
                   'Actual values for \theta = 15^o', 'The measured values', ...
                   'Actual values for \theta = 10^o', 'The measured values');
        end
    else
        if (strcmp(scanning, 'freq'))
            ax = legend('Error for \theta = 20^o', 'Error for \theta = 15^o'); %, 'Error for \theta = 10^o');
        elseif (strcmp(scanning, 'angle'))
            ax = legend('Error for n_e = 0.33 n_0', 'Error for n_e = 0.25 n_0', 'Error for n_e = 0.15 n_0');
        end
    end
end

% set the y label
set(gca, 'FontSize', 12);
xlabel(xlabelStr);
if (mode == 1) ylabel(ylabelStr); end

% set the legend for frequency graph
if ((strcmp(show, 'value')) & (strcmp(scanning, 'freq')) & (mode > 1))
    actualValueStr = ['Actual values for \theta = 20^o'; 'Actual values for \theta = 15^o'; 'Actual values for \theta = 10^o'];
    for (i = [1:numPlotsVert])
        subplot(numPlotsVert, numPlotsHorz, i);
        ax = legend(actualValueStr(i,:), 'The measured values');
        % if (i == numPlotsVert) ax = legend(actualValueStr(i,:), 'The measured values'); end;
        leg = findobj(ax, 'type', 'text');
        set(ax, 'Location', 'northeast');
        % set(ax, 'Position', [.76 .35+.45*(i-1) .01 .1]);
        % set(leg, 'FontSize', 9);
    end
end

if (withMeasurement)
    (actualVals - measuredVals) ./ actualVals * 100
    maxError = max(max(abs(actualVals - measuredVals) ./ actualVals * 100))
end
