addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\oblique-angle\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\abel_transform\');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% basic parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
amplitude = 'small';
if (strcmp(amplitude ,'large'))
    thetad = 20;
    amp = 33;
    Nx1 = 13000;
    projectName = '51-taking-data-freq-020';
elseif (strcmp(amplitude, 'small'))
    thetad = 20;
    amp = 15;
    Nx1 = 9750;
    projectName = 'a31-freq-020-theta-020-amp-015';
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
projectNameSplit = strsplit(projectName, '-');
% fdir = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/img-slice-z-rotated-7/', projectName);
% fformat = 'dww0-%06d.h5';
% datasetname = '/dww0';
fdir = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/h5-ne-slice-z/', projectName);
fformat = 'charge-slice-electrons-x3-01-%06d.h5';
datasetname = '/charge x3 slice';
fdirOut = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/', projectName); % 19-poc-20deg-3d-wider2-quad or 33-poc-20deg-3d-small-wakefield
fcode = cell2mat(projectNameSplit(1));
initFile = 0;
dataType = 'density'; % 'frequency' or 'density'
plotWithDelta = 0;

df = 1; % spacing between file numberings
if      (thetad == 25) finalFile = 20;
elseif  (thetad == 20) finalFile = 20;
elseif  (thetad == 15) finalFile = 24;
elseif  (thetad == 10) finalFile = 37;
elseif  (thetad ==  5) finalFile = 70; df = 2;
end;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% geometry parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if (strcmp(dataType, 'frequency')) multiplier = 0; else multiplier = 1; end;
theta = -thetad*pi/180*multiplier;
y0 = (10 - 55*tan(theta))*multiplier; % the beam starts from (x0,y0) = (10,55)
xmin = 70; % not reading the data if x <= xmin
if (amp == 40)
    minAmplitudePos = 0;
    maxAmplitudePos = 40;
    minAmplitudeNeg = 0;
    maxAmplitudeNeg = 118;
elseif (amp == 37)
    minAmplitudePos = 0.5;
    maxAmplitudePos = 18;
    minAmplitudeNeg = 0.3;
    maxAmplitudeNeg = 0.8;
elseif (amp == 36)
    minAmplitudePos = 0.6;
    maxAmplitudePos = 18;
    minAmplitudeNeg = 0.2;
    maxAmplitudeNeg = 1.8;
elseif (amp == 33)
    minAmplitudePos = 0.65;
    maxAmplitudePos = 1.85;
    minAmplitudeNeg = 0.34;
    maxAmplitudeNeg = 0.40;
elseif (amp == 25)
    minAmplitudePos = 0.23;
    maxAmplitudePos = 1.85;
    minAmplitudeNeg = 0.0;
    maxAmplitudeNeg = 0.22;
elseif (amp == 15)
    minAmplitudePos = 0.04;
    maxAmplitudePos = 1.85;
    minAmplitudeNeg = 0.0;
    maxAmplitudeNeg = 0.1;
else
    minAmplitudePos = 0;
    maxAmplitudePos = 9999999;
    minAmplitudeNeg = minAmplitudePos;
    maxAmplitudeNeg = maxAmplitudePos;
end

% parameters for cropping the wave data (expressed in fraction)
xminPart = 0.30;
xmaxPart = 0.60;

npoly = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% filter construction %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
filter_refresh = 1;
if (filter_refresh || ~exist('FIR_Hann','var') || isempty(FIR_Hann))
    Fc = 5.5;
    Fs = 100; % got from kmax parameter after the first run
    N = 100;
    LP = fdesign.lowpass('N,Fc',N,Fc,Fs);
    FIR_Hann = design(LP, 'window', 'window', @hann); %, 'SystemObject', true);
    delayLPF = mean(grpdelay(FIR_Hann));
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

xpeaks = [];
peaks = [];
xtroughs = [];
troughs = [];
for (i = [initFile:df:finalFile])
    % construct the full address of the file
    fname = sprintf(fformat, i);
    filename = strcat(fdir, fname);
    
    % read the attributes
    time = h5readatt(filename, '/', 'TIME');
    posMin = h5readatt(filename, '/', 'XMIN');
    posMax = h5readatt(filename, '/', 'XMAX');
    
    % get the data
    data = h5read(filename, datasetname);
    [N1 N2] = size(data);
    
    % set the x, y, z axis
    x = linspace(posMin(1), posMax(1), N1);
    y = linspace(posMin(2), posMax(2), N2);
    
    % extract the data from the line
    [xli, yli] = getLine(x, y, y0, theta);
    xs = [];
    waves = [];
    for (k = [1:length(xli)])
        xl = x(xli(k));
        yl = y(yli(k));
        if (xl <= xmin) continue; end;
        waves(end+1) = data(xli(k),yli(k));
        xs(end+1) = xl;
    end
    if (strcmp(dataType, 'density'))
        waves = -(waves + 1);
    end
    
    % apply the low pass filter to the data
    wavesFiltered = filter(FIR_Hann, [waves, zeros(1, delayLPF)]);
    wavesFiltered = wavesFiltered(delayLPF+1:end);
    
    % crop the data from xminIdx to xmaxIdx
    xminIdx = round(xminPart * length(wavesFiltered)); if (xminIdx <= 0) xminIdx = 1; end;
    xmaxIdx = round(xmaxPart * length(wavesFiltered)); if (xmaxIdx > length(wavesFiltered)) xmaxIdx = length(wavesFiltered); end;
    wavesFiltered = wavesFiltered(xminIdx:xmaxIdx);
    waves = waves(xminIdx:xmaxIdx);
    xs = xs(xminIdx:xmaxIdx);
    
    % pick the peaks and the troughs
    peaksTemp = [];
    troughsTemp = [];
    xpeaksTemp = [];
    xtroughsTemp = [];
    dwaves = diff(wavesFiltered);
    lastFound = 0;
    for (j = [2:length(dwaves)])
        if (dwaves(j) * dwaves(j-1) < 0) % the differential crosses 0. NOTE THAT I DIDN'T CONSIDER IF THE COMPARED DWAVES ELEMENTS ARE 0 !!!
        
            % if found a peak
            if (dwaves(j) < 0)
                % if the peak is below 0, then it must be a noise
                if (wavesFiltered(j) <= minAmplitudePos) continue; end;
                if (wavesFiltered(j) >= maxAmplitudePos) continue; end;
                
                % if the previous one finds a trough, then now finds a peak, then save the minimum trough found previously
                if ((lastFound == -1) && (length(troughsTemp) ~= 0))
                    [minTrough, minTroughIdx] = min(troughsTemp);
                    xtroughs(end+1) = xtroughsTemp(minTroughIdx);
                    troughs(end+1) = minTrough;
                    
                    % empty the troughs temporary array
                    troughsTemp = [];
                    xtroughsTemp = [];
                end
                
                % save the peaks in a temporary array
                xpeaksTemp(end+1) = xs(j);
                peaksTemp(end+1) = wavesFiltered(j);
                
                lastFound = 1;
                
            % if found a trough
            elseif (dwaves(j) > 0)
                % if the trough is above 0, then it must be a noise
                if (wavesFiltered(j) >= -minAmplitudeNeg) continue; end;
                if (wavesFiltered(j) <= -maxAmplitudeNeg) continue; end;
                
                % if the previous one finds a peak, then now finds a trough, then save the maximum peak found previously
                if ((lastFound == 1) && (length(peaksTemp) ~= 0))
                    [maxPeak, maxPeakIdx] = max(peaksTemp);
                    xpeaks(end+1) = xpeaksTemp(maxPeakIdx);
                    peaks(end+1) = maxPeak;
                    
                    % empty the peaks temporary array
                    peaksTemp = [];
                    xpeaksTemp = [];
                end
                
                % save the troughs in a temporary array
                xtroughsTemp(end+1) = xs(j);
                troughsTemp(end+1) = wavesFiltered(j);
                
                lastFound = -1;
            end
        end
    end
    
    if ((lastFound == 1) && (length(peaksTemp) ~= 0))
        [maxPeak, maxPeakIdx] = max(peaksTemp);
        xpeaks(end+1) = xpeaksTemp(maxPeakIdx);
        peaks(end+1) = maxPeak;
    elseif ((lastFound == -1) && (length(troughsTemp) ~= 0))
        [minTrough, minTroughIdx] = min(troughsTemp);
        xtroughs(end+1) = xtroughsTemp(minTroughIdx);
        troughs(end+1) = minTrough;
    end
end

% sort the arrays
[xpeaks, xpeaksIdx] = sort(xpeaks);
peaks = peaks(xpeaksIdx);
[xtroughs, xtroughsIdx] = sort(xtroughs);
troughs = troughs(xtroughsIdx);

% save the data
save(strcat(fdirOut, fcode, '-', dataType, '-wakefield-data.mat'), 'xpeaks', 'peaks', 'xtroughs', 'troughs');

% plot(xs, wavesFiltered)
% getPeriod(wavesFiltered)
hold on;
plot(xpeaks, peaks, 'k.');
plot(xtroughs, troughs, 'k*');
if (initFile == finalFile)
    % plot the original shape
    plot(xs, waves, 'm-');
    plot(xpeaks, peaks, 'b.');
    plot(xtroughs, troughs, 'g.');
    % plot(xs, wavesFiltered, 'y-');
else
    % polynomial fit
    [polyPeaks, Speaks, muPeaks] = polyfit(xpeaks, peaks, npoly);
    [polyTroughs, Stroughs, muTroughs] = polyfit(xtroughs, troughs, npoly);
    
    [ypeaks, dpeaks] = polyval(polyPeaks, xpeaks, Speaks, muPeaks);
    [ytroughs, dtroughs] = polyval(polyTroughs, xtroughs, Stroughs, muTroughs);
    
    if (plotWithDelta == 0)
        dpeaks = 0;
        dtroughs = 0;
    end
    plot(xpeaks, ypeaks-dpeaks, 'k-', 'LineWidth', 2);
    plot(xpeaks, ypeaks+dpeaks, 'k-', 'LineWidth', 2);
    plot(xtroughs, ytroughs-dtroughs, 'k--', 'LineWidth', 2);
    plot(xtroughs, ytroughs+dtroughs, 'k--', 'LineWidth', 2);
    
end
hold off;

set(gca, 'FontSize', 13);
if (strcmp(dataType, 'density'))
    gylabel = '\Deltan/n_0 amplitude';
    gtitle  = '\Deltan/n_0 vs position';
else
    gylabel = '\Delta\omega/\omega_0 amplitude';
    gtitle  = '\Delta\omega/\omega_0 vs position';
end

xlabel('x (norm. units)');
ylabel(gylabel);
% title(gtitle);

% =============================================================================================================================================================================

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
projectNameSplit = strsplit(projectName, '-');
fdirformat = strcat('C:/Users/kasim/Desktop/Simulation/oblique-angle/', projectName, '/freq-slice-%02d/');
fdirOut = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/', projectName);
fcode = cell2mat(projectNameSplit(1));
fformat = 'data-%06d.mat';

if      (thetad == 25) files = [12, 13, 15, 16, 17]; % angle 025
elseif  (thetad == 20) files = [13, 14, 16, 18, 19]; % angle 020
elseif  (thetad == 15) files = [15, 18, 20, 22, 24]; % angle 015
elseif  (thetad == 10) files = [21, 24, 27, 30, 33]; % angle 010
elseif  (thetad ==  5) files = [32, 38, 44, 50, 55]; % angle 005
end;

% files = [21, 24, 27, 31, 33]+0;
% files = [13, 14, 16, 18, 19]+0;
% files = [13, 14];%, 16, 18, 19];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% simulation parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
yposs = [0, -3, -6, -9, -11];
% yposs = [0, -3];%, -6, -9, -11];
toRead = 'density'; % 'frequency' or 'density';
theta = -thetad*pi/180;
y0 = 10 - 55*tan(theta);

if (Nx1 == 13000)
    xminIdx = 4000; % f = 20
    xmaxIdx = 6500;
elseif (Nx1 == 9750)
    xminIdx = 3000; % f = 15
    xmaxIdx = 5500;
else
    xminIdx = 2400; % f = 10
    xmaxIdx = 3800;
end
    
centredGraph = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

xposs = (yposs - y0) / tan(theta);
peaksMeas = files*0;
troughsMeas = files*0;
for (i = [1:length(files)])
% for (i = 5)
    % i = 3;
    % construct the full address of the file
    ifile = files(i);
    fdir = sprintf(fdirformat, i);
    fname = sprintf(fformat, ifile);
    filename = strcat(fdir, fname);
    
    load(filename, 'x2', 'z2', 'dnn0MeasMap', 'dww0Map');
    
    if (strcmp(toRead, 'density'))
        if (xmaxIdx < 1) xmaxIdx = size(dnn0MeasMap, 2); end;
        data = -dnn0MeasMap(:,xminIdx:xmaxIdx);
        % data = -dnn0MeasMap(1,xminIdx:xmaxIdx);
    else
        if (xmaxIdx < 1) xmaxIdx = size(dww0Map, 2); end;
        data = dww0Map(round(size(dww0Map,1)/2),xminIdx:xmaxIdx);
    end;
    
    peaksMeas(i) = max(max(data));
    troughsMeas(i) = min(min(data));
end

if (centredGraph)
    centre = (mean(peaksMeas) + mean(troughsMeas)) / 2;
else
    centre = 0;
end

% plot the measured data
hold on;
plot(xposs, (peaksMeas-centre), 'ks', 'LineWidth', 2);
plot(xposs, (troughsMeas-centre), 'ko', 'LineWidth', 2);
hold off;

% save the data
save(strcat(fdirOut, fcode, '-', dataType, '-measured-data.mat'), 'xposs', 'peaksMeas', 'troughsMeas');
h = gcf; saveas(h, strcat(fdirOut, fcode, '-density-comparison.png'), 'png');

disp(1 - (mean(peaksMeas) - mean(troughsMeas)) / (mean(ypeaks) - mean(ytroughs)));

% troughsMeas(1)
% peaksMeas(1)
