addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\basic\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\oblique-angle\');
addpath('\\ppfs6.physics.ox.ac.uk\Particle\kasim\Projects\scripts\abel_transform\');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
amplitude = 'small'; % 'large' or 'small'
if (strcmp(amplitude, 'large')) sdir = '48-taking-data-1ppc-033'; fcode = '48';
else sdir = '33-poc-20deg-3d-small-wakefield'; fcode = '33'; end

fdir = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/img-slice-z-rotated-7/', sdir);;
fformat = 'dww0-%06d.h5';
datasetname = '/dww0';
% fdir = 'C:\Users\kasim\Desktop\Simulation\oblique-angle\48-taking-data-1ppc-033\h5-ne-slice-z\';
% fformat = 'charge-slice-electrons-x3-01-%06d.h5';
% datasetname = '/charge x3 slice';
fdirOut = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/', sdir);
% fcode = '48'; % '33' or '48'
initFile = 0;
finalFile = 20;
dataType = 'frequency'; % 'frequency' or 'density'
plotWithDelta = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% geometry parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
theta = -20*pi/180*0;
y0 = (10 - 55*tan(theta))*0; % the beam starts from (x0,y0) = (10,55)
xmin = 70; % not reading the data if x <= xmin

if (strcmp(amplitude, 'large'))
    minAmplitude = 1e-2*0;
    maxAmplitude = 1e-1*1;
else
    minAmplitude = 2.5e-1*0;
    maxAmplitude = 2e-3*1;
end

% parameters for cropping the wave data (expressed in fraction)
xminPart = 0.30;
xmaxPart = 0.60;

npoly = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% filter construction %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
filter_refresh = 1;
if (filter_refresh || ~exist('FIR_Hann','var') || isempty(FIR_Hann))
    Fc = 5.5;
    Fs = 100; % got from kmax parameter after the first run
    N = 100;
    LP = fdesign.lowpass('N,Fc',N,Fc,Fs);
    FIR_Hann = design(LP, 'window', 'window', @hann); %, 'SystemObject', true);
    delayLPF = mean(grpdelay(FIR_Hann));
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

xpeaks = [];
peaks = [];
xtroughs = [];
troughs = [];
for (i = [initFile:1:finalFile])
    % construct the full address of the file
    fname = sprintf(fformat, i);
    filename = strcat(fdir, fname);
    
    % read the attributes
    time = h5readatt(filename, '/', 'TIME');
    posMin = h5readatt(filename, '/', 'XMIN');
    posMax = h5readatt(filename, '/', 'XMAX');
    
    % get the data
    data = h5read(filename, datasetname);
    [N1 N2] = size(data);
    
    % set the x, y, z axis
    x = linspace(posMin(1), posMax(1), N1);
    y = linspace(posMin(2), posMax(2), N2);
    
    % extract the data from the line
    [xli, yli] = getLine(x, y, y0, theta);
    xs = [];
    waves = [];
    for (k = [1:length(xli)])
        xl = x(xli(k));
        yl = y(yli(k));
        if (xl <= xmin) continue; end;
        waves(end+1) = data(xli(k),yli(k));
        xs(end+1) = xl;
    end
    if (strcmp(dataType, 'density'))
        waves = -(waves + 1);
    end
    
    % apply the low pass filter to the data
    wavesFiltered = filter(FIR_Hann, [waves, zeros(1, delayLPF)]);
    wavesFiltered = wavesFiltered(delayLPF+1:end);
    
    % crop the data from xminIdx to xmaxIdx
    xminIdx = round(xminPart * length(wavesFiltered)); if (xminIdx <= 0) xminIdx = 1; end;
    xmaxIdx = round(xmaxPart * length(wavesFiltered)); if (xmaxIdx > length(wavesFiltered)) xmaxIdx = length(wavesFiltered); end;
    wavesFiltered = wavesFiltered(xminIdx:xmaxIdx);
    waves = waves(xminIdx:xmaxIdx);
    xs = xs(xminIdx:xmaxIdx);
    
    % pick the peaks and the troughs
    peaksTemp = [];
    troughsTemp = [];
    xpeaksTemp = [];
    xtroughsTemp = [];
    dwaves = diff(wavesFiltered);
    lastFound = 0;
    for (j = [2:length(dwaves)])
        if (dwaves(j) * dwaves(j-1) < 0) % the differential crosses 0. NOTE THAT I DIDN'T CONSIDER IF THE COMPARED DWAVES ELEMENTS ARE 0 !!!
        
            % if found a peak
            if (dwaves(j) < 0)
                % if the peak is below 0, then it must be a noise
                if (wavesFiltered(j) <= minAmplitude) continue; end;
                if (wavesFiltered(j) >= maxAmplitude) continue; end;
                
                % if the previous one finds a trough, then now finds a peak, then save the minimum trough found previously
                if ((lastFound == -1) && (length(troughsTemp) ~= 0))
                    [minTrough, minTroughIdx] = min(troughsTemp);
                    xtroughs(end+1) = xtroughsTemp(minTroughIdx);
                    troughs(end+1) = minTrough;
                    
                    % empty the troughs temporary array
                    troughsTemp = [];
                    xtroughsTemp = [];
                end
                
                % save the peaks in a temporary array
                xpeaksTemp(end+1) = xs(j);
                peaksTemp(end+1) = wavesFiltered(j);
                
                lastFound = 1;
                
            % if found a trough
            elseif (dwaves(j) > 0)
                % if the trough is above 0, then it must be a noise
                if (wavesFiltered(j) >= -minAmplitude) continue; end;
                if (wavesFiltered(j) <= -maxAmplitude) continue; end;
                
                % if the previous one finds a peak, then now finds a trough, then save the maximum peak found previously
                if ((lastFound == 1) && (length(peaksTemp) ~= 0))
                    [maxPeak, maxPeakIdx] = max(peaksTemp);
                    xpeaks(end+1) = xpeaksTemp(maxPeakIdx);
                    peaks(end+1) = maxPeak;
                    
                    % empty the peaks temporary array
                    peaksTemp = [];
                    xpeaksTemp = [];
                end
                
                % save the troughs in a temporary array
                xtroughsTemp(end+1) = xs(j);
                troughsTemp(end+1) = wavesFiltered(j);
                
                lastFound = -1;
            end
        end
    end
    
    if ((lastFound == 1) && (length(peaksTemp) ~= 0))
        [maxPeak, maxPeakIdx] = max(peaksTemp);
        xpeaks(end+1) = xpeaksTemp(maxPeakIdx);
        peaks(end+1) = maxPeak;
    elseif ((lastFound == -1) && (length(troughsTemp) ~= 0))
        [minTrough, minTroughIdx] = min(troughsTemp);
        xtroughs(end+1) = xtroughsTemp(minTroughIdx);
        troughs(end+1) = minTrough;
    end
end

% sort the arrays
[xpeaks, xpeaksIdx] = sort(xpeaks);
peaks = peaks(xpeaksIdx);
[xtroughs, xtroughsIdx] = sort(xtroughs);
troughs = troughs(xtroughsIdx);

% save the data
save(strcat(fdirOut, fcode, '-', dataType, '-wakefield-data.mat'), 'xpeaks', 'peaks', 'xtroughs', 'troughs');

% plot(xs, wavesFiltered)
% getPeriod(wavesFiltered)
hold on;
plot(xpeaks, peaks, 'k.');
plot(xtroughs, troughs, 'k*');
if (initFile == finalFile)
    % plot the original shape
    plot(xs, waves, 'm-');
    plot(xpeaks, peaks, 'k.');
    plot(xtroughs, troughs, 'k*');
    % plot(xs, wavesFiltered, 'y-');
else
    % polynomial fit
    [polyPeaks, Speaks, muPeaks] = polyfit(xpeaks, peaks, npoly);
    [polyTroughs, Stroughs, muTroughs] = polyfit(xtroughs, troughs, npoly);
    
    [ypeaks, dpeaks] = polyval(polyPeaks, xpeaks, Speaks, muPeaks);
    [ytroughs, dtroughs] = polyval(polyTroughs, xtroughs, Stroughs, muTroughs);
    
    if (plotWithDelta == 0)
        dpeaks = 0;
        dtroughs = 0;
    end
    plot(xpeaks, ypeaks-dpeaks, 'k-', 'LineWidth', 2);
    plot(xpeaks, ypeaks+dpeaks, 'k-', 'LineWidth', 2);
    plot(xtroughs, ytroughs-dtroughs, 'k--', 'LineWidth', 2);
    plot(xtroughs, ytroughs+dtroughs, 'k--', 'LineWidth', 2);
    
end
hold off;

set(gca, 'FontSize', 13);
if (strcmp(dataType, 'density'))
    gylabel = '\Deltan/n_0 amplitude';
    gtitle  = '\Deltan/n_0 vs position';
else
    gylabel = '\Delta\omega/\omega_0 amplitude';
    gtitle  = '\Delta\omega/\omega_0 vs position';
end

xlabel('x (norm. units)');
ylabel(gylabel);
title(gtitle);
