%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% RUN THE WAKEFIELD_EVOLUTION.M FILE FIRST!!! %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% file parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
amplitude = 'small'; % 'large' or 'small'
if (strcmp(amplitude, 'large')) sdir = '48-taking-data-1ppc-033'; fcode = '48';
else sdir = '33-poc-20deg-3d-small-wakefield'; fcode = '33'; end

fdirformat = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/%s/', sdir, 'freq-slice-%02d');
fdirOut = sprintf('C:/Users/kasim/Desktop/Simulation/oblique-angle/%s/', sdir);
% fcode = '48'; % '33' or '48'
fformat = 'data-%06d.mat';
% files = [12, 13, 15, 16, 17]; % angle 025
files = [13, 14, 16, 18, 19]+0; % angle 020
% files = [15, 18, 20, 22, 24]; % angle 015
% files = [21, 24, 27, 30, 33]; % angle 010
% files = [32, 38, 44, 50, 55]; % angle 005

% files = [21, 24, 27, 31, 33]+0;
% files = [13, 14, 16, 18, 19]+0;
% files = [13, 14];%, 16, 18, 19];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% simulation parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
yposs = [0, -3, -6, -9, -11];
% yposs = [0, -3];%, -6, -9, -11];
toRead = 'frequency'; % 'frequency' or 'density';
theta = -20*pi/180;
y0 = 10 - 55*tan(theta);
% xminIdx = 4000; % f = 20
% xmaxIdx = 7500;
% xminIdx = 3000; % f = 15
% xmaxIdx = 5500;
xminIdx = 2000; % f = 10
xmaxIdx = 3800;

centredGraph = 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

xposs = (yposs - y0) / tan(theta);
peaksMeas = files*0;
troughsMeas = files*0;
for (i = [1:length(files)])
% for (i = 5)
    i
    % construct the full address of the file
    ifile = files(i);
    fdir = sprintf(fdirformat, i);
    fname = sprintf(fformat, ifile);
    filename = strcat(fdir, fname);
    
    load(filename, 'x2', 'z2', 'dnn0MeasMap', 'dww0Map');
    
    if (strcmp(toRead, 'density'))
        if (xmaxIdx < 1) xmaxIdx = size(dnn0MeasMap, 2); end;
        data = -dnn0MeasMap(:,xminIdx:xmaxIdx);
        % data = -dnn0MeasMap(2,xminIdx:xmaxIdx);
    else
        if (xmaxIdx < 1) xmaxIdx = size(dww0Map, 2); end;
        data = dww0Map(round(size(dww0Map,1)/2),xminIdx:xmaxIdx);
    end;
    
    peaksMeas(i) = max(max(data));
    troughsMeas(i) = min(min(data));
end

if (centredGraph)
    centre = (mean(peaksMeas) + mean(troughsMeas)) / 2;
else
    centre = 0;
end

hold on;
plot(xposs, (peaksMeas-centre), 'ks', 'LineWidth', 2);
plot(xposs, (troughsMeas-centre), 'ko', 'LineWidth', 2);
hold off;

% save the data
save(strcat(fdirOut, fcode, '-', dataType, '-measured-data.mat'), 'xposs', 'peaksMeas', 'troughsMeas');

% troughsMeas(1)
% peaksMeas(1)
