%% fig 1a
plot_color_fig('fig_1a.dat',1) %Plots smoothed intensities
%plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
%plot_color_fig('fig_1a.dat',1,-1) %Plots errors

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10 600])
c=colorbar;
c.Ticks=(0:100:500);

xticks([0 1.2468 2.6864 3.5176 4.3487 5.0635])
xticklabels({'(1/2,1,3/2)','(1,0,3/2)','(1,1,3/2)','(2/3,2/3,3/2)','(0,1,3/2)','(1/2,1,3/2)'})

xx=xticks;for x=xx(2:end-1), xline(x,'m--');end
set(gca,'Linewidth',1.5,'TickDir','out');

data=importdata('fig_1a.xy');
hold on;
plot(2.6713,0,'.','MarkerSize',32,'Color',[0.64 0.08 0.18])
plot(data(:,1),data(:,5),'m-','LineWidth',2);
plot(data(:,1),data(:,6),'m--','LineWidth',2);
plot(data(:,1),data(:,7),'y-','LineWidth',2);
plot(data(:,1),data(:,8),'y--','LineWidth',2);

axis([0 5.0686 0 12.5])
ylabel('Energy (meV)')
title('Figure 1a');
drawnow;

%% fig 1b
plot_color_fig('fig_1b.dat',0)

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([-10 600])
c=colorbar;
c.Ticks=(0:100:500);

xticks([0 1.2468 2.6864 3.5176 4.3487 5.0635])
xticklabels({'(1/2,1,3/2)','(1,0,3/2)','(1,1,3/2)','(2/3,2/3,3/2)','(0,1,3/2)','(1/2,1,3/2)'})

xx=xticks;for x=xx(2:end-1), xline(x,'m--');end
set(gca,'Linewidth',1.5,'TickDir','out');

data=importdata('fig_1b.xy');
hold on;
plot(data(:,1),data(:,5),'m-','LineWidth',2);
plot(data(:,1),data(:,6),'m--','LineWidth',2);
plot(data(:,1),data(:,7),'y-','LineWidth',2);
plot(data(:,1),data(:,8),'y--','LineWidth',2);

axis([0 5.0686 0 12.5])
ylabel('Energy (meV)')
title('Figure 1b');
drawnow;

%% fig 1c
plot_color_fig('fig_1c.dat',1)

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([0 500])
c=colorbar;
c.Ticks=(100:100:500);

xticks([0 1.5])
xticklabels({'(1,1,0)','(1,1,3/2)'})
set(gca,'Linewidth',1.5,'TickDir','out');

hold on
plot(0,0,'.','MarkerSize',32,'Color',[0 1 0])
plot(1.5,0,'.','MarkerSize',32,'Color',[0.64 0.08 0.18])

data=importdata('fig_1c.xy');
plot(data(:,1),data(:,5),'m-','LineWidth',3);
plot(data(:,1),data(:,6),'m--','LineWidth',3);

axis([0 2 0 6.25])
ylabel('Energy (meV)')
title('Figure 1c');
drawnow;

%% fig 1d
plot_color_fig('fig_1d.dat',0)

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([0 500])
c=colorbar;
c.Ticks=(100:100:500);

xticks([0 0.6942])
xticklabels({'(1,1,0)','(1,1,3/2)'})
set(gca,'Linewidth',1.5,'TickDir','out');

data=importdata('fig_1d.xy');
hold on
plot(data(:,1),data(:,5),'m-','LineWidth',3);
plot(data(:,1),data(:,6),'m--','LineWidth',3);
hold off

axis([0 0.92562 0 6.25])
ylabel('Energy (meV)')
title('Figure 1d');
drawnow;

%% fig 2c
data=importdata('fig_2c.xye');
fits=importdata('fig_2c.xy');
figure;
plot(data(:,1),data(:,2),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','MarkerSize',7);
hold on;
plot(data(:,1),data(:,4),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','MarkerSize',6);
plot(fits(:,1),fits(:,2),'k-','LineWidth',2);
plot(fits(:,1),fits(:,3),'k-','LineWidth',2);

xline(-75.5,'k--');xline(104.5,'k--');

errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',7);
errorbar(data(:,1),data(:,4),data(:,5),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',6);

l=legend;
l.Location='northwest';
l.String={'[8.5, 10.5] meV top band' '[6.5,   8.5] meV top band'};
l.EdgeColor=[1 1 1];

axis([-180 180 49 438])
xlabel('\alpha (deg)')
ylabel('Intensity (arb. units)')
xticks(-180:90:180)
yticks(100:100:400)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 2c');
drawnow;

%% fig 2d
plot_color_fig('fig_2d.dat',1)

axis([-1.95 -0.05 0.75 2.25]);
load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10   550]);
c=colorbar;
c.Ticks=(100:200:500);

a=gca;
a.DataAspectRatio=[1.44 1.25 1];
a.DataAspectRatioMode='manual';

hold on;
BZ=importdata('BZ.xy');
plot(BZ(:,1),BZ(:,2),'LineStyle','--','LineWidth',3,'Color',[0.7 0.7 0.7])
xlabel('$(0.5\zeta,-\zeta)$ in $1.25$\AA$^{-1}$','interpreter','latex');
ylabel('$(\xi,0)$ in $1.44$\AA$^{-1}$','interpreter','latex');
xticks(-1.5:0.5:-0.5)
yticks(1:0.5:2)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 2d');
drawnow;

%% fig 2e
plot_color_fig('fig_2e.dat',1)

axis([-1.95 -0.05 0.75 2.25]);
load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10   550]);
c=colorbar;
c.Ticks=(100:200:500);

a=gca;
a.DataAspectRatio=[1.44 1.25 1];
a.DataAspectRatioMode='manual';

hold on;
BZ=importdata('BZ.xy');
plot(BZ(:,1),BZ(:,2),'LineStyle','--','LineWidth',2,'Color',[0.7 0.7 0.7])
drawellipse('Center',[-2/3,1],'SemiAxes',[0.04, 0.04*1.25/1.44],'Color','m','LineWidth',3.5,'FaceAlpha',0,'InteractionsAllowed','none');
drawellipse('Center',[-2/3,1],'SemiAxes',[0.16, 0.16*1.25/1.44],'Color','m','LineWidth',3.5,'FaceAlpha',0,'InteractionsAllowed','none');
xlabel('$(0.5\zeta,-\zeta)$ in $1.25$\AA$^{-1}$','interpreter','latex');
ylabel('$(\xi,0)$ in $1.44$\AA$^{-1}$','interpreter','latex');
xticks(-1.5:0.5:-0.5)
yticks(1:0.5:2)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 2e');
drawnow;

%% fig 2f
plot_color_fig('fig_2f.dat',1)

axis([-0.66 0.66 5 11.5]);
load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10   550]);
c=colorbar;
c.Ticks=(100:200:500);

hold on;
xlabel('$(2/3 + \zeta,2/3 - \zeta)$ in $1.44$\AA$^{-1}$','interpreter','latex');
ylabel('Energy (meV)','interpreter','latex');
xticks(-0.5:0.5:0.5)
yticks(6:2:10)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 2f');
drawnow;

%% fig 2g
plot_color_fig('fig_2g.dat',1)

axis([-0.7 0.7 5 11.5]);
load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10   550]);
c=colorbar;
c.Ticks=(100:200:500);

hold on;
xlabel('$(1 - \zeta,1 - \zeta)$ in $2.49$\AA$^{-1}$','interpreter','latex');
ylabel('Energy (meV)','interpreter','latex');
xticks(-0.5:0.5:0.5)
yticks(6:2:10)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 2g');
drawnow;

%% fig 3c
plot_color_fig('fig_3c.dat',1)

axis([-1.85 -0.15 0.85 2.15]);
load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10   400]);
c=colorbar;
c.Ticks=(100:200:500);

a=gca;
a.DataAspectRatio=[1.44 1.25 1];
a.DataAspectRatioMode='manual';

hold on;
BZ=importdata('BZ.xy');
plot(BZ(:,1),BZ(:,2),'LineStyle','--','LineWidth',2,'Color',[0.7 0.7 0.7])
plot(-4/3,1,'.','MarkerSize',32,'Color',[0.3 0.3 0.3])
xlabel('$(0.5\zeta,-\zeta)$ in $1.25$\AA$^{-1}$','interpreter','latex');
ylabel('$(\xi,0)$ in $1.44$\AA$^{-1}$','interpreter','latex');
xticks(-1.5:0.5:-0.5)
yticks(1:0.5:2)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 3c');
drawnow;

%% fig 3d
data=importdata('fig_3d.xye');
fit_XXZ=importdata('fig_3d_XXZ.xy');
fit_eta=importdata('fig_3d_eta.xy');

figure
plot(fit_eta(:,1),fit_eta(:,2),'b-','LineWidth',2);
hold on;
plot(fit_XXZ(:,1),fit_XXZ(:,2),'r--','LineWidth',2);
plot(data(:,1),data(:,2),'Color','k','Marker','o','MarkerFaceColor','k','LineStyle','none','MarkerSize',7)
errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','none','CapSize',0,'LineStyle','none','LineWidth',2)
axis([7 9.9 0 799])
xlabel('E (meV)')
ylabel('Intensity (arb. units)')
xticks(7:0.5:10)
yticks(0:200:800)
l=legend;
l.String={'\color{blue} \eta \neq 0'  '\color{red} \eta = 0'  'data'};
l.FontSize=18;
l.EdgeColor=[1 1 1];
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 3d');
drawnow;

%% fig 4b
figure;
data=importdata('fig_4b.xye');
fit=importdata('fig_4b.xy');
plot(fit(:,1),fit(:,3),'k--','LineWidth',3);
hold on;
plot(fit(:,1),fit(:,2),'k-','LineWidth',3);
errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','none','LineStyle','none','LineWidth',2)
plot(data(:,1),data(:,2),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','MarkerSize',12,'LineWidth',2)
axis([17 71 40 250])
xlabel('Energy (meV)')
ylabel('Intensity (arb. units)')
yticks(50:50:200)
xticks(20:10:70)
xticklabels({'20','','40','','60'})
yticklabels({'','100','','200'})
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 4b');
drawnow;

%% fig 4c
plot_color_fig('fig_4c.dat',1)
fits=importdata('fig_4c.xy');

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([100 450])

c=colorbar;
c.Ticks=(0:100:500);

hold on;
xticks([0 0.4011 1.1047 2.5118 3.9188])
xticklabels({'(5/3,2/3,3/2)','(2,1/2,3/2)','(2,0,3/2)','(1,1,3/2)','(0,2,3/2)'})

xx=xticks;for x=xx(2:end-1), xline(x,'m--');end

hold on;
plot(fits(:,1),fits(:,5),'m-','LineWidth',2);
plot(fits(:,1),fits(:,6),'m--','LineWidth',2);

axis([0 3.9239 22.001 32.999])
ylabel('Energy (meV)')
yticks(24:4:32)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 4c');
drawnow;

%% fig 4d
plot_color_fig('fig_4d.dat',0)
fits=importdata('fig_4d.xy');

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([-15 450])

c=colorbar;
c.Ticks=(0:100:500);

hold on;
xticks([0 0.4011 1.1047 2.5118 3.9188])
xticklabels({'(5/3,2/3,3/2)','(2,1/2,3/2)','(2,0,3/2)','(1,1,3/2)','(0,2,3/2)'})

xx=xticks;for x=xx(2:end-1), xline(x,'m--');end

plot(fits(:,1),fits(:,5),'m-','LineWidth',2);
plot(fits(:,1),fits(:,6),'m--','LineWidth',2);

axis([0 3.9239 22.001 32.999])
ylabel('Energy (meV)')
yticks(24:4:32)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 4d');
drawnow;

%% fig 4e
data=importdata('fig_4e.xye');
fits=importdata('fig_4e.xy');

figure;
s_points=plot(data(:,1),data(:,2),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','MarkerSize',7);
hold on;
c_points=plot(data(:,1),data(:,4),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','MarkerSize',6);
s_fits=plot(fits(:,1),fits(:,2),'k-','LineWidth',2);
c_fits=plot(fits(:,1),fits(:,3),'k-','LineWidth',2);

xline(-24,'k--');xline(156,'k--');

s_error=errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',7);
c_error=errorbar(data(:,1),data(:,4),data(:,5),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',6);

l=legend;
l.Location='northwest';
l.String={'[28, 30] meV top band' '[26, 28] meV bottom band'};
l.EdgeColor=[1 1 1];

axis([-180 180 165 499])
xlabel('\alpha (deg)')
ylabel('Intensity (arb. units)')
xticks(-180:90:180)
yticks(200:100:400)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 4e');
drawnow;

%% fig 4f
plot_color_fig('fig_4f.dat',1)
fits=importdata('fig_4f.xy');

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([100 450])
c=colorbar;
c.Ticks=(100:100:400);

xticks([-1 0])
xticklabels({'(1/3,7/3)','(1/3,4/3)'})

hold on
plot(fits(:,1),fits(:,5),'m-','LineWidth',3);
plot(fits(:,1),fits(:,6),'m--','LineWidth',3);
hold off

axis([-1.11 0.36926 23 33])
ylabel('Energy (meV)')
yticks(24:4:32)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Figure 4f');
drawnow;

%% SM fig 1a
data=importdata('SM_Fig_1a_data.dat');
fit=importdata('SM_Fig_1a_fit.dat');
figure;
plot(data(:,1),data(:,2),'ro','MarkerSize',3,'MarkerFacecolor',[1 0 0]);
hold on;
plot(fit(:,1),fit(:,2),'k-','LineWidth',1);
axis([0.8 10.2 0 28000])

xlabel('d (\AA)','interpreter','latex')
ylabel('Intensity (arb. units)')
xticks(1:0.5:10)
xticklabels({'1','','2','','3','','4','','5','','6','','7','','8','','9','','10'})
yticks(0:2500:27500)
yticklabels({'0','','5000','','10000','','15000','','20000','','25000',''})

set(gca,'Linewidth',1.5,'TickDir','in');
title('Supplementary Figure 1a');
drawnow;

%% SM fig 1a inset
data=importdata('SM_Fig_1a_inset_data.dat');
figure;
plot(data(:,1),data(:,2),'ko','MarkerSize',10,'MarkerFacecolor',[1 1 1],'LineWidth',2);
hold on;
errorbar(data(:,1),data(:,2),data(:,3),'LineStyle','none','Marker','none','Color',[0 0 0],'LineWidth',2);
axis([0 50 0 3.7])

xlabel('Temperature (K)')
ylabel('Co moment ($\mu_B$)','interpreter','latex')
xticks(0:5:50)
xticklabels({'0','','10','','20','','30','','40','','50'})
yticks(0:0.5:3.5)
yticklabels({'0','','1','','2','','3',''})

set(gca,'Linewidth',1.5,'TickDir','in');
title('Supplementary Figure 1a inset');
drawnow;

%% SM fig 1b
data=importdata('SM_Fig_1b_data.dat');
fit=importdata('SM_Fig_1b_fit.dat');
figure;
plot(data(:,1),data(:,2),'ro','MarkerSize',3,'MarkerFacecolor',[1 0 0]);
hold on;
plot(fit(:,1),fit(:,2),'k-','LineWidth',1);
axis([0.8 10.2 0 28000])

xlabel('d (\AA)','interpreter','latex')
ylabel('Intensity (arb. units)')
xticks(1:0.5:10)
xticklabels({'1','','2','','3','','4','','5','','6','','7','','8','','9','','10'})
yticks(0:2500:27500)
yticklabels({'0','','5000','','10000','','15000','','20000','','25000',''})

set(gca,'Linewidth',1.5,'TickDir','in');
title('Supplementary Figure 1b');
drawnow;

%% SM fig 1c
data=importdata('SM_Fig_1a_data.dat');
fit=importdata('SM_Fig_1a_fit.dat');
figure;
plot(data(:,1),data(:,2),'ro','MarkerSize',3,'MarkerFacecolor',[1 0 0]);
hold on;
plot(fit(:,1),fit(:,2),'k-','LineWidth',1);
axis([1.9 5.1 0 2800])

xlabel('d (\AA)','interpreter','latex')
ylabel('Intensity (arb. units)')
xticks(2:0.5:5)
xticklabels({'2','','3','','4','','5'})
yticks(0:500:3000)
yticklabels({'0','','1000','','2000',''})

set(gca,'Linewidth',1.5,'TickDir','in');
title('Supplementary Figure 1c');
drawnow;

%% SM fig 1d
data=importdata('SM_Fig_1b_data.dat');
fit=importdata('SM_Fig_1b_fit.dat');
figure;
plot(data(:,1),data(:,2),'ro','MarkerSize',3,'MarkerFacecolor',[1 0 0]);
hold on;
plot(fit(:,1),fit(:,2),'k-','LineWidth',1);
axis([1.9 5.1 0 2800])

xlabel('d (\AA)','interpreter','latex')
ylabel('Intensity (arb. units)')
xticks(2:0.5:5)
xticklabels({'2','','3','','4','','5'})
yticks(0:500:3000)
yticklabels({'0','','1000','','2000',''})

set(gca,'Linewidth',1.5,'TickDir','in');
title('Supplementary Figure 1d');
drawnow;

%% SM fig 6a
data=importdata('SM_fig_6a.xye');
fits=importdata('SM_fig_6a.xy');

figure;
plot(data(:,1),data(:,2),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','MarkerSize',7);
hold on;
plot(data(:,1),data(:,4),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','MarkerSize',6);
plot(fits(:,1),fits(:,2),'k-','LineWidth',2);
plot(fits(:,1),fits(:,3),'k-','LineWidth',2);

xline(-60,'k--');xline(120,'k--');

errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',7);
errorbar(data(:,1),data(:,4),data(:,5),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',6);

l=legend;
l.Location='northwest';
l.String={'[8.5, 10.5] meV top band' '[6.5,   8.5] meV bottom band'};
l.EdgeColor=[1 1 1];

axis([-180 180 49 438])
xlabel('\alpha (deg)')
ylabel('Intensity (arb. units)')
xticks(-180:90:180)
yticks(100:100:400)

text(-150,350,'L=[0, 2.4]')
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 6a');
drawnow;

%% SM fig 6b
data=importdata('SM_fig_6b.xye');
fits=importdata('SM_fig_6b.xy');

figure;
plot(data(:,1),data(:,2),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','MarkerSize',7);
hold on;
plot(data(:,1),data(:,4),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','MarkerSize',6);
plot(fits(:,1),fits(:,2),'k-','LineWidth',2);
plot(fits(:,1),fits(:,3),'k-','LineWidth',2);

xline(-60,'k--');xline(120,'k--');

errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',7);
errorbar(data(:,1),data(:,4),data(:,5),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',6);

l=legend;
l.Location='northwest';
l.String={'[8.5, 10.5] meV top band' '[6.5,   8.5] meV bottom band'};
l.EdgeColor=[1 1 1];

axis([-180 180 25 453])
xlabel('\alpha (deg)')
ylabel('Intensity (arb. units)')
xticks(-180:90:180)
yticks(100:100:400)

text(-150,350,'L=[-1, 1]')
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 6b');
drawnow;

%% SM fig 6c
data=importdata('SM_fig_6c.xye');
fits=importdata('SM_fig_6c.xy');

figure;
plot(data(:,1),data(:,2),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','MarkerSize',7);
hold on;
plot(data(:,1),data(:,4),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','MarkerSize',6);
plot(fits(:,1),fits(:,2),'k-','LineWidth',2);
plot(fits(:,1),fits(:,3),'k-','LineWidth',2);

xline(-60,'k--');xline(120,'k--');

errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','s','MarkerFaceColor','k','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',7);
errorbar(data(:,1),data(:,4),data(:,5),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','CapSize',0,'LineWidth',1,'MarkerSize',6);

l=legend;
l.Location='northwest';
l.String={'[8.5, 10.5] meV top band' '[6.5,   8.5] meV bottom band'};
l.EdgeColor=[1 1 1];

axis([-180 180 45 450])
xlabel('\alpha (deg)')
ylabel('Intensity (arb. units)')
xticks(-180:90:180)
yticks(100:100:400)

text(-150,350,'L=[-2.4, 0]')
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 6c');
drawnow;

%% SM fig 8a
plot_color_fig('SM_fig_8a.dat',1)

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10 600])
c=colorbar;
c.Ticks=(200:200:600);

axis([-0.45 0.45 0 6.072])
xticks(-0.4:0.2:0.4)
xlabel('(1+\xi,1-\xi,1.5)')
ylabel('Energy (meV)')
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 8a');
drawnow;

%% SM fig 8b
plot_color_fig('SM_fig_8b.dat',1)

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10 600])
c=colorbar;
c.Ticks=(200:200:600);

axis([-0.255 0.255 -0.024 6.072])
xticks(-0.2:0.1:0.2)
xlabel('(1+\zeta,1+\zeta,1.5)')
ylabel('Energy (meV)')
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 8b');
drawnow;

%% SM fig 9
data=importdata('SM_fig_9.xye');

data1=data(data(:,6)==1,:);
data2=data(data(:,6)==2,:);
data5=data(data(:,6)==5,:);

figure
errorbar(data1(:,7),data1(:,4),data1(:,5),'Color',[0.5451 0 0.5451],'Marker','o','MarkerFaceColor',[0.5451 0 0.5451],'LineStyle','none')
hold on;
errorbar(data2(:,7),data2(:,4),data2(:,5),'Color',[0.7451 0.7451 0.7451],'Marker','o','MarkerFaceColor',[0.7451 0.7451 0.7451],'LineStyle','none')
errorbar(data5(:,7),data5(:,4),data5(:,5),'Color',[0 0.39216 0],'Marker','o','MarkerFaceColor',[0 0.39216 0],'LineStyle','none')
plot((0:0.1:13),(0:0.1:13),'k-','LineWidth',2);

a=gca;
a.DataAspectRatio=[1 1 1];
a.DataAspectRatioMode='manual';

axis([0 12.453 0 12.453])
xlabel('Calculated Energy $\tilde{\omega}$ (meV)','Interpreter','latex')
ylabel('Observed Energy (meV)','Interpreter','latex')
xticks(0:2:12)
yticks(0:2:12)
l=legend;
l.String={'\omega_1'  '\omega_2'  '\omega_{3,4}'};
l.Location='northwest';
l.FontSize=10.8;
l.EdgeColor=[1 1 1];
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 9');
drawnow;

%% SM fig 10
data=importdata('SM_fig_10.xye');
fit=importdata('SM_fig_10.xy');

figure;
plot(fit(:,1),fit(:,2),'k-','LineWidth',2);
hold on;
errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','o','MarkerFaceColor','w','MarkerSize',8,'LineStyle','none','Capsize',0,'LineWidth',2)
axis([0.45 4.99 0 850])
xlabel('Energy (meV)')
ylabel('Intensity (arb. units)')
xticks(1:4)
yticks(0:400:800)

t=text(2.75,750,'$\mathbf{k}=(1 1 \frac{3}{2})$');
t.Interpreter='LaTeX';
t.FontSize=20;
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 10');
drawnow;

%% SM fig 11
plot_color_fig('SM_fig_11.dat',1)
fits=importdata('SM_fig_11.xy');
data=importdata('SM_fig_11.xye');
sz=eval([data.textdata{:}]);

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([0 600])
c=colorbar;
c.Ticks=(200:200:600);

hold on
plot(fits(:,1),fits(:,5),'m-','LineWidth',2);
plot(fits(:,1),fits(:,6),'m-','LineWidth',2);
plot(fits(:,1),fits(:,7),'y-','LineWidth',2);
plot(fits(:,1),fits(:,8),'y-','LineWidth',2);

errorbar(data.data(1,1),data.data(1,2),data.data(1,3),'Color',[0.64706 0.37255 0.64706],'Marker','o','MarkerFaceColor',[0.64706 0.37255 0.64706],'LineStyle','none')
errorbar(data.data(sz(1)+1:sz(1)+sz(2),1),data.data(sz(1)+1:sz(1)+sz(2),2),data.data(sz(1)+1:sz(1)+sz(2),3),'Color',[0.5451 0 0.5451],'Marker','o','MarkerFaceColor',[0.5451 0 0.5451],'LineStyle','none')
errorbar(data.data(sz(1)+sz(2)+1:sz(1)+sz(2)+sz(3),1),data.data(sz(1)+sz(2)+1:sz(1)+sz(2)+sz(3),2),data.data(sz(1)+sz(2)+1:sz(1)+sz(2)+sz(3),3),'Color',[0.7451 0.7451 0.7451],'Marker','o','MarkerFaceColor',[0.7451 0.7451 0.7451],'LineStyle','none')
errorbar(data.data(sz(1)+sz(2)+sz(3)+1:sz(1)+sz(2)+sz(3)+sz(4),1),data.data(sz(1)+sz(2)+sz(3)+1:sz(1)+sz(2)+sz(3)+sz(4),2),data.data(sz(1)+sz(2)+sz(3)+1:sz(1)+sz(2)+sz(3)+sz(4),3),'Color',[0 0.39216 0],'Marker','o','MarkerFaceColor',[0 0.39216 0],'LineStyle','none')
hold off

axis([0 2 5.5 12.3])
xticks([2/3 4/3]);
xticklabels({'(2/3,2/3,3/4)','(4/3,1/3,3/4)'})
set(gca,'Linewidth',1.5,'TickDir','out');
ylabel('Energy (meV)')
title('Supplementary Figure 11');
drawnow;

%% SM fig 12
plot_color_fig('SM_fig_12.dat',1)
fits=importdata('SM_fig_12.xy');
data=importdata('SM_fig_12.xye');
sz=eval([data.textdata{:}]);

load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([0 600])
c=colorbar;
c.Ticks=(200:200:600);

hold on
plot(fits(:,1),fits(:,5),'m-','LineWidth',2);
plot(fits(:,1),fits(:,6),'m--','LineWidth',2);
plot(fits(:,1),fits(:,7),'m-','LineWidth',2);
plot(fits(:,1),fits(:,8),'m--','LineWidth',2);
plot(fits(:,1),fits(:,9),'y-','LineWidth',2);
plot(fits(:,1),fits(:,10),'y--','LineWidth',2);
plot(fits(:,1),fits(:,11),'y-','LineWidth',2);
plot(fits(:,1),fits(:,12),'y--','LineWidth',2);

errorbar(data.data(1:sz(1),1),data.data(1:sz(1),2),data.data(1:sz(1),3),'Color',[0.5451 0 0.5451],'Marker','o','MarkerFaceColor',[0.5451 0 0.5451],'LineStyle','none')
errorbar(data.data(sz(1)+1:sz(1)+sz(2),1),data.data(sz(1)+1:sz(1)+sz(2),2),data.data(sz(1)+1:sz(1)+sz(2),3),'Color',[0.7451 0.7451 0.7451],'Marker','o','MarkerFaceColor',[0.7451 0.7451 0.7451],'LineStyle','none')
errorbar(data.data(sz(1)+sz(2)+1:sz(1)+sz(2)+sz(3),1),data.data(sz(1)+sz(2)+1:sz(1)+sz(2)+sz(3),2),data.data(sz(1)+sz(2)+1:sz(1)+sz(2)+sz(3),3),'Color',[0 0.39216 0],'Marker','o','MarkerFaceColor',[0 0.39216 0],'LineStyle','none')
hold off

axis([0 2 5.5 12.3])
xticks([2/3 4/3]);
xticklabels({'(2/3,2/3,5/4)','(4/3,1/3,5/4)'})
ylabel('Energy (meV)')
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 12');
drawnow;

%% SM fig 14
data=importdata('SM_fig_14.xye');
fits=importdata('SM_fig_14.xy');

figure;

plot(data(:,1),data(:,2),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','LineWidth',2,'MarkerSize',8)
hold on;
plot(fits(:,1),fits(:,3),'Color',[0.8 0.8 0.8],'LineStyle','--','LineWidth',2);
plot(fits(:,1),fits(:,2),'k-','LineWidth',2);
errorbar(data(:,1),data(:,2),data(:,3),'Color','k','Marker','o','MarkerFaceColor','w','LineStyle','none','LineWidth',2,'CapSize',0,'MarkerSize',8)

axis([7 9.9 0 799])
xlabel('Energy (meV)')
ylabel('Intensity (arb. units)')
xticks(7:0.5:10)
yticks(0:200:800)
l=legend;
l.String={'data' '\eta = +1.7 meV' '\eta = -1.7 meV'};
l.FontSize=16.2;
l.EdgeColor=[1 1 1];
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 14');
drawnow;

%% SM fig 15a
plot_color_fig('SM_fig_15a.dat',1)
BZ=importdata('BZ.xy');

axis([-1.95 -0.05 0.75 2.25]);
load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10   550]);
c=colorbar;
c.Ticks=(100:100:500);

a=gca;
a.DataAspectRatio=[1.44 1.25 1];
a.DataAspectRatioMode='manual';

hold on;
plot(BZ(:,1),BZ(:,2),'LineStyle','--','LineWidth',3,'Color',[0.7 0.7 0.7])
xlabel('$(0.5\zeta,-\zeta)$ in $1.25$\AA$^{-1}$','interpreter','latex');
ylabel('$(\xi,0)$ in $1.44$\AA$^{-1}$','interpreter','latex');
xticks(-1.5:0.5:-0.5)
yticks(1:0.5:2)
set(gca,'Linewidth',1.5,'TickDir','out');
title('Supplementary Figure 15a');
drawnow;

%% SM fig 15b
plot_color_fig('SM_fig_15b.dat',1)
BZ=importdata('BZ.xy');

axis([-1.95 -0.05 0.75 2.25]);
load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10   550]);
c=colorbar;
c.Ticks=(100:100:500);

a=gca;
a.DataAspectRatio=[1.44 1.25 1];
a.DataAspectRatioMode='manual';

hold on;
plot(BZ(:,1),BZ(:,2),'LineStyle','--','LineWidth',3,'Color',[0.7 0.7 0.7])
xlabel('$(0.5\zeta,-\zeta)$ in $1.25$\AA$^{-1}$','interpreter','latex');
ylabel('$(\xi,0)$ in $1.44$\AA$^{-1}$','interpreter','latex');
xticks(-1.5:0.5:-0.5)
yticks(1:0.5:2)
title('Supplementary Figure 15b');
drawnow;

%% SM fig 15c
plot_color_fig('SM_fig_15c.dat',0)
BZ=importdata('BZ.xy');

axis([-1.95 -0.05 0.75 2.25]);
load('colmap.dat','-ascii','colmap');colormap(colmap);
caxis([10   550]);
c=colorbar;
c.Ticks=(100:100:500);

a=gca;
a.DataAspectRatio=[1.44 1.25 1];
a.DataAspectRatioMode='manual';

hold on;
plot(BZ(:,1),BZ(:,2),'LineStyle','--','LineWidth',3,'Color',[0.7 0.7 0.7])
xlabel('$(0.5\zeta,-\zeta)$ in $1.25$\AA$^{-1}$','interpreter','latex');
ylabel('$(\xi,0)$ in $1.44$\AA$^{-1}$','interpreter','latex');
xticks(-1.5:0.5:-0.5)
yticks(1:0.5:2)
title('Supplementary Figure 15c');
drawnow;

%% SM fig 15d
plot_color_fig('SM_fig_15d.dat',0)
BZ=importdata('BZ.xy');

load('colmap.dat','-ascii','colmap');colormap(colmap);
colormap(colmap);
caxis([10   550]);
c=colorbar;
c.Ticks=(100:100:500);

a=gca;
a.DataAspectRatio=[1.44 1.25 1];
a.DataAspectRatioMode='manual';

hold on;
plot(BZ(:,1),BZ(:,2),'LineStyle','--','LineWidth',3,'Color',[0.7 0.7 0.7])
xlabel('$(0.5\zeta,-\zeta)$ in $1.25$\AA$^{-1}$','interpreter','latex');
ylabel('$(\xi,0)$ in $1.44$\AA$^{-1}$','interpreter','latex');
xticks(-1.5:0.5:-0.5)
yticks(1:0.5:2)
title('Supplementary Figure 15d');
drawnow;

%% SM fig 16a
data=importdata('SM_Fig_16a_data.xy');
fit=importdata('SM_Fig_16a_fit.xy');
figure;
plot(data(:,1),data(:,2),'bo','MarkerSize',5,'MarkerFacecolor',[0 0 1]);
hold on;
plot(fit(:,1),fit(:,2),'b-','LineWidth',2);
axis([0 60 16.429 16.451])

xlabel('$\phi~(^\circ)$','interpreter','latex')
ylabel('Zero Point Energy $E_0$','interpreter','latex')
xticks(0:10:60)
yticks(16.430:0.005:16.450)
yticklabels({'16.430','16.435','16.440','16.445','16.450'})

set(gca,'Linewidth',1.5,'TickDir','in');
title('Supplementary Figure 16a');
drawnow;

%% SM fig 16b
data=importdata('SM_Fig_16b_data.xy');
fit=importdata('SM_Fig_16b_fit.xy');
f=figure;
xline(0,'Color',[0.8 0.8 0.8]);
yline(0,'Color',[0.8 0.8 0.8]);
hold on;
plot(data(:,1),data(:,2),'bo','MarkerSize',5,'MarkerFacecolor',[0 0 1]);
plot(fit(:,1),fit(:,2),'r-','LineWidth',2);
axis([-6.2 6.2 -0.017 0.017])

xlabel('$\eta$ (meV)','interpreter','latex')
ylabel('$\Lambda$ (meV)','interpreter','latex')
xticks(-6:2:6)
%xticklabels({'1','','2','','3','','4','','5','','6','','7','','8','','9','','10'})
yticks(-0.015:0.005:0.015)
%yticklabels({'16.430','16.435','16.440','16.445','16.450'})

%set(gca,'Linewidth',1.5,'TickDir','in');
title('Supplementary Figure 16b');
drawnow;

%% Subroutines to plot

function hout=plot_color_fig(fdata,isErr,flag,varargin)
% Plots color data in .dat file, with isErr specifying if the input
% .dat file contains a column for errors (i.e. if experimental data); and
% flag specifying whether to plot smoothed intensities (flag=1 - default),
% raw intensities (flag=0), or errors (flag=-1).
% Additionally evaluates code strings specified as optional arguments.

fdata=importdata(fdata,' ',1);

sz=eval(fdata.textdata{1});

if ~exist('flag','var') %By default, set flag to 1
    flag=1;
end

% Reshape to 2D array for plotting
if isErr
X=reshape(fdata.data(:,1),sz);
Y=reshape(fdata.data(:,end-3),sz);
switch flag
    case -1 %Plot errors
        C=reshape(fdata.data(:,end-1),sz);
    case 0 %Raw intensities
        C=reshape(fdata.data(:,end-2),sz);
    case 1 %Smoothed intensities
        C=reshape(fdata.data(:,end),sz);
end
else
X=reshape(fdata.data(:,1),sz);
Y=reshape(fdata.data(:,end-1),sz);
C=reshape(fdata.data(:,end),sz);    
end

[X,Y,C]=cen2edge(X,Y,C);  % convert bin centers to edges for pcolor

figure
h=pcolor(X,Y,C);
shading flat

isNum=~isnan(C);
axis([min(X(isNum)) max(X(isNum)) min(Y(isNum)) max(Y(isNum))])

% Execute any strings entered as optional parameters
for i=1:length(varargin)
    hold on
    eval(varargin{i})
    hold off
end

if nargout>0
    hout=h;
end
end

function [Xedge,Yedge,varargout]=cen2edge(Xcen,Ycen,varargin)
% Converts bin edges to centers
diffX=diff(Xcen,1,2);
Xedge=Xcen(:,1:end-1)-diffX/2;
Xedge(:,end+1)=Xcen(:,end)+diffX(:,end)/2;

diffY=diff(Ycen,1,1);
Yedge=Ycen(1:end-1,:)-diffY/2;
Yedge(end+1,:)=Ycen(end,:)+diffY(end,:)/2;

varargout=cell(size(varargin));
for i=1:numel(varargin)
    array=reshape(varargin{i},size(Xcen));
    varargout{i}=array;
end
end