#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
This experiment was created using PsychoPy2 Experiment Builder (v1.84.2),
    on Tue 23 May 13:29:27 2017
If you publish work using this script please cite the PsychoPy publications:
    Peirce, JW (2007) PsychoPy - Psychophysics software in Python.
        Journal of Neuroscience Methods, 162(1-2), 8-13.
    Peirce, JW (2009) Generating stimuli for neuroscience using PsychoPy.
        Frontiers in Neuroinformatics, 2:10. doi: 10.3389/neuro.11.010.2008
"""

from __future__ import absolute_import, division
from psychopy import gui, visual, core, data, event, logging, sound
from psychopy.constants import (NOT_STARTED, STARTED, PLAYING, PAUSED,
                                STOPPED, FINISHED, PRESSED, RELEASED, FOREVER)
import numpy as np  # whole numpy lib is available, prepend 'np.'
from numpy import (sin, cos, tan, log, log10, pi, average,
                   sqrt, std, deg2rad, rad2deg, linspace, asarray)
from numpy.random import random, randint, normal, shuffle
import os  # handy system and path functions
import sys  # to get file system encoding

# Ensure that relative paths start from the same directory as this script
_thisDir = os.path.dirname(os.path.abspath(__file__)).decode(sys.getfilesystemencoding())
os.chdir(_thisDir)

# Store info about the experiment session
expName = 'phaseforward'  # from the Builder filename that created this script
expInfo = {u'session': u'001', u'participant': u''}
dlg = gui.DlgFromDict(dictionary=expInfo, title=expName)
if dlg.OK == False:
    core.quit()  # user pressed cancel
expInfo['date'] = data.getDateStr()  # add a simple timestamp
expInfo['expName'] = expName

# Data file name stem = absolute path + name; later add .psyexp, .csv, .log, etc
filename = _thisDir + os.sep + 'data/%s_%s_%s' %(expInfo['participant'], expName, expInfo['date'])

# An ExperimentHandler isn't essential but helps with data saving
thisExp = data.ExperimentHandler(name=expName, version='',
    extraInfo=expInfo, runtimeInfo=None,
    originPath=None,
    savePickle=True, saveWideText=True,
    dataFileName=filename)
# save a log file for detail verbose info
logFile = logging.LogFile(filename+'.log', level=logging.EXP)
logging.console.setLevel(logging.WARNING)  # this outputs to the screen, not a file

endExpNow = False  # flag for 'escape' or other condition => quit the exp

# Start Code - component code to be run before the window creation

# Setup the Window (2560, 1440),
win = visual.Window(
    size=(2560, 1440), fullscr=True, screen=0,
    allowGUI=False, allowStencil=False,
    monitor='testMonitor', color=[-1,-1,-1], colorSpace='rgb',
    blendMode='avg', useFBO=True,
    units='cm')
# store frame rate of monitor if we can measure it
expInfo['frameRate'] = win.getActualFrameRate()
if expInfo['frameRate'] != None:
    frameDur = 1.0 / round(expInfo['frameRate'])
else:
    frameDur = 1.0 / 60.0  # could not measure, so guess

# Initialize components for Routine "wait"
waitClock = core.Clock()
from psychopy.hardware.emulator import launchScan, SyncGenerator

# Initialize components for Routine "wait_2"
wait_2Clock = core.Clock()
ISI = core.StaticPeriod(win=win, screenHz=expInfo['frameRate'], name='ISI')
Wait = visual.TextStim(win=win, name='Wait',
    text='Please wait',
    font='Arial',
    pos=[0, 3], height=2, wrapWidth=None, ori=0, 
    color='white', colorSpace='rgb', opacity=1,
    depth=-1.0);

# Initialize components for Routine "static_circl"
static_circlClock = core.Clock()
Circle1 = visual.Polygon(
    win=win, name='Circle1',
    edges=90, size=[2, 2],
    ori=0, pos=[-6, 3],
    lineWidth=1, lineColor=[1,1,1], lineColorSpace='rgb',
    fillColor=[1,1,1], fillColorSpace='rgb',
    opacity=1.0, depth=0.0, interpolate=True)
Circle2 = visual.Polygon(
    win=win, name='Circle2',
    edges=90, size=[2, 2],
    ori=0, pos=[-2, 3],
    lineWidth=1, lineColor=[1,1,1], lineColorSpace='rgb',
    fillColor=[1,1,1], fillColorSpace='rgb',
    opacity=1, depth=-1.0, interpolate=True)
Circle3 = visual.Polygon(
    win=win, name='Circle3',
    edges=90, size=[2, 2],
    ori=0, pos=[2, 3],
    lineWidth=1, lineColor=[1,1,1], lineColorSpace='rgb',
    fillColor=[1,1,1], fillColorSpace='rgb',
    opacity=1, depth=-2.0, interpolate=True)
Circle4 = visual.Polygon(
    win=win, name='Circle4',
    edges=90, size=[2, 2],
    ori=0, pos=[6, 3],
    lineWidth=1, lineColor=[1,1,1], lineColorSpace='rgb',
    fillColor=[1,1,1], fillColorSpace='rgb',
    opacity=1, depth=-3.0, interpolate=True)

# Initialize components for Routine "Instr"
InstrClock = core.Clock()
text = visual.TextStim(win=win, name='text',
    text='Movement',
    font='Arial',
    pos=[0, 3], height=2, wrapWidth=None, ori=0, 
    color='white', colorSpace='rgb', opacity=1,
    depth=0.0);

# Initialize components for Routine "static_circl_2"
static_circl_2Clock = core.Clock()
Circle1_2 = visual.Polygon(
    win=win, name='Circle1_2',
    edges=90, size=[2, 2],
    ori=0, pos=[-6, 3],
    lineWidth=1, lineColor=[1,1,1], lineColorSpace='rgb',
    fillColor=[1,1,1], fillColorSpace='rgb',
    opacity=1.0, depth=0.0, interpolate=True)
Circle2_2 = visual.Polygon(
    win=win, name='Circle2_2',
    edges=90, size=[2, 2],
    ori=0, pos=[-2, 3],
    lineWidth=1, lineColor=[1,1,1], lineColorSpace='rgb',
    fillColor=[1,1,1], fillColorSpace='rgb',
    opacity=1.0, depth=-1.0, interpolate=True)
Circle3_2 = visual.Polygon(
    win=win, name='Circle3_2',
    edges=90, size=[2, 2],
    ori=0, pos=[2, 3],
    lineWidth=1, lineColor=[1,1,1], lineColorSpace='rgb',
    fillColor=[1,1,1], fillColorSpace='rgb',
    opacity=1.0, depth=-2.0, interpolate=True)
Circle4_2 = visual.Polygon(
    win=win, name='Circle4_2',
    edges=90, size=[2, 2],
    ori=0, pos=[6, 3],
    lineWidth=1, lineColor=[1,1,1], lineColorSpace='rgb',
    fillColor=[1,1,1], fillColorSpace='rgb',
    opacity=1.0, depth=-3.0, interpolate=True)

# Initialize components for Routine "End"
EndClock = core.Clock()
text_2 = visual.TextStim(win=win, name='text_2',
    text='End',
    font='Arial',
    pos=[0, 3], height=2, wrapWidth=None, ori=0, 
    color='white', colorSpace='rgb', opacity=1,
    depth=0.0);

# Create some handy timers
globalClock = core.Clock()  # to track the time since experiment started
routineTimer = core.CountdownTimer()  # to track time remaining of each (non-slip) routine 

# ------Prepare to start Routine "wait"-------
t = 0
waitClock.reset()  # clock
frameN = -1
continueRoutine = True
# update component parameters for each repeat
MR_settings = { 
    'TR': 2, # duration (sec) per volume
    'volumes': 134, # number of whole-brain 3D volumes / frames
    'sync': 's', # character to use as the sync timing event; assumed to come at start of a volume
    'skip': 0, # number of volumes lacking a sync pulse at start of scan (for T1 stabilization)
    'sound': False # in test mode only, play a tone as a reminder of scanner noise
    }
trigger='s' # Input trigger from scanner (5 on Philips)
# set up handler to look after randomisation of conditions etc
trials_3 = data.TrialHandler(nReps=8, method='sequential', 
    extraInfo=expInfo, originPath=None,
    trialList=[None],
    seed=None, name='trials_3')
thisExp.addLoop(trials_3)  # add the loop to the experiment
thisTrial_3 = trials_3.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisTrial_3.rgb)
if thisTrial_3 != None:
    for paramName in thisTrial_3.keys():
        exec(paramName + '= thisTrial_3.' + paramName)

#======== Change here for Scanning . mode = 'Scan' ===========
vol=launchScan(win, MR_settings, globalClock=core.Clock(), simResponses=None, mode='Scan', esc_key='escape', log=True)

expClock = core.Clock()
volume=0
print expClock.getTime()

# keep track of which components have finished
waitComponents = []
for thisComponent in waitComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "wait"-------
while continueRoutine:
    # get current time
    t = waitClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in waitComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
        
    if event.getKeys(keyList=[trigger]): 
        volume +=1
        print volume 
            
    # refresh the screen
    if continueRoutine:
        # don't flip if this routine is over or we'll get a blank screen
        win.flip()

print expClock.getTime()

# -------Ending Routine "wait"-------
for thisComponent in waitComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)

# the Routine "wait" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "wait_2"-------
t = 0
wait_2Clock.reset()  # clock
frameN = -1
continueRoutine = True
routineTimer.add(5.000000)
# update component parameters for each repeat
# keep track of which components have finished
wait_2Components = [ISI, Wait]
print volume 
for thisComponent in wait_2Components:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "wait_2"-------
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = wait_2Clock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *Wait* updates
    if t >= 0.0 and Wait.status == NOT_STARTED:
        # keep track of start time/frame for later
        Wait.tStart = t
        Wait.frameNStart = frameN  # exact frame index
        Wait.setAutoDraw(True)
    frameRemains = 0.0 + 5- win.monitorFramePeriod * 0.75  # most of one frame period left
    if Wait.status == STARTED and t >= frameRemains:
        Wait.setAutoDraw(False)
#    # *ISI* period
    if t >= 0.0 and ISI.status == NOT_STARTED:
        # keep track of start time/frame for later
        ISI.tStart = t
        ISI.frameNStart = frameN  # exact frame index
        ISI.start(0.5)
    elif ISI.status == STARTED:  # one frame should pass before updating params and completing
        ISI.complete()  # finish the static period
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in wait_2Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
        
    if event.getKeys(keyList=[trigger]): 
        volume +=1
        print volume     
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "wait_2"-------
for thisComponent in wait_2Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)

# ------Prepare to start Routine "static_circl"-------
t = 0
static_circlClock.reset()  # clock
frameN = -1
continueRoutine = True
routineTimer.add(4.000000)
# update component parameters for each repeat
Circle1.setOpacity(1)
# keep track of which components have finished
static_circlComponents = [Circle1, Circle2, Circle3, Circle4]
for thisComponent in static_circlComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "static_circl"-------
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = static_circlClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *Circle1* updates
    if t >= 0.0 and Circle1.status == NOT_STARTED:
        # keep track of start time/frame for later
        Circle1.tStart = t
        Circle1.frameNStart = frameN  # exact frame index
        Circle1.setAutoDraw(True)
    frameRemains = 0.0 + 4- win.monitorFramePeriod * 0.75  # most of one frame period left
    if Circle1.status == STARTED and t >= frameRemains:
        Circle1.setAutoDraw(False)
    
    # *Circle2* updates
    if t >= 0.0 and Circle2.status == NOT_STARTED:
        # keep track of start time/frame for later
        Circle2.tStart = t
        Circle2.frameNStart = frameN  # exact frame index
        Circle2.setAutoDraw(True)
    frameRemains = 0.0 + 4- win.monitorFramePeriod * 0.75  # most of one frame period left
    if Circle2.status == STARTED and t >= frameRemains:
        Circle2.setAutoDraw(False)
    
    # *Circle3* updates
    if t >= 0.0 and Circle3.status == NOT_STARTED:
        # keep track of start time/frame for later
        Circle3.tStart = t
        Circle3.frameNStart = frameN  # exact frame index
        Circle3.setAutoDraw(True)
    frameRemains = 0.0 + 4- win.monitorFramePeriod * 0.75  # most of one frame period left
    if Circle3.status == STARTED and t >= frameRemains:
        Circle3.setAutoDraw(False)
    
    # *Circle4* updates
    if t >= 0.0 and Circle4.status == NOT_STARTED:
        # keep track of start time/frame for later
        Circle4.tStart = t
        Circle4.frameNStart = frameN  # exact frame index
        Circle4.setAutoDraw(True)
    frameRemains = 0.0 + 4- win.monitorFramePeriod * 0.75  # most of one frame period left
    if Circle4.status == STARTED and t >= frameRemains:
        Circle4.setAutoDraw(False)
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in static_circlComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
    
    if event.getKeys(keyList=[trigger]): 
        volume +=1
        print volume 
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
print expClock.getTime()

# -------Ending Routine "static_circl"-------
for thisComponent in static_circlComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)

# ------Prepare to start Routine "Instr"-------
t = 0
InstrClock.reset()  # clock
frameN = -1
continueRoutine = True
routineTimer.add(2.9)
# update component parameters for each repeat
# keep track of which components have finished
InstrComponents = [text]
for thisComponent in InstrComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "Instr"-------
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = InstrClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *text* updates
    if t >= 0.0 and text.status == NOT_STARTED:
        # keep track of start time/frame for later
        text.tStart = t
        text.frameNStart = frameN  # exact frame index
        text.setAutoDraw(True)
    frameRemains = 0.0 + 3- win.monitorFramePeriod * 0.75  # most of one frame period left
    if text.status == STARTED and t >= frameRemains:
        text.setAutoDraw(False)
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in InstrComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
    
    if event.getKeys(keyList=[trigger]): 
        volume +=1
        print volume 
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
#print expClock.getTime()

# -------Ending Routine "Instr"-------
for thisComponent in InstrComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)

for thisTrial_3 in trials_3:
    currentLoop = trials_3
    # abbreviate parameter names if possible (e.g. rgb = thisTrial_3.rgb)
    if thisTrial_3 != None:
        for paramName in thisTrial_3.keys():
            exec(paramName + '= thisTrial_3.' + paramName)
    
    # set up handler to look after randomisation of conditions etc
    trials = data.TrialHandler(nReps=1, method='sequential', 
        extraInfo=expInfo, originPath=None,
        trialList=data.importConditions('opacity_loop_forward.xlsx'),
        seed=None, name='trials')
    thisExp.addLoop(trials)  # add the loop to the experiment
    thisTrial = trials.trialList[0]  # so we can initialise stimuli with some values
    # abbreviate parameter names if possible (e.g. rgb = thisTrial.rgb)
    if thisTrial != None:
        for paramName in thisTrial.keys():
            exec(paramName + '= thisTrial.' + paramName)
    
# ===== wait for fMRI pulse here =====
    pulse =event.waitKeys(keyList=trigger) 
    if trigger in pulse:
        volume +=1
        print volume 
        print  expClock.getTime()  # start cycle.
        for thisTrial in trials:
            currentLoop = trials
            # abbreviate parameter names if possible (e.g. rgb = thisTrial.rgb)
            if thisTrial != None:
                for paramName in thisTrial.keys():
                    exec(paramName + '= thisTrial.' + paramName)
            
            # ------Prepare to start Routine "static_circl_2"-------
            t = 0
            static_circl_2Clock.reset()  # clock
            frameN = -1
            continueRoutine = True
            routineTimer.add(0.500000)
            # update component parameters for each repeat
            Circle1_2.setOpacity(op1)
            Circle2_2.setOpacity(op2)
            Circle3_2.setOpacity(op3)
            Circle4_2.setOpacity(op4)
            key_resp_2 = event.BuilderKeyResponse()
            # keep track of which components have finished
            static_circl_2Components = [Circle1_2, Circle2_2, Circle3_2, Circle4_2, key_resp_2]
            for thisComponent in static_circl_2Components:
                if hasattr(thisComponent, 'status'):
                    thisComponent.status = NOT_STARTED
            # -------Start Routine "static_circl_2"-------
            while continueRoutine and routineTimer.getTime() > 0:
                # get current time
                t = static_circl_2Clock.getTime()
                frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
                # update/draw components on each frame
                
                # *Circle1_2* updates
                if t >= 0.0 and Circle1_2.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    Circle1_2.tStart = t
                    Circle1_2.frameNStart = frameN  # exact frame index
                    Circle1_2.setAutoDraw(True)
                frameRemains = 0.0 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if Circle1_2.status == STARTED and t >= frameRemains:
                    Circle1_2.setAutoDraw(False)
                
                # *Circle2_2* updates
                if t >= 0.0 and Circle2_2.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    Circle2_2.tStart = t
                    Circle2_2.frameNStart = frameN  # exact frame index
                    Circle2_2.setAutoDraw(True)
                frameRemains = 0.0 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if Circle2_2.status == STARTED and t >= frameRemains:
                    Circle2_2.setAutoDraw(False)
                
                # *Circle3_2* updates
                if t >= 0.0 and Circle3_2.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    Circle3_2.tStart = t
                    Circle3_2.frameNStart = frameN  # exact frame index
                    Circle3_2.setAutoDraw(True)
                frameRemains = 0.0 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if Circle3_2.status == STARTED and t >= frameRemains:
                    Circle3_2.setAutoDraw(False)
                
                # *Circle4_2* updates
                if t >= 0.0 and Circle4_2.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    Circle4_2.tStart = t
                    Circle4_2.frameNStart = frameN  # exact frame index
                    Circle4_2.setAutoDraw(True)
                frameRemains = 0.0 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if Circle4_2.status == STARTED and t >= frameRemains:
                    Circle4_2.setAutoDraw(False)
                
                # *key_resp_2* updates
                if t >= 0.0 and key_resp_2.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    key_resp_2.tStart = t
                    key_resp_2.frameNStart = frameN  # exact frame index
                    key_resp_2.status = STARTED
                    # keyboard checking is just starting
                    win.callOnFlip(key_resp_2.clock.reset)  # t=0 on next screen flip
                    event.clearEvents(eventType='keyboard')
                frameRemains = 0.5 - win.monitorFramePeriod * 0.75  # most of one frame period left
                if key_resp_2.status == STARTED and t >= frameRemains:
                    key_resp_2.status = STOPPED
                if key_resp_2.status == STARTED:
                    theseKeys = event.getKeys(keyList=['6', '7', '8', '9'])
                
                    # check for quit:
                    if "escape" in theseKeys:
                        endExpNow = True
                    if len(theseKeys) > 0:  # at least one key was pressed
                        key_resp_2.keys.extend(theseKeys)  # storing all keys
                        key_resp_2.rt.append(key_resp_2.clock.getTime())
                
                # check if all components have finished
                if not continueRoutine:  # a component has requested a forced-end of Routine
                    break
                continueRoutine = False  # will revert to True if at least one component still running
                for thisComponent in static_circl_2Components:
                    if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                        continueRoutine = True
                        break  # at least one component has not yet finished
                
                # check for quit (the Esc key)
                if endExpNow or event.getKeys(keyList=["escape"]):
                    core.quit()
                
                # refresh the screen
                if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                    win.flip()
                
                if event.getKeys(keyList=[trigger]): 
                    volume +=1
                    print volume
                    
            # -------Ending Routine "static_circl_2"-------
            for thisComponent in static_circl_2Components:
                if hasattr(thisComponent, "setAutoDraw"):
                    thisComponent.setAutoDraw(False)
            # check responses
            if key_resp_2.keys in ['', [], None]:  # No response was made
                key_resp_2.keys=None
            trials.addData('key_resp_2.keys',key_resp_2.keys)
            if key_resp_2.keys != None:  # we had a response
                trials.addData('key_resp_2.rt', key_resp_2.rt)
            thisExp.nextEntry()
        
        # completed 1 repeats of 'trials'
    thisExp.nextEntry()
    
# completed 8 repeats of 'trials_3'


# ------Prepare to start Routine "End"-------
t = 0
EndClock.reset()  # clock
frameN = -1
continueRoutine = True
routineTimer.add(5.000000)
# update component parameters for each repeat
# keep track of which components have finished
EndComponents = [text_2]
for thisComponent in EndComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "End"-------
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = EndClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *text_2* updates
    if t >= 0.0 and text_2.status == NOT_STARTED:
        # keep track of start time/frame for later
        text_2.tStart = t
        text_2.frameNStart = frameN  # exact frame index
        text_2.setAutoDraw(True)
    frameRemains = 0.0 + 5- win.monitorFramePeriod * 0.75  # most of one frame period left
    if text_2.status == STARTED and t >= frameRemains:
        text_2.setAutoDraw(False)
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in EndComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
        
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
print expClock.getTime()

# -------Ending Routine "End"-------
for thisComponent in EndComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)

# these shouldn't be strictly necessary (should auto-save)
thisExp.saveAsWideText(filename+'.csv')
thisExp.saveAsPickle(filename)
logging.flush()
# make sure everything is closed down
thisExp.abort()  # or data files will save again on exit
win.close()
core.quit()
