#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
This experiment was created using PsychoPy2 Experiment Builder (v1.85.1),
    on June 27, 2017, at 22:39
If you publish work using this script please cite the PsychoPy publications:
    Peirce, JW (2007) PsychoPy - Psychophysics software in Python.
        Journal of Neuroscience Methods, 162(1-2), 8-13.
    Peirce, JW (2009) Generating stimuli for neuroscience using PsychoPy.
        Frontiers in Neuroinformatics, 2:10. doi: 10.3389/neuro.11.010.2008
"""

from __future__ import absolute_import, division
from psychopy import locale_setup, gui, visual, core, data, event, logging, sound
from psychopy.constants import (NOT_STARTED, STARTED, PLAYING, PAUSED,
                                STOPPED, FINISHED, PRESSED, RELEASED, FOREVER)
import numpy as np  # whole numpy lib is available, prepend 'np.'
from numpy import (sin, cos, tan, log, log10, pi, average,
                   sqrt, std, deg2rad, rad2deg, linspace, asarray)
from numpy.random import random, randint, normal, shuffle
import os  # handy system and path functions
import sys  # to get file system encoding

testheight=1.8 # Text height for all prompts

# Ensure that relative paths start from the same directory as this script
_thisDir = os.path.dirname(os.path.abspath(__file__)).decode(sys.getfilesystemencoding())
os.chdir(_thisDir)

# Store info about the experiment session
expName = u'Block_motor_visual_task'  # from the Builder filename that created this script
expInfo = {u'session': u'001', u'participant': u'001'}
dlg = gui.DlgFromDict(dictionary=expInfo, title=expName)
if dlg.OK == False:
    core.quit()  # user pressed cancel
expInfo['date'] = data.getDateStr()  # add a simple timestamp
expInfo['expName'] = expName

# Data file name stem = absolute path + name; later add .psyexp, .csv, .log, etc
filename = _thisDir + os.sep + u'data/%s_%s_%s' % (expInfo['participant'], expName, expInfo['date'])

# An ExperimentHandler isn't essential but helps with data saving
thisExp = data.ExperimentHandler(name=expName, version='',
    extraInfo=expInfo, runtimeInfo=None,
    originPath=None,
    savePickle=True, saveWideText=False,
    dataFileName=filename)
# save a log file for detail verbose info
logFile = logging.LogFile(filename+'.log', level=logging.EXP)
logging.console.setLevel(logging.WARNING)  # this outputs to the screen, not a file

endExpNow = False  # flag for 'escape' or other condition => quit the exp

# Start Code - component code to be run before the window creation

# Setup the Window
win = visual.Window(
    size=(2560, 1440), fullscr=True, screen=0,
    allowGUI=False, allowStencil=False,
    monitor='testMonitor', color=[0,0,0], colorSpace='rgb',
    blendMode='avg', useFBO=True, units="deg")
# store frame rate of monitor if we can measure it
expInfo['frameRate'] = win.getActualFrameRate()
if expInfo['frameRate'] != None:
    frameDur = 1.0 / round(expInfo['frameRate'])
else:
    frameDur = 1.0 / 60.0  # could not measure, so guess

# Initialize components for Routine "wait"
waitClock = core.Clock()
from psychopy.hardware.emulator import launchScan, SyncGenerator

# Initialize components for Routine "wait_2"
wait_2Clock = core.Clock()
ISI = core.StaticPeriod(win=win, screenHz=expInfo['frameRate'], name='ISI')
wait = visual.TextStim(win=win, name='wait',
    text='Please wait',
    font='Arial',
    pos=[0, 0], height=testheight, wrapWidth=None, ori=0, 
    color='white', colorSpace='rgb', opacity=1,
    depth=-1.0);
    
# Initialize components for Routine "ready"
readyClock = core.Clock()
ISI = core.StaticPeriod(win=win, screenHz=expInfo['frameRate'], name='ISI')
ready2 = visual.TextStim(win=win, name='ready2',
    text='Ready?',
    font='Arial',
    pos=[0, 0], height=testheight, wrapWidth=None, ori=0, 
    color='white', colorSpace='rgb', opacity=1,
    depth=-1.0);

# Initialize components for Routine "ONLeft"
ONLeftClock = core.Clock()
ONL = visual.TextStim(win=win, name='ONL',
    text=u'LEFT',
    font=u'Arial',
    pos=[0,0], height=testheight, wrapWidth=None, ori=0, 
    color=u'white', colorSpace='rgb', opacity=1,
    depth=0.0);
#image = visual.ImageStim(
#    win=win, name='image',
#    image=None, mask=None,
#    ori=0, pos=(0, 0), size=(0.8, 0.8),
#    color=[1,1,1], colorSpace='rgb', opacity=1,
#    flipHoriz=False, flipVert=False,
#    texRes=128, interpolate=True, depth=-1.0)
image = visual.RadialStim(win=win, name='check1', tex='sqrXsqr', size=30, angularCycles=10, mask=[0,1,1,1,1])
image_rev = visual.RadialStim(win=win, name='check1', tex='sqrXsqr', size=30, angularCycles=10, mask=[0,1,1,1,1], contrast=-1)
OFFL = visual.TextStim(win=win, name='OFFL',
    text=u'LEFT',
    font=u'Arial',
    pos=(0, 0), height=testheight, wrapWidth=None, ori=0, 
    color=u'black', colorSpace='rgb', opacity=1,
    depth=-2.0);

# Initialize components for Routine "Rest"
RestClock = core.Clock()
REST = visual.TextStim(win=win, name='REST',
    text=u'REST',
    font=u'Arial',
    pos=[0,0], height=testheight, wrapWidth=None, ori=0, 
    color=u'white', colorSpace='rgb', opacity=1,
    depth=0.0);

# Initialize components for Routine "ONRight"
ONRightClock = core.Clock()
ONR = visual.TextStim(win=win, name='ONR',
    text=u'RIGHT',
    font=u'Arial',
    pos=[0,0], height=testheight, wrapWidth=None, ori=0, 
    color=u'white', colorSpace='rgb', opacity=1.0,
    depth=0.0);
#image_2 = visual.ImageStim(
#    win=win, name='image_2',
#    image=None, mask=None,
#    ori=0, pos=(0, 0), size=(0.8, 0.8),
#    color=[1,1,1], colorSpace='rgb', opacity=1,
#    flipHoriz=False, flipVert=False,
#    texRes=128, interpolate=True, depth=-1.0)
ONR2 = visual.TextStim(win=win, name='ONR2',
    text=u'RIGHT',
    font=u'Arial',
    pos=[0,0], height=testheight, wrapWidth=None, ori=0, 
    color=u'black', colorSpace='rgb', opacity=1.0,
    depth=-2.0);

# Initialize components for Routine "Rest"
RestClock = core.Clock()
REST = visual.TextStim(win=win, name='REST',
    text=u'REST',
    font=u'Arial',
    pos=[0,0], height=testheight, wrapWidth=None, ori=0, 
    color=u'white', colorSpace='rgb', opacity=1,
    depth=0.0);

# Initialize components for Routine "end"
endClock = core.Clock()
end2 = visual.TextStim(win=win, name='end2',
    text=u'end',
    font=u'Arial',
    pos=[0,0], height=testheight, wrapWidth=None, ori=0, 
    color=u'white', colorSpace='rgb', opacity=1,
    depth=0.0);

# Create some handy timers
globalClock = core.Clock()  # to track the time since experiment started
routineTimer = core.CountdownTimer()  # to track time remaining of each (non-slip) routine 

# ------Prepare to start Routine "wait"-------
t = 0
waitClock.reset()  # clock
frameN = -1
continueRoutine = True
# update component parameters for each repeat
MR_settings = { 
    'TR': 2, # duration (sec) per volume
    'volumes': 126, # number of whole-brain 3D volumes / frames
    'sync': 's', # character to use as the sync timing event; assumed to come at start of a volume
    'skip': 0, # number of volumes lacking a sync pulse at start of scan (for T1 stabilization)
    'sound': False # in test mode only, play a tone as a reminder of scanner noise
    }
trigger='s' # Input trigger from scanner (5 on Philips)

# set up handler to look after randomisation of conditions etc
EPOCH = data.TrialHandler(nReps=3, method='sequential', 
    extraInfo=expInfo, originPath=-1,
    trialList=[None],
    seed=None, name='EPOCH')
thisExp.addLoop(EPOCH)  # add the loop to the experiment
thisEPOCH = EPOCH.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisEPOCH.rgb)
if thisEPOCH != None:
    for paramName in thisEPOCH.keys():
        exec(paramName + '= thisEPOCH.' + paramName)

#======== Change here for Scanning . mode = 'Scan' ===========
vol=launchScan(win, MR_settings, globalClock=core.Clock(), simResponses=None, mode='Scan', esc_key='escape', log=True)

expClock = core.Clock()
volume=0
print expClock.getTime()

# keep track of which components have finished
waitComponents = []
for thisComponent in waitComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "wait"-------
while continueRoutine:
    # get current time
    t = waitClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in waitComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
    
    # refresh the screen
    if continueRoutine:
        # don't flip if this routine is over or we'll get a blank screen
        win.flip()

print expClock.getTime()

# -------Ending Routine "wait"-------
for thisComponent in waitComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)

# the Routine "wait" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "wait_2"-------
t = 0
wait_2Clock.reset()  # clock
frameN = -1
continueRoutine = True
routineTimer.add(5.900000)
# update component parameters for each repeat
# keep track of which components have finished
wait_2Components = [ISI, wait]
print volume 
for thisComponent in wait_2Components:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "wait_2"-------
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = wait_2Clock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *wait* updates
    if t >= 0.0 and wait.status == NOT_STARTED:
        # keep track of start time/frame for later
        wait.tStart = t
        wait.frameNStart = frameN  # exact frame index
        wait.setAutoDraw(True)
    frameRemains = 0.0 + 6- win.monitorFramePeriod * 0.75  # most of one frame period left
    if wait.status == STARTED and t >= frameRemains:
        wait.setAutoDraw(False)
#    # *ISI* period
    if t >= 0.0 and ISI.status == NOT_STARTED:
        # keep track of start time/frame for later
        ISI.tStart = t
        ISI.frameNStart = frameN  # exact frame index
        ISI.start(0.5)
    elif ISI.status == STARTED:  # one frame should pass before updating params and completing
        ISI.complete()  # finish the static period
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in wait_2Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
        
    
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
        if event.getKeys(keyList=["5"]): 
            volume +=1
            print volume 


# -------Ending Routine "wait_2"-------
for thisComponent in wait_2Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)


# ------Prepare to start Routine "ready"-------
t = 0
readyClock.reset()  # clock
frameN = -1
continueRoutine = True
routineTimer.add(5.900000)
# update component parameters for each repeat
# keep track of which components have finished
readyComponents = [ready2]
for thisComponent in readyComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "ready"-------
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = readyClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *ready* updates
    if t >= 3 and ready2.status == NOT_STARTED:
        # keep track of start time/frame for later
        ready2.tStart = t
        ready2.frameNStart = frameN  # exact frame index
        ready2.setAutoDraw(True)
    frameRemains = 3 + 3- win.monitorFramePeriod * 0.75  # most of one frame period left
    if ready2.status == STARTED and t >= frameRemains:
        ready2.setAutoDraw(False)
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in readyComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
        
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
        if event.getKeys(keyList=[trigger]): 
            volume +=1
            print volume     
# 
print expClock.getTime()

# -------Ending Routine "ready"-------
for thisComponent in readyComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
        

for thisEPOCH in EPOCH:
    currentLoop = EPOCH
    # abbreviate parameter names if possible (e.g. rgb = thisEPOCH.rgb)
    if thisEPOCH != None:
        for paramName in thisEPOCH.keys():
            exec(paramName + '= thisEPOCH.' + paramName)
    
    # set up handler to look after randomisation of conditions etc
    trials = data.TrialHandler(nReps=20, method='sequential', 
        extraInfo=expInfo, originPath=None,
        trialList=[None],
        seed=None, name='trials')
    thisExp.addLoop(trials)  # add the loop to the experiment
    thisTrial = trials.trialList[0]  # so we can initialise stimuli with some values
    # abbreviate parameter names if possible (e.g. rgb = thisTrial.rgb)
    if thisTrial != None:
        for paramName in thisTrial.keys():
            exec(paramName + '= thisTrial.' + paramName)

# ===== wait for fMRI pulse here =====
    pulse =event.waitKeys(keyList=trigger) 
    if trigger in pulse:
        volume +=1
        print volume 
        print  expClock.getTime()  # start cycle.
        
        for thisTrial in trials:
            currentLoop = trials
            # abbreviate parameter names if possible (e.g. rgb = thisTrial.rgb)
            if thisTrial != None:
                for paramName in thisTrial.keys():
                    exec(paramName + '= thisTrial.' + paramName)
            
            # ------Prepare to start Routine "ONLeft"-------
            t = 0
            ONLeftClock.reset()  # clock
            frameN = -1
            continueRoutine = True
            routineTimer.add(1.000000)
            # update component parameters for each repeat
            # keep track of which components have finished
            ONLeftComponents = [ONL, image, OFFL, image_rev]
            for thisComponent in ONLeftComponents:
                if hasattr(thisComponent, 'status'):
                    thisComponent.status = NOT_STARTED
            
            # -------Start Routine "ONLeft"-------
            while continueRoutine and routineTimer.getTime() > 0:
                # get current time
                t = ONLeftClock.getTime()
                frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
                # update/draw components on each frame
                
                # *image_rev* updates
                if t >= 0 and image_rev.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    image_rev.tStart = t
                    image_rev.frameNStart = frameN  # exact frame index
                    image_rev.setAutoDraw(True)
                frameRemains = 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if image_rev.status == STARTED and t >= frameRemains:
                    image_rev.setAutoDraw(False)
                    
                # *ONL* updates
                if t >= 0 and ONL.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    ONL.tStart = t
                    ONL.frameNStart = frameN  # exact frame index
                    ONL.setAutoDraw(True)
                frameRemains = 0.5 - win.monitorFramePeriod * 0.75  # most of one frame period left
                if ONL.status == STARTED and t >= frameRemains:
                    ONL.setAutoDraw(False)
                
                # *image* updates
                if t >= 0.5 and image.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    image.tStart = t
                    image.frameNStart = frameN  # exact frame index
                    image.setAutoDraw(True)
                frameRemains = 0.5 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if image.status == STARTED and t >= frameRemains:
                    image.setAutoDraw(False)
                
                # *OFFL* updates
                if t >= 0.5 and OFFL.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    OFFL.tStart = t
                    OFFL.frameNStart = frameN  # exact frame index
                    OFFL.setAutoDraw(True)
                frameRemains = 0.5 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if OFFL.status == STARTED and t >= frameRemains:
                    OFFL.setAutoDraw(False)
                
                # check if all components have finished
                if not continueRoutine:  # a component has requested a forced-end of Routine
                    break
                continueRoutine = False  # will revert to True if at least one component still running
                for thisComponent in ONLeftComponents:
                    if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                        continueRoutine = True
                        break  # at least one component has not yet finished
                
                # check for quit (the Esc key)
                if endExpNow or event.getKeys(keyList=["escape"]):
                    core.quit()
                           
                # refresh the screen
                if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                    win.flip()
                    
                if event.getKeys(keyList=[trigger]): 
                    volume +=1
                    print volume                
            
            # -------Ending Routine "ONLeft"-------
            for thisComponent in ONLeftComponents:
                if hasattr(thisComponent, "setAutoDraw"):
                    thisComponent.setAutoDraw(False)
            thisExp.nextEntry()
            
        # completed 20 repeats of 'trials'
    
        # get names of stimulus parameters
        if trials.trialList in ([], [None], None):
            params = []
        else:
            params = trials.trialList[0].keys()
        # save data for this loop
        trials.saveAsExcel(filename + '.xlsx', sheetName='trials',
            stimOut=params,
            dataOut=['n','all_mean','all_std', 'all_raw'])
        
        # ------Prepare to start Routine "Rest"-------
        t = 0
        RestClock.reset()  # clock
        frameN = -1
        continueRoutine = True
        routineTimer.add(20.000000)
        # update component parameters for each repeat
        # keep track of which components have finished
        RestComponents = [REST]
        for thisComponent in RestComponents:
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        
        # -------Start Routine "Rest"-------
        while continueRoutine and routineTimer.getTime() > 0:
            # get current time
            t = RestClock.getTime()
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *REST* updates
            if t >= 0.0 and REST.status == NOT_STARTED:
                # keep track of start time/frame for later
                REST.tStart = t
                REST.frameNStart = frameN  # exact frame index
                REST.setAutoDraw(True)
                print  expClock.getTime()  # start cycle.
            frameRemains = 0.0 + 20- win.monitorFramePeriod * 0.75  # most of one frame period left
            if REST.status == STARTED and t >= frameRemains:
                REST.setAutoDraw(False)
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in RestComponents:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # check for quit (the Esc key)
            if endExpNow or event.getKeys(keyList=["escape"]):
                core.quit()
                
            if event.getKeys(keyList=[trigger]): 
                volume +=1
                print volume 
        
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "Rest"-------
        for thisComponent in RestComponents:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
    
        # set up handler to look after randomisation of conditions etc
        trials_2 = data.TrialHandler(nReps=20, method='sequential', 
            extraInfo=expInfo, originPath=-1,
            trialList=[None],
            seed=None, name='trials_2')
        thisExp.addLoop(trials_2)  # add the loop to the experiment
        thisTrial_2 = trials_2.trialList[0]  # so we can initialise stimuli with some values
        # abbreviate parameter names if possible (e.g. rgb = thisTrial_2.rgb)
        if thisTrial_2 != None:
            for paramName in thisTrial_2.keys():
                exec(paramName + '= thisTrial_2.' + paramName)
    
        print  expClock.getTime()  # start cycle.

        for thisTrial_2 in trials_2:
            currentLoop = trials_2
            # abbreviate parameter names if possible (e.g. rgb = thisTrial_2.rgb)
            if thisTrial_2 != None:
                for paramName in thisTrial_2.keys():
                    exec(paramName + '= thisTrial_2.' + paramName)
            
            # ------Prepare to start Routine "ONRight"-------
            t = 0
            ONRightClock.reset()  # clock
            frameN = -1
            continueRoutine = True
            routineTimer.add(1.000000)
            # update component parameters for each repeat
            ONR.setOpacity(1)
            ONR2.setOpacity(1)
            # keep track of which components have finished
            ONRightComponents = [ONR, image, ONR2, image_rev]
            for thisComponent in ONRightComponents:
                if hasattr(thisComponent, 'status'):
                    thisComponent.status = NOT_STARTED
            
            # -------Start Routine "ONRight"-------
            while continueRoutine and routineTimer.getTime() > 0:
                # get current time
                t = ONRightClock.getTime()
                frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
                # update/draw components on each frame
                
                # *image_rev* updates
                if t >= 0 and image_rev.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    image_rev.tStart = t
                    image_rev.frameNStart = frameN  # exact frame index
                    image_rev.setAutoDraw(True)
                frameRemains = 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if image_rev.status == STARTED and t >= frameRemains:
                    image_rev.setAutoDraw(False)
                    
                # *ONR* updates
                if t >= 0.0 and ONR.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    ONR.tStart = t
                    ONR.frameNStart = frameN  # exact frame index
                    ONR.setAutoDraw(True)
                frameRemains = 0.0 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if ONR.status == STARTED and t >= frameRemains:
                    ONR.setAutoDraw(False)
                
                # *image* updates
                if t >= 0.5 and image.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    image.tStart = t
                    image.frameNStart = frameN  # exact frame index
                    image.setAutoDraw(True)
                frameRemains = 0.5 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if image.status == STARTED and t >= frameRemains:
                    image.setAutoDraw(False)
                
                # *ONR2* updates
                if t >= 0.5 and ONR2.status == NOT_STARTED:
                    # keep track of start time/frame for later
                    ONR2.tStart = t
                    ONR2.frameNStart = frameN  # exact frame index
                    ONR2.setAutoDraw(True)
                frameRemains = 0.5 + 0.5- win.monitorFramePeriod * 0.75  # most of one frame period left
                if ONR2.status == STARTED and t >= frameRemains:
                    ONR2.setAutoDraw(False)
                
                # check if all components have finished
                if not continueRoutine:  # a component has requested a forced-end of Routine
                    break
                continueRoutine = False  # will revert to True if at least one component still running
                for thisComponent in ONRightComponents:
                    if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                        continueRoutine = True
                        break  # at least one component has not yet finished
                
                # check for quit (the Esc key)
                if endExpNow or event.getKeys(keyList=["escape"]):
                    core.quit()
                
                if event.getKeys(keyList=[trigger]): 
                    volume +=1
                    print volume 
                
                # refresh the screen
                if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                    win.flip()
            
            # -------Ending Routine "ONRight"-------
            for thisComponent in ONRightComponents:
                if hasattr(thisComponent, "setAutoDraw"):
                    thisComponent.setAutoDraw(False)
            thisExp.nextEntry()
            
        # completed 10 repeats of 'trials_2'
        
        # get names of stimulus parameters
        if trials_2.trialList in ([], [None], None):
            params = []
        else:
            params = trials_2.trialList[0].keys()
        # save data for this loop
        trials_2.saveAsExcel(filename + '.xlsx', sheetName='trials_2',
            stimOut=params,
            dataOut=['n','all_mean','all_std', 'all_raw'])
        
        # ------Prepare to start Routine "Rest"-------
        t = 0
        RestClock.reset()  # clock
        frameN = -1
        continueRoutine = True
        routineTimer.add(20.000000)
        # update component parameters for each repeat
        # keep track of which components have finished
        RestComponents = [REST]
        for thisComponent in RestComponents:
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        
        # -------Start Routine "Rest"-------
        while continueRoutine and routineTimer.getTime() > 0:
            # get current time
            t = RestClock.getTime()
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *REST* updates
            if t >= 0.0 and REST.status == NOT_STARTED:
                # keep track of start time/frame for later
                REST.tStart = t
                REST.frameNStart = frameN  # exact frame index
                REST.setAutoDraw(True)
                print  expClock.getTime()  # start cycle.`
            frameRemains = 0.0 + 20- win.monitorFramePeriod * 0.75  # most of one frame period left
            if REST.status == STARTED and t >= frameRemains:
                REST.setAutoDraw(False)
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in RestComponents:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # check for quit (the Esc key)
            if endExpNow or event.getKeys(keyList=["escape"]):
                core.quit()
                            
            if event.getKeys(keyList=[trigger]): 
                volume +=1
                print volume
                    
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "Rest"-------
        for thisComponent in RestComponents:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
# completed 3 repeats of 'EPOCH'


# ------Prepare to start Routine "end"-------
t = 0
endClock.reset()  # clock
frameN = -1
continueRoutine = True
routineTimer.add(1.000000)
# update component parameters for each repeat
# keep track of which components have finished
endComponents = [end2]
for thisComponent in endComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

# -------Start Routine "end"-------
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = endClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *end2* updates
    if t >= 0.0 and end2.status == NOT_STARTED:
        # keep track of start time/frame for later
        end2.tStart = t
        end2.frameNStart = frameN  # exact frame index
        end2.setAutoDraw(True)
    frameRemains = 0.0 + 1.0- win.monitorFramePeriod * 0.75  # most of one frame period left
    if end2.status == STARTED and t >= frameRemains:
        end2.setAutoDraw(False)
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in endComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
print expClock.getTime()

# -------Ending Routine "end"-------
for thisComponent in endComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
# these shouldn't be strictly necessary (should auto-save)
thisExp.saveAsPickle(filename)
logging.flush()
# make sure everything is closed down
thisExp.abort()  # or data files will save again on exit
win.close()
core.quit()
