function complot(x)
%   complot(x): (COMplex data PLOT)
%   Plots the absolute values of the array x, after squeezing the array in
%   case of empty dimensions. Requires exactly 2 non-empty dimensions.
%   matthijs.debuck@ndcn.ox.ac.uk

    figure, imagesc(abs(squeeze(x))), colormap hot, axis equal%, axis off
    caxis([0.04 1]*prctile(abs(x(:)),99.9))
end

