function img = Sk2img(S, k, nfft)
% img = Sk2img(S,k,nfft)
% Returns image space from k-space and sensitivity maps (single image, for
% all recieve channels combined, returned).
% nfft = 2 only ifft's the first 2 dims (for stack of 2D-k-space data)
%   matthijs.debuck@ndcn.ox.ac.uk

if ndims(S) == 5    %quickfix for >1 eSPIRiT-maps 
    S = S(:,:,:,:,1);
end

if size(S) ~= size(k)
    error('Matrix sizes of S and k should be the same')
end

if ~exist('nfft','var')
    nfft = 3;
end

img_initial = ifftdim(k, 1:nfft);

img = sum(img_initial.*conj(S),nfft+1)./sum(S.*conj(S),nfft+1);
    
end

