function [Name, DataPath] = pda_uigetfile(PathName,Title)

% Works the same as uigetfile but will remember where you last looked.
%
% Inputs:
%   PathName - Name of the variable that the path will be saved in.
%   Title    - The title displayed in the file browser window.

if nargin < 2
    Title = 'Select File';
end

if nargin < 1
    PathName = 'DefaultSearchPath';
end

if exist(strcat(PathName,'.mat')) == 2
    load(PathName);
    if DataPath ~= 0
        [Name,DataPath] = uigetfile('*',Title,DataPath);
    else
        [Name,DataPath] = uigetfile('*',Title);
    end
else
    [Name,DataPath] = uigetfile('*',Title);
end


save(PathName,'DataPath');
