function [MR_MILabs_Reg,data] = pda_Register_MR_2_MILabs(MR_Volume,mr_voxdim,CT_Volume,ct_voxdim,Crop)

if nargin < 5
    Crop = true;
end


data.Crop = Crop;

[MR_Volume] = pda_Transform_MR_2_MILabs(MR_Volume);

if Crop
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Pre-Crop CT Volume
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    figure, imagesc(max(CT_Volume,[],3)); truesize;
    rect = getrect;
    hold on;
    rect = round(rect);
    data.rect = rect;
    save('rect','rect');
    rectangle('Position',rect);

    figure, imagesc(squeeze(max(CT_Volume,[],2))); truesize;
    rect2 = getrect;
    data.rect2 = rect2;
    rect2 = round(rect2);
    save('rect2','rect2');

   
    data.rect = rect;
    data.rect2 = rect2;

    CT_Crop = CT_Volume(rect(2):rect(2)+rect(4),rect(1):rect(1)+rect(3),rect2(1):rect2(1)+ rect2(3));

    figure, imagesc(max(CT_Crop,[],3)); truesize;
    Original_CT = CT_Volume;
    data.Original_CT_Size = size(CT_Volume);
    CT_Volume = CT_Crop;
    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initial Rigid Registration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Register Using Matlab built in function
display('Rigid registration ...');

%mr_voxdim(1) = mr_voxdim(1) .* 0.95;

% Set up optimizer
[optimizer,metric] = imregconfig('multimodal');
data.R_CT  = imref3d(size(CT_Volume),ct_voxdim(1),ct_voxdim(2),ct_voxdim(3));
data.R_MR = imref3d(size(MR_Volume),mr_voxdim(1),mr_voxdim(2),mr_voxdim(3));
optimizer.InitialRadius = 0.0004; 
%optimizer.MaximumIterations = 1000;

%Type = 'rigid';
Type = 'affine';

% Register
data.tform = imregtform(MR_Volume,data.R_MR, CT_Volume,data.R_CT, Type, optimizer, metric);
MR_Reg = imwarp(MR_Volume,data.R_MR,data.tform,'OutputView',data.R_CT);


% Put Cropped MR back into original CT frame of reference
if Crop
    MR_MILabs_Reg = zeros(data.Original_CT_Size);
    MR_MILabs_Reg(rect(2):rect(2)+rect(4),rect(1):rect(1)+rect(3),rect2(1):rect2(1)+ rect2(3)) = MR_Reg;
else
    MR_MILabs_Reg = MR_Reg;
end

display('...done');