function [Array,T] = pda_DCEMRI_CreateBasicParameterMaps(DataPath,Name,TimeLimit,GroupTimeLimit,DCE_Params)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Define Data path and DCE file name
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin < 1
    PathName = 'DCE_Data_Path';
    [Name, DataPath] = pda_uigetfile(PathName,'Select DCE Image Data');
    GroupTimeLimit = 0;
    TimeLimit=0;
    Set_DCE_Params;
end

if nargin < 7
    SliceSelection = false;
else
    SliceSelection = true;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Define file names
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
DCEName = fullfile(DataPath,Name);
MaskName = fullfile(DataPath,'AutoMask.nii');
TimeName = fullfile(DataPath,'T.mat');



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load DCE data 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nii = load_untouch_nii(DCEName);
Volume = squeeze(nii.img);
TimePoints = size(Volume,4);
nii.img = [];
save_nii = nii;
clear nii;
save_nii.hdr.dime.dim(1) = 3; % Set the number of dimensions to 3
save_nii.hdr.dime.dim(5) = 1; % Reduce the now redundant 5th dimension to 1
save_nii.hdr.dime.dim(6) = 1; % Just in case it was straight from the scanner.
Volume = squeeze(Volume);
vol = squeeze(Volume(:,:,:,1));
VolSize = size(vol);
VolLength = length(vol(:));



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load Timing Data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if exist(TimeName)
    load(TimeName);
else
    t = DCE_Params.DCE_TimeInterval;
    T = (1:TimePoints) .* t;
end

% If the timing data is incomplete, pad the remainder with the average of
% the existing timepoints.
if length(T) < TimePoints
    remainder = TimePoints - length(T);
    Interval = mean(diff(T));
    lastT = ((1:remainder) .* Interval) + T(end);
    T = [T,lastT];
end


%InjectionTime = T(10);
InjectionTime = T(DCE_Params.DCE_InjectionPoint);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load Whole body mask
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nii = load_untouch_nii(MaskName);
SampleMask = nii.img;
nii.img = [];

% Fill any holes

for i = 1:size(SampleMask,3)
    SampleMask(:,:,i) = imfill(SampleMask(:,:,i),'holes');
end
for i = 1:size(SampleMask,2)
    SampleMask(:,i,:) = imfill(SampleMask(:,i,:),'holes');
end
for i = 1:size(SampleMask,1)
    SampleMask(i,:,:) = imfill(SampleMask(i,:,:),'holes');
end
SampleIndex = find(SampleMask > 0);
BackGroundIndex = find(SampleMask == 0);
clear SampleMask;





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Create an array of time courses
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Array = zeros(length(vol(:)),TimePoints);
for i = 1:TimePoints
    vol = squeeze(Volume(:,:,:,i));
    Array(:,i) = vol(:);
end
%SubSampleArray to correspond to sample 
BackGroundArray = Array(BackGroundIndex,:);
Array = Array(SampleIndex,:);


clear Volume;
clear vol;


ArrayFull = Array;
TFull = T;
% Apply Group Time limit if it has been set
if GroupTimeLimit > 0
    Ttemp = T;
    GroupTimeLimit = GroupTimeLimit + InjectionTime;
    [ Array,T ] = pda_DCE_ArrayInterp( Array,T,GroupTimeLimit );
end

TimePoints = length(T);





% Create baseline based on pre-injection data points
BaseLine = mean(Array(:,1:DCE_Params.DCE_InjectionPoint-1),2);
BaseLine = repmat(BaseLine,1,TimePoints);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Determine which voxels did not enhance
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    
%tic
display('NonEn...');
%SubArray = Array(TumourIndex,:);
NonEn = zeros(size(Array,1),1);
EnFactor = NonEn;

Limit = DCE_Params.DCE_InjectionPoint-2;
StdArray = std(Array(:,1:Limit),[],2);
StdArrayBack = std(BackGroundArray,[],2);
MeanStd = mean(StdArray); % Tumour noise
%MeanStd = mean(StdArrayBack); % Background noise
save('MeanStd','MeanStd');


for i = 1:size(Array,1)
    Signal = Array(i,:);

    MeanSignal = mean(Signal(1:Limit));
    StdSignal = MeanStd; % Global Sd for whole tumour

    % Apply averaging filter to signal to smooth out noise
    h = ones(10,1) ./ 10;
    Signal = filter(h,1,Signal);

    MaxSignal = max(Signal);
    MaxFactor = (MaxSignal - MeanSignal) / StdSignal;
    EnFactor(i) = MaxFactor;
    if MaxSignal < (MeanSignal + (3 * StdSignal))
        NonEn(i) = 1;
    end
end

% Subtract Baseline
Array = Array - BaseLine;
Array_En = (Array) ./ BaseLine; % Remember - 'BaseLine has already been subtracted.
Array(Array < 0) = 0;
Array_En(Array_En < 0) = 0;

% Apply Time limit for IAUC if it has been set
if TimeLimit > 0
    TimeLimit = TimeLimit + InjectionTime;
    [ subArray,subT ] = pda_DCE_ArrayInterp( Array,T,TimeLimit );
    [ subArray_En,subT ] = pda_DCE_ArrayInterp( Array_En,T,TimeLimit );
end
   
% Calculate time and height of maximum
[PeakMax,PeakMax_index] = max(Array,[],2);


% Calculate Area under curve and first moment

AUC = trapz(T',Array')';
AUC_En = trapz(T',Array_En')';
subAUC = trapz(subT',subArray');
subAUC_En = trapz(subT',subArray_En');

Time = T - T(DCE_Params.DCE_InjectionPoint);
Time = Time(DCE_Params.DCE_InjectionPoint:end);
PostInjection_Array = Array(:,DCE_Params.DCE_InjectionPoint:end);
TArray = repmat(Time,size(PostInjection_Array,1),1);
y = PostInjection_Array .* TArray;
Moment = trapz(Time',y')';



AUC_Array = repmat(AUC,1,TimePoints);

% % Create AUC Volume
% save_nii.img = zeros(VolSize);
% save_nii.img(SampleIndex) = AUC;
% save_untouch_nii(save_nii,fullfile(DataPath,'AUC.nii'));



% Create subAUC Volume
if TimeLimit > 0
    save_nii.img = zeros(VolSize);
    save_nii.img(SampleIndex) = subAUC;
    save_untouch_nii(save_nii,fullfile(DataPath,strcat('iAUC',num2str(TimeLimit-InjectionTime),'.nii')));
end







