function [DataPath] = pda_uigetdir(PathName,Title)

% Works the same as uigetdir but will remember where you last looked.
%
% Inputs:
%   PathName - Name of the variable that the path will be saved in.
%   Title    - The title displayed in the file browser window.

if nargin < 2
    Title = 'Select Folder';
end

if nargin < 1
    PathName = 'DefaultSearchPath';
end

if exist(strcat(PathName,'.mat')) == 2
    load(PathName);
    if DataPath ~= 0
        [DataPath] = uigetdir(DataPath,Title);
    else
        [DataPath] = uigetdir([],Title);
    end
else
    [DataPath] = uigetdir([],Title);
end


save(PathName,'DataPath');
