function pda_save_nii(vol,vol_dim,filename,Bits,hist)

if nargin < 4
    Bits = 0;
end

switch Bits
    case 1 % nifti doesn't support logical
        vol = uint8(vol);
    case 8
        vol = pda_imnorm(vol);
        vol = uint8(vol .* (2^8));
    case 16
        vol = pda_imnorm(vol);
        vol = uint16(vol .* (2^16));
    case 32
        vol = pda_imnorm(vol);
        vol = uint32(vol .* (2^32));
    case {'mask','Mask'}
        vol = uint8(vol);
end
        

nii = make_nii(vol);
nii.hdr.dime.pixdim(2) = vol_dim(1);
nii.hdr.dime.pixdim(3) = vol_dim(2);
nii.hdr.dime.pixdim(4) = vol_dim(3);

if nargin > 4
    nii.hdr.hist = hist;
end

save_nii(nii,filename);

