function [T,UT] = pda_Read_K0_Times2(FileName)
% Read the unix time stamps in the K0 time file

f = fopen(FileName,'r');
%line = 'blah';
line = fgetl(f); % Skip first line
count = 1;
while ischar(line)
    line = fgetl(f);
    if ischar(line)
        %display(line);
        where = find(line == ' ');
        unix_time(count) = str2num(line(where(4):end));
        %display(unix_time(count));
    end
    count = count + 1;
end

% Get rid of duplicates
time = unique(unix_time);

% Weed out times only different by one
tgap = diff(time);
index = zeros(length(time),1);
index(tgap==1) = 1;
UT = time(index < 1);
T = UT - UT(1);
fclose(f);