function pda_DCEMRI_CreateAverageVol(DataPath,Name,DCE_Params,Thresh)

if(nargin < 2)
    PathName = 'DCE_Data_Path';
    [Name, DataPath] = pda_uigetfile(PathName,'Select DCE Image Data');
    DCE_Params.DCE_InjectionPoint = 11;
    ImageName = fullfile(DataPath,Name);
else
    ImageName = fullfile(DataPath,Name);
end

if(nargin <4)
    Thresh = 0.1;
end

[DCE,voxdim,hdr] = pda_load_nii(ImageName);

% Mean Volume
MeanVol = mean(squeeze(DCE),4);
pda_save_nii(MeanVol,voxdim,fullfile(DataPath,'Mean_DCE.nii'),8,hdr.hist);


MeanVol = MeanVol - min(MeanVol(:));
MeanVol = MeanVol ./ max(MeanVol(:));

SampleMask = zeros(size(MeanVol));
SampleMask(MeanVol > Thresh) = 1;


SampleMask = pda_imfill3D(SampleMask);
pda_save_nii(SampleMask,voxdim,fullfile(DataPath,'AutoMask.nii'),1);

    
