set term epslatex color standalone font 14 dl 4 header '\usepackage{xcolor,amsmath} \definecolor{royalblue}{cmyk}{1, 0.50, 0, 0}'
set style line 1 lt 1 lc rgb "black" lw 5
set style line 2 lt 2 lc rgb "dark-red" lw 5
set style line 3 lt 5 lc rgb "dark-green" lw 5
set style line 4 lt 4 lc rgb "dark-blue" lw 5


set style line 11 lt 1 lc rgb "dark-blue" lw 2
set style line 12 lt 2 lc rgb "red" lw 2

#set style fill transparent solid 0.2

set pointsize 1.5
set bars 2

set border lw 2.5

#set size 0.75,1.4
#set origin 0,0

#set size ratio 0.65 0.75
set size ratio 0.65 0.75

set lmargin 4.5
set rmargin 0.5

set tmargin 1.5
set bmargin 3

set format "$%g$"

#
# Constants 
#
# Ion size in nm
a=0.5
#
# Thermal voltage
VT = 0.026
# In Single Layer (sl-min, sl-dyna, etc)
# one has v = V/VT, hence V = v * VT
# Helmholtz capapcitance at a=1 nm and er = 1
CH = 1.77
# Relative dielectric constant
er = 2
CH1 = CH * er / a


