load '../style.gp'
set out "phobicity.tex"

set size .7,0.75
#set multiplot layout 2,1

set macros
set format "$%g$"

#
# Left upper
#
set size 0.75,0.7
set origin 0,0.0

# y axis
set ylabel 'ion density ($d^2\rho$)' offset 0.5
set ytics 1 offset 0.4
set mytics 2

# x axis
set xlabel '$\delta E / k_BT$ (ionophobicity $\rightarrow$)' offset 0,0.5
set xlabel 'resolvation energy ($\delta E / k_BT$)' offset 0,0.5
set xtics 10
set mxtics 2

unset key
d=0.5
set label '{\small $d=0.5$nm}' at 10,1.3
#set label '{\small \color{red!50!black}strongly ionophilic}' at 0.63/d,14
#set label '{\footnotesize \color{blue!50!black}ionophobic}' at 0.84/d,52
#set label '{\footnotesize \color{blue!50!black}weakly}' at 0.82/d,61

set label '\textsf{ionophilic}' at 3,0.5
set label '\textsf{ionophobic}' at 37,1.2 rotate by -90


#set label '{\small ionophobic}' at 0.67,10
#set arrow from 0.67,13 to 0.67,22

#set label '(a)' at 0.84/d,93

set label '\small \color{blue!50!black}0.6nm' at 30,0.7 rotate by -75
set label '\small \color{orange}0.7nm' at 21,0.6 rotate by -75

#Bjerrum length
LB = 25
rho1 = LB * log (2) / 0.6
rho2 = LB * log (2) / 0.7

set arrow nohead from rho2,0 to rho2,1.5 lt 2 lc rgb "orange" lw 2
set arrow nohead from rho1,0 to rho1,1.5 lt 5 lc rgb "dark-blue" lw 2

plot [:] [:1.5] \
	'data/a0.5_l0.6_LB25.dat' u ($1):(($2+$3)) w l lt 5 lc rgb "dark-blue" lw 5 title '', \
	'data/a0.5_l0.7_LB25.dat' u ($1):(($2+$3)) w l lt 2 lc rgb "orange" lw 5 title ''

#	rho1,t w l lt 5 lc rgb "dark-green" lw 2, \

