load '../style.gp'
set out "cap_LD.tex"

set size 1.4,0.75
set multiplot layout 2,1

set macros
set format "$%g$"

#
# Left
#
set size 0.75,0.7
set origin 0,0

# y axis
set ylabel '\small capacitance, $C_D(0)$ ($\mu F$/cm$^2$)' offset 0.5
set ytics 5
set mytics 5

# x axis
set xlabel 'pore width ($L/d$)' offset 0,0.5
set xtics 0.5
set mxtics 5

unset key

#set label '{\small $d=0.5$nm}' at 0.63,9.5

#set label '{\small ionophilic}' at 0.88,26
#set arrow from 0.88,23 to 0.88,15

#set label '{\small ionophobic}' at 0.67,10
#set arrow from 0.67,13 to 0.67,22

set label '\small $0.7$nm' at 1.2,7

set label '(a)' at 1.95,18
set label '\textsf{strongly ionophilic}' at 1.6,22 center front

plot [1.07:2.1] [5:] \
	'data/d7/Cap_V0.dat' u ($1/0.7):($2) w lp ls 2 pt 5 title ''

#	'data/d5/R0_V0.dat' u ($1/5):($3) w lp ls 2 title '', \
#	'data/d6/R0_V0.dat' u ($1/6):($3) w lp ls 4 title ''

#
# Inset
#
set size 0.4
#set origin 0.1,0.27
set origin 0.15,.25

set format '{\scriptsize $%g$}'

unset label
unset arrow
unset key

set ylabel '{\scriptsize $\eta_{3D}$}' offset 5.5
set ytics 0.2 offset 0.0
set mytics 2

set xlabel '{\scriptsize pore width}' offset 0,1.4
#set format x ""
set xtics 0.5 offset 0,0.5
#set mxtics 5

#set label '{\scriptsize $L/d=1.4$}' at 0.56,10

plot [1.1:2.1] [0:0.5] \
	'data/d7/R0_V0.dat' u ($1/7):($2+$4) w lp ls 2 pt 5 title ''

#	'data/d5/R2000.dat' u ($1/5):($2+$4) w lp ls 2 title '', \
#	'data/d6/R0.dat' u ($1/6):($2+$4) w lp ls 4 title ''

#	'data/a0.5_LB25_S10.dat' u ($2):(a*($8+$9)/$2) w l ls 2 lw 2 title ''

#	'data/a0.5_LB25_S10.dat' u ($2):(a*($8+$9)/$2) w l ls 2 title '', \
#	'data/a0.5_LB25_S25.dat' u ($2):(a*($8+$9)/$2) w l ls 4 title ''

#
# Right
#
set size 0.75,0.7
set origin 0.7,0
set format "$%g$"

# y axis
set ylabel '\small capacitance, $C_D(0)$ ($\mu F$/cm$^2$)' offset 0.5
set ytics 10
set mytics 2

# x axis
set xlabel 'pore width ($L/d$)' offset 0,0.5
set xtics 0.5 offset 0
set mxtics 5

unset key

#set label '{\small $d=0.5$nm}' at 0.63,9.5

#set label '{\small ionophilic}' at 0.88,26
#set arrow from 0.88,23 to 0.88,15

#set label '{\small ionophobic}' at 0.67,10
#set arrow from 0.67,13 to 0.67,22

set label '(b)' at 1.95,34
set label '{\small $0.5$nm}' at 1.85,10.1
set label '{\small $0.6$nm}' at 1.28,18
set label '\textsf{weakly ionophobic}' at 1.6,42 center front

plot [1.08:2.1] [8:38] \
	'data/d5/R12500_V0.0.dat' u ($1/5):($3) w lp ls 3 title '', \
	'data/d6/R10900_V0.dat' u ($1/6):($3) w lp ls 4 title ''

#
# Inset
#
set size 0.4
#set origin 0.1,0.27
set origin 0.87,.27

set format '{\scriptsize $%g$}'

unset label
unset arrow
unset key

set ylabel '{\scriptsize $\eta_{3D}$}' offset 5.5
set ytics 0.2 offset 0.0
set mytics 2
set xlabel '{\scriptsize pore width}' offset 0,1.4
set xtics 0.5 offset 0,0.5
set mxtics 5

plot [1.1:2.1] [:] \
	'data/d5/R12500.dat' u ($1/5):($2+$4) w lp ls 3 title '', \
	'data/d6/R10900.dat' u ($1/6):($2+$4) w lp ls 4 title ''

#	'data/d5/R12500.dat' u ($1/10):(($2+$4)) w lp ls 2 title '', \
#	'data/d5/R12650.dat' u ($1/10):(($2+$4)) w lp ls 4 title ''

#	'data/a0.5_LB25_S10.dat' u ($2):(a*($8+$9)/$2) w l ls 2 lw 2 title ''

#	'data/a0.5_LB25_S10.dat' u ($2):(a*($8+$9)/$2) w l ls 2 title '', \
#	'data/a0.5_LB25_S25.dat' u ($2):(a*($8+$9)/$2) w l ls 4 title ''


