load '../style.gp'
set out "trans2.tex"

set size 1.45,2
set multiplot layout 2,3

set macros
set format "$%g$"

#
# Left top plot
#
set size 0.75,0.7
#set origin 0,0
set origin 0,1.3

# y axis
set ylabel '\small capacitance, $C_D$ ($\mu F$/cm$^2$)' offset -0.2
set ytics 10
set mytics 2

# x axis
set xlabel 'voltage (V)' offset 0,0.5
set xtics 1
set mxtics 5

unset key
#set key noreverse at 128,8

set label '{\small ionophilic}' at 0.7,33
set arrow from 0.7,30 to 0.8,21

set label '{\small ionophobic}' at 0.7,5
set arrow from 0.7,8 to 0.65,13

set label '(a)' at 1.9,40
set label 'continuous' at 1.3,30
set label 'charging' at 1.4,25

plot [:2.2] [0:45] \
	'data/a0.5_l08_LB25_S32.dat' u ($1*VT):($2*CH1) w l ls 3 title '$\delta E = 32 k_BT$ (phobic)',\
	'data/a0.5_l08_LB25_S10.dat' u ($1*VT):($2*CH1) w l ls 2 title '$\delta E = 10 k_BT$ (philic)'

#
# Left bottom plot
#
set size 0.75,0.7
#set origin 0,0.65
set origin 0,0

unset label
unset arrow
unset key

# y axis
set ylabel 'voltage (V)' offset 1
set ytics 0.5
set mytics 5

# x axis
set xlabel '$\delta E / k_BT$ (ionophobicity $\rightarrow$)' offset 0,0.5
set xtics 5
set mxtics 5

set label '(e)' at 23,1.17

#set label '\textsf{\small counterion deficient}' at 14,1.15
set label '\textsf{\small coion-deficient}' at 15,1.15
set label '\textsf{\small phase}' at 17,1.03

#set label '\textsf{\small counterion rich}' at 11,0.3
#set label '\textsf{\small phase}' at 13,0.2
set label '\textsf{\small coion-rich phase}' at 11,0.2


set label '$0.7$nm' at 21,0.7
set arrow from 23,0.6 to 22,0.4

set label '$0.8$nm' at 12,0.53
set arrow from 14,0.6 to 14.5,0.78

plot [:25] [0:1.3] \
	'data/a0.5_l08_LB25.dat' u 1:($2*VT) w l lt 1 lw 3 lc rgb 'orange' title '$L=0.7$nm',\
	'data/a0.5_l08_LB25_cp.dat' u 1:($2*VT) w p pt 7 lw 3 lc rgb 'orange' title '',\
	'data/a0.5_l07_LB25.dat' u 1:($2*VT) w l lt 1 lw 3 lc rgb 'dark-blue' title '$L=0.6$nm', \
	'data/a0.5_l07_LB25_cp.dat' u 1:($2*VT) w p pt 7 lw 3 lc rgb 'dark-blue' title '', \

#
# Right bottom plot
#
set size 0.75,0.7
#set origin 0.7,0.65
set origin 0.7,0

unset label
unset arrow
unset key

# y axis
set ylabel 'hysteresis loss ($\%$)' offset -0.7
set ytics 1
set mytics 5

# x axis
set xlabel '$\delta E / k_BT$ (ionophobicity $\rightarrow$)' offset 0,0.5
set xtics 5
set mxtics 5

set label '(f)' at 10.5,1.4

set label '$0.8$nm' at 11,0.8
set arrow from 13,0.7 to 15,0.45

set label '$0.7$nm' at 21.3,0.6
set arrow from 22.8,0.5 to 23,0.22

plot [:25] [0:1.6] \
	'data/a0.5_l07_LB25.dat' u 1:(100*$3/$4) w l lt 1 lw 3 lc rgb 'dark-blue' title '$L=0.6$nm', \
	'data/a0.5_l08_LB25.dat' u 1:(100*$3/$4) w l lt 1 lw 3 lc rgb 'orange' title '$L=0.8$nm'

#
# Right top plot
#
set size 0.75,0.7
#set origin 0.7,0
set origin 0.7,1.3

unset label
unset arrow
unset key

# y axis
set ylabel '\small capacitance, $C_D$ ($\mu$F/cm$^2$)' offset -0
set ytics 10
set mytics 2

# x axis
set xlabel 'voltage (V)' offset 0,0.5
set xtics 0.5
set mxtics 5

set label '(b)' at 0.05,35
set label '{\small weakly ionophilic}' at 0.7,6

set arrow from 0.42,15 to 0.4,20 ls 1 lc rgb 'royalblue'
set arrow from 0.55,22 to 0.56,17 ls 1 lc rgb 'orangered'

set label 'hysteretic' at 0.61,30
set label 'charging' at 0.635,25

plot [:1.1] [0:40] \
	'data/a0.5_l08_LB25_S18_bck.dat' u ($1*VT):($2*CH1) w l lt 4 lw 3 lc rgb 'royalblue' title '', \
	'data/a0.5_l08_LB25_S18_adv.dat' u ($1*VT):($2*CH1) w l lt 4 lw 3 lc rgb 'orangered' title '', \
	'data/a0.5_l08_LB25_S18.dat' u ($1*VT):($2*CH1) w l ls 1 title '',

#
# Middle left plot
#
#set size 0.75,0.7
#set origin 0,0.55
set size 0.75,0.7
#set origin 0.7,0
set origin 0.0,0.65

# y axis
set ylabel '{coions ($d^2\rho_+$)}' offset 1,-0
set ytics 0.2 offset 0.0
set mytics 2

# x axis
set xlabel 'voltage (V)' offset 0,0.5
set xtics 0.1 offset 0,0
set mxtics 2

unset key 
unset label

set arrow from 0.44,0.05 to 0.435,0.2 ls 1 lc rgb 'royalblue'
set arrow from 0.511,0.19 to 0.515,0.04 ls 1 lc rgb 'orangered'

set label '\textsf{\color[rgb]{0.254902,0.411765,0.882353} \small  coion-rich}' at 0.35,0.15
set label '\textsf{\color[rgb]{0.254902,0.411765,0.882353}  \small  phase}' at 0.37,0.11

set label '\textsf{\color{orange} \small coion-deficient}' at 0.49,0.25
set label '\textsf{\color{orange} \small phase}' at 0.52,0.21

set label '(c)' at 0.56,0.3

Vtr=18.65
set arrow nohead from Vtr*VT,-0.02 to Vtr*VT,0.35 lt 2 lw 1 lc rgb 'black'

#plot [16*VT:20.5*VT] [:] 
plot [13*VT:23*VT] [-0.02:0.35]  \
	'data/a0.5_l08_LB25_S18_bck.dat' u ($1*VT):($5) w l lt 4 lw 3 lc rgb 'royalblue' title '', \
	'data/a0.5_l08_LB25_S18_adv.dat' u ($1*VT):($5) w l lt 4 lw 3 lc rgb 'orangered' title '', \
	'data/a0.5_l08_LB25_S18.dat' u ($1*VT):($5) w l ls 1 title '',

unset multiplot

#
# Middle right plot
#
#set size 0.75,0.7
#set origin 0,0.55
set size 0.75,0.7
#set origin 0.7,0
set origin 0.7,0.6

unset label
unset arrow
unset key

set linetype 1 lc rgb "white" lw 1
set linetype 2 lc rgb "white" lw 1
set linetype 3 lc rgb "white" lw 1
set linetype 4 lc rgb "white" lw 1
#set linetype 5 lc rgb "white" lw 1
#set linetype 6 lc rgb "white" lw 1
#set linetype 7 lc rgb "white" lw 1
#set linetype 8 lc rgb "white" lw 1
#set linetype 9 lc rgb "white" lw 1

#set dgrid3d 50,50 qnorm 2
set isosamples 500
set pm3d interpolate 5,5
set view map

set contour both
#set cntrparam level discrete 20, 30, 40
#set cntrparam level discrete (-6.65)
set cntrparam level discrete -6.64, -6.65

#set cntrparam bspline
set cntrparam cubicspline

set xlabel 'coions ($d^2\rho_+$)' offset 0,1
set xtics 0.1 offset 0,0.5
set xtics nomirror
set mxtics 2

set ylabel 'counterions ($d^2\rho_-$)' offset -1
set ytics 0.1
set ytics nomirror
set mytics 2

set tics out

set cbrange [-6.7:-6.1]
set cbtics  (-6.8, -6.6, -6.4, -6.2, -6)
#set cbtics  (-6.7, -6.6)
#set cbmtics  2
set colorbox
unset key

#set label '(b)' at 0.5,1.65
set label '(d)' at 0.,0.63

set label 'free energy ($k_BT/d^2$)' at 0.23,0.63 center front

set label '\small \color{white} coion-rich' at 0.11,0.58 center front 
set label '\small \color{white} phase' at 0.12,0.56 center front 
set arrow head from 0.15,0.565 to 0.2,0.56  lc rgb 'white' front

set label '\small \color{white} coion-deficient' at 0.11,0.44 center front 
set label '\small \color{white} phase' at 0.09,0.42 center front 
set arrow head from 0.06,0.42 to 0,0.44  lc rgb 'white' front

#splot [0.5:] [0.5:1.4] 'data/LB25_S10.dat' u 2:4:($5*CH*er/$2) w pm3d title ''
splot [:0.241] [:0.59] []  'data/TEST_V19.dat' u 1:2:($5) w pm3d title ''

