load '../style.gp'
set out "capen_pore3.tex"

set size 1.4,0.75
set multiplot layout 2,1

set macros
set format "$%g$"

#
# Left upper
#
set size 0.75,0.7
set origin 0,0.0

# y axis
set ylabel '\small capacitance, $C_D(0)$ ($\mu F$/cm$^2$)' offset 0.5
set ytics 30
set mytics 3

# x axis
set xlabel 'pore width ($L/d$)' offset 0,0.5
set xtics 0.2
set mxtics 2

unset key
d=0.5
#set label '{\small $d=0.5$nm}' at 0.59,16
set label '{\small \color{red!50!black}strongly ionophilic}' at 0.63/d,14
set label '{\footnotesize \color{blue!50!black}ionophobic}' at 0.84/d,52
set label '{\footnotesize \color{blue!50!black}weakly}' at 0.82/d,61

#set label '{\small ionophilic}' at 0.88,26
#set arrow from 0.88,23 to 0.88,15

#set label '{\small ionophobic}' at 0.67,10
#set arrow from 0.67,13 to 0.67,22

set label '(a)' at 0.84/d,93

plot [0.5/d:0.9/d] [0:105] \
	'data/mft/a0.5_LB25_S10.dat' u ($2/d):($4*CH1) w l ls 2 title '', \
	'data/mft/a0.5_LB25_S25.dat' u ($2/d):($4*CH1) w l ls 4 title ''

#
# Inset
#
set size 0.39
#set origin 0.1,0.27
set origin 0.1,0.27

set format '{\scriptsize $%g$}'

unset label
unset arrow
unset key
set ylabel '{\scriptsize $d^2\rho_{tot}$}' offset 4.2
set ytics 1 offset 0.4
set mytics 2

set xlabel '{\scriptsize pore width}' offset 0,1.4
set xtics 0.5 offset 0,0.5
set mxtics 5

#set label '{\scriptsize $L/d=1.4$}' at 0.56,10

plot [0.5/d:0.9/d] [:1.5] \
	'data/mft/a0.5_LB25_S10.dat' u ($2/d):(($8+$9)) w l ls 2 title '', \
	'data/mft/a0.5_LB25_S25.dat' u ($2/d):(($8+$9)) w l ls 4 title ''

#	'data/a0.5_LB25_S10.dat' u ($2):(a*($8+$9)/$2) w l ls 2 lw 2 title ''

#	'data/a0.5_LB25_S10.dat' u ($2):(a*($8+$9)/$2) w l ls 2 title '', \
#	'data/a0.5_LB25_S25.dat' u ($2):(a*($8+$9)/$2) w l ls 4 title ''


#
# Right
#
set size 0.75,0.7
set origin 0.7,0
set format "$%g$"

set ylabel 'energy ($\mu J$/cm$^2$)' offset 0.5
set ytics 10 offset 0
set mytics 2

set xlabel '{voltage (V)}' offset 0,0.5
set xtics 1 offset 0,0
set mxtics 2

set label '\small $L/d=1.5$' at 0.5,35

set label '(b)' at 2.5,43
#set label '\small voltage: 2V' at 1.07,30

plot [:3.5] [:49] \
	'data/mft/a0.5_LB25_S10_l0.75.dat' u ($2):(-$8) w l ls 2 title '', \
	'data/mft/a0.5_LB25_S25_l0.75.dat' u ($2):(-$8) w l ls 4 title ''


#
# Inset
#
set size 0.4
#set origin 0.1,0.27
#set origin 0.78,.25
set origin 1.0,0.08

set format '{\scriptsize $%g$}'

set ylabel '{\scriptsize energy}' offset 4.7,-0.5
set ytics 1 offset 0.5
set mytics 2

set xlabel '{\scriptsize voltage}' offset 0,1.5
#set format x ""
set xtics 0.2 offset 0,0.5
set mxtics 2

#set label '{\scriptsize $L/d=1.5$}' at 1.5,45

plot [:.5] [:2.5] \
	'data/mft/a0.5_LB25_S10_l0.75.dat' u ($2):(-$8) w l ls 2 title '', \
	'data/mft/a0.5_LB25_S25_l0.75.dat' u ($2):(-$8) w l ls 4 title ''


