load '../style.gp'
set out "cap_ion.tex"

set size 2.2,0.75
set multiplot layout 3,1

set macros
set format "$%g$"

#
# Right upper plot
#
set size 0.75,0.7
set origin 0.0,0.0

set format "$%g$"
unset label
unset arrow
unset key
unset xtics

set ylabel '\small capacitance, $C_D(0)$ ($\mu F$/cm$^2$)' offset 0.5
set ytics 30
set mytics 3

set xlabel '{ion diameter, $d$ (nm)}' offset 0,0.5
set xtics 0.1 
set mxtics 2

set label '{\small $L/d=1.2$}' at 0.6,7

set label '{\small \color{blue!50!black}weakly}' at 0.67,57
set label '{\small \color{blue!50!black}ionophobic}' at 0.69,50

#set arrow from 0.49,90 to 0.47,75 

set label '{\small  \color{red!50!black}strongly ionophilic}' at 0.54,20

set label '(a)' at 0.71,72.5

plot [0.45:0.75] [:80] \
	'data/L1.2_LB25_S10.dat' u ($3):($4*CH*er/$3) w l ls 2 title '', \
	'data/L1.2_LB25_S25.dat' u ($3):($4*CH*er/$3) w l ls 4 title ''

#	'data/L2a1.4_LB28_dE33.dat' u ($3):($4*CH*er/$3) w l ls 3 title ''

#
# Inset
#
set size 0.39,0.35
set origin 0.08,0.31

set ylabel '\scriptsize $C_D(0)$' offset 5.3,0
unset ytics
set ytics 100 offset 0.65 nomirror
set mytics 2
set format y '\scriptsize $%g$'

set xlabel '\scriptsize $d$ (nm)' offset 0,1.7
unset xtics
set xtics 0.2 offset 0,0.7 nomirror
set mxtics 2
set format x '\scriptsize $%g$'

unset label
set label '\scriptsize $L/d = 1.1$' at 0.5,150 center front

set border 3
plot [:0.55] \
	'data/cap_d_S10.dat' u ($1):($3) w l ls 2 title '',\
	'data/cap_d_S25.dat' u ($1):($3) w l ls 4 title ''

#
# Middle
#
set size 0.9,0.85
set origin 0.65,-0.07

unset label
unset arrow
unset key

unset log xy
set format "$%g$"

set linetype 1 lc rgb "white" lw 1
set linetype 2 lc rgb "white" lw 1
set linetype 3 lc rgb "white" lw 1
set linetype 4 lc rgb "white" lw 1
#set linetype 5 lc rgb "white" lw 1
#set linetype 6 lc rgb "white" lw 1
#set linetype 7 lc rgb "white" lw 1
#set linetype 8 lc rgb "white" lw 1
#set linetype 9 lc rgb "white" lw 1

#set dgrid3d 50,50 qnorm 2
set isosamples 500
set pm3d interpolate 5,5
set view map

set contour both
set cntrparam level discrete 20, 30, 40

#set cntrparam bspline
set cntrparam cubicspline

set xlabel 'ion diameter, $d$ (nm)' offset 0,1
set xtics 0.1 offset 0,0.5
set xtics nomirror
set mxtics 2

#set ylabel '$L/d$' offset 0,0
set ylabel 'pore width, $L$ (nm)' offset 0,0

set ytics 0.3
set ytics nomirror
set mytics 3

set tics out

set cbrange [-2:70]
set cbtics  (20, 40, 60)
#set cbmtics  2
#set colorbox
unset colorbox 
unset key

#set label '(b)' at 0.5,1.65
set label '(b)' at 0.505,1.4
#set label '(b)' at 0.71,1.4

#set label '\small \color{red!50!black}\textsf{strongly ionophilic}' at 0.65,1.35 center front
set label '\textsf{strongly ionophilic}' at 0.66,1.65 center front

set label '{\scriptsize sterically}' at 0.75,0.63 center front
set label '{\scriptsize forbidden}' at 0.75,0.53 center front


#set label 'capacitance ($\mu$C/cm$^2$)' at 0.8,1.65 center front

set border 31

#splot [0.5:] [0.5:1.4] 'data/LB25_S10.dat' u 2:4:($5*CH*er/$2) w pm3d title ''
splot [0.5:] [0.45:1.49] 'data/LB25_S10.dat' u 2:3:($5*CH*er/$2) w pm3d title ''



#
# Right bottom plot
#
set size 0.9,0.85
set origin 1.3,-0.07

unset label
set format "$%g$"

#set dgrid3d 50,50 qnorm 2
set isosamples 500
set pm3d interpolate 5,5
set view map

set contour both
set cntrparam level discrete 15, 40

#set cntrparam bspline
set cntrparam cubicspline

set xlabel 'ion diameter, $d$ (nm)' offset 0,1
set xtics 0.1 offset 0,0.5
set xtics nomirror
set mxtics 2

set ylabel 'pore width, $L$ (nm)' offset 1

set ytics 0.3
set ytics nomirror
set mytics 3


set tics out

#unset colorbox
#set cbtics  (20, 40, 60)
#set cbmtics 2

set colorbox
#set cbrange [0:70]

unset key

#set label 'capacitance ($\mu$F/cm$^2$)' at 0.8,1.6 center front
set label '\small cap. ($\mu$F/cm$^2$)' at 0.84,1.58 center front

#set label '(c)' at 0.75,1.65
set label '(c)' at 0.505,1.4
#set label '(c)' at 0.71,1.4

set label '\textsf{weakly ionophobic}' at 0.66,1.65 center front

#set label '\textsf{weakly ionophobic}' at 0.65,1.9 center front
set label '{\scriptsize sterically}' at 0.75,0.63 center front
set label '{\scriptsize forbidden}' at 0.75,0.53 center front

set border 31

#splot [0.5:] [:1.8] 'data/LB25_S25.dat' u 2:4:($5*CH*er/$2) w pm3d title ''
splot [0.5:] [0.45:1.49] 'data/LB25_S25.dat' u 2:3:($5*CH*er/$2) w pm3d title ''

