function plot_slice_figure(filename)

% function plot_slice_figure(filename)
% >> plot_slice_figure('fig_1a.dat');
% expect file format below 
%x_label= ( Q_h, 0, 0 )  in 1.160 ^{-1}
%y_label= ( 0, 0, Q_l )  in 1.160 ^{-1}
%title= file.dat
%nx= 74
%ny= 61
%ax= -1.27  0.23  -0.62  0.62
%aspect= 0.862063  0.862063  1.25849
%i_min= 0.1
%i_max= 0.8
% x y Intensity Error SmoothedIntensity

if ~exist(filename,'file'), fprintf(2,'%s\ncould not be accessed.\n',filename); return; end
fid=fopen(filename,'rt');  
t=fgetl(fid);x_label=t((length('x_label= ')+1):end);
t=fgetl(fid);y_label=t((length('y_label= ')+1):end);
t=fgetl(fid);title_str=t((length('title= ')+1):end);
t=fgetl(fid);m=sscanf(t((length('nx= ')+1):end),'%d');
t=fgetl(fid);n=sscanf(t((length('ny= ')+1):end),'%d');
t=fgetl(fid);ax=sscanf(t((length('nx= ')+1):end),'%g');
t=fgetl(fid);aspect=sscanf(t((length('aspect= ')+1):end),'%g');
t=fgetl(fid);i_min=sscanf(t((length('i_min= ')+1):end),'%g');
t=fgetl(fid);i_max=sscanf(t((length('i_max= ')+1):end),'%g');
t=fgetl(fid); % column headers
t=fgetl(fid);t=sscanf(t,'%f');cols=numel(t);
a=[t;fscanf(fid,'%f')]; 
fclose(fid);
a=reshape(a,cols,n*m)';
x=reshape(a(:,1),n,m);y=reshape(a(:,2),n,m);
switch cols
    case {3}, str='x y intensity';z=reshape(a(:,end),n,m);
    case {4}, str='x y intensity error';z=reshape(a(:,end-1),n,m);
    case {5}, str='x y intensity error SmoothedIntensity'; z=reshape(a(:,end),n,m);
    otherwise, fprintf(2,'expect 3-column (x,y,intensity), 4-column (x,y,intensity,error)\nor 5-column data format, not %d-column. Return.\n',cols);return;
end
xx=(x(:,1:(end-1))+x(:,2:end))/2;x1=x(:,1)-(-x(:,1)+xx(:,1));xn=x(:,end)+(x(:,end)-xx(:,end));xb=[x1 xx xn];xb(end+1,:)=xb(end,:);
yy=(y(1:(end-1),:)+y(2:end,:))/2;y1=y(1,:)-(-y(1,:)+yy(1,:));yn=y(end,:)+(y(end,:)-yy(end,:));yb=[y1;yy;yn];yb(:,end+1)=yb(:,end);
z(end+1,:)=NaN;z(:,end+1)=NaN;load coltab3.dat -ascii;
eps=1e-3;
z((xb>(ax(2)+eps))|(yb>(ax(4)-eps)))=NaN;
fprintf('%d-column ascii data, interpret as [%s]\nreshape into %d x %d (h x v) arrays\n',cols,str,m,n);
figure;pcolor(xb,yb,z); shading flat; axis(ax);colormap(coltab3);caxis([i_min i_max]);
set(gca,'DataAspectRatioMode','manual','DataAspectRatio',aspect);xlabel(x_label);ylabel(y_label);title(title_str);
colorbar;