This folder contains the scripts and logs used for hardware throughput test

To use this code you will need 2 NetFPGA SUME boards, and access to the OSNT repository.
Access to the NetFPGA-SUME-live repository is recommended but not mandatory.

The two NetFPGA boards need to be connected to each other using all 4x10GE ports. 
Refer to the technical report for full details of the setup.

## Folders Structure

This folder has two subfolders: TCP and NDP.

The NDP folder refers to the hardware implementation of NDP on the NetFPGA-SUME platform.

The TCP folder refers to the hardware implementation of NetFPGA Reference Switch (which is a L2 switch).

Each folder has the following sub-folders:

* bitfiles - contains three bit files (the files used to program the board), one for each frequency.

* pcap - contains the pcap traces used during the evaluation.

* results - contains the performance results (automatically generated) for each of the frequencies.

* scripts - contains the scripts used to drive the experiments.

## NDP/scripts

This folder contains three scripts:

* ndp.tcl - this file replaces the original ndp.tcl (under NetFPGA's $NF_DESIGN_DIR/hw/tcl) and enables controlling core frequency.

* ndp.sh - this script drives the experiments. The script currently uses fixed default paths, you may wish to change those. 

* ndp_parse.sh - this scripts parses the results files and generates the required output (included under "results" folder).

## TCP/scripts

This folder contains three scripts:

* reference_switch.tcl - this file replaces the original reference_switch.tcl (under NetFPGA's $NF_DESIGN_DIR/hw/tcl) and enables controlling core frequency.

* reference_switch.sh - this script drives the experiments. The script currently uses fixed default paths, you may wish to change those.

* parse.sh - this scripts parses the results files and generates the required output (included under "results" folder).

NOTE: We recommend that you familiarize yourself with the NetFPGA design workflow. $NF_DESIGN_DIR is defined under <NetFPGA FOLDER>/tools/settings.sh and needs to be modified for reference_switch and ndp.


