This folder contains the scripts and logs used for FCT sensitivity testing.

To use this code you will need htsim (available in the NDP repository).

## 0_load

This folder contains the flow completion time simulation under 0 load (single flow).
It contains 4 sub directories, one per Facebook workload distribution:

* web - the original distribution from the NDP paper

* web_extracted - the same distribution, as extracted by the authors of this paper, with higher resolution

* cache - cache workload distribution

* hadoop - hadoop workload distribution

Each folder contains the debug logs of 50 runs of each of the four protocols: NDP, MPTCP, DCTCP, DCQCN.

## 1_load

This folder contains the flow completion time simulation under 1:1 load 
It contains 2 sub directories, each for a different Facebook workload:

* web - the original distribution from the NDP paper

* cache - cache workload distribution


Each folder contains both the log files and the debug logs of 50 runs of each of the protocols: NDP, DCTCP, DCQCN.

## 4_load

This folder contains the flow completion time simulation under 4:1 load 
It contains 2 sub directories, each for a different Facebook workload:

* web - the original distribution from the NDP paper

* cache - cache workload distribution


Each folder contains both the log files and the debug logs of 50 runs of each of the protocols: NDP, DCTCP, DCQCN.

## scripts

The folder contains the following scripts:

1. run.sh - runs 50 iterations of the configured workload for each of the protocols and for 0 load, 1:1 and 4:1 load. Set the target folder in the file.
   multiple runs can be parallelized, depending on the number of CPU cores (currently disabled).

2. process_data.sh - extracts FCT and number of completed flows from each of the files generated by run.sh. (for 1:1 and 4:1 load). Set the target folder in the file.

3. process_cache_size.sh - extracts FCT and number of completed flows from NDP runs, per flow size, for the cache workload. Set the target folder in the file.

4. process_web_size.sh - extracts FCT and number of completed flows from NDP runs, per flow size, for the web workload. Set the target folder in the file.

5. example_timeout.sh - example command line to detect timeouts in NDP log files


The scripts need to be placed under <NDP FOLDER>/sim/Examples/<your folder>.


## source

The files under source are modifications of the original NDP source code.
These files should be copied to the  <NDP FOLDER>/sim folder (files under datacenter/ should be copied to  <NDP FOLDER>/sim/datacenter/).
The modifications within the files are to support 2seconds run time and 5% resolution of workload flow size.

### IMPORTANT NOTE

The workload needs to be selected within ndp_transfer.cpp.
Uncomment the workload you want to use (and comment all others).

### Workload

Workloads statistics are taken from:

Roy et. al, Inside the social network's (datacenter) network, SIGCOMM CCR 45(4), 2015.
