# An Artifact Evaluation of NDP

# Introduction

This is a data set associated with the reproduction of the NDP artifact, described in the CCR paper titled above.

This data set captures the data (logs, results) that was collected as part of the evaluation, as well as scripts that were used in the process. The original NDP artifact is not included, and instructions are provided below as to how to obtain it.

This artifact captures the evaluation as it happened, meaning parts that were done manually are documented with their manual components and are not automated for publication purposes. This is as this a not a tool or a project on its own, but is derived from previous work and we are careful to document our exact process as it has happened.

# Installation

* Clone the NDP repository:

`git clone https://github.com/nets-cs-pub-ro/NDP.git`

`cd NDP`

`git checkout 69d27f53c90f441ae1562b4715d084cebe544b3a .`

Alternatively, you can clone our modified version:

`git clone https://github.com/noaz/NDP-eval.git`

Follow the instructions on [NDP Repo](https://github.com/nets-cs-pub-ro/NDP/wiki/NDP-Simulator)


* Clone OSNT:

To use OSNT you will need to register to the OSNT repository at https://netfpga.org/

`git clone https://github.com/NetFPGA/OSNT-SUME-live`

Follow the instructions in [OSNT Wiki](https://github.com/NetFPGA/OSNT-Public/wiki/OSNT-SUME-Getting-Started-Guide)

* OSNT bit file:

The OSNT image we used can be downloaded from [here](https://www.cl.cam.ac.uk/research/srg/netos/projects/netfpga/bitfiles/OSNT-SUME-live/osnt_20170129.bit).

# Setup

## Simulation Environment

The simulation environment is based on htsim. The simulator is provided as part of the NDP repository. 

We use the simulation environment ``as is'', except for the minimum amount of changes required to evaluate a specific aspect, e.g., setting the packet size or changing packet size distribution. 

All the simulations were done on a Xeon E5-2660 v4 server, using 256GB of DDR4-2400 RAM, running at 3.2GHz, and using Ubuntu 14.04, kernel version 3.13.0-32-generic.

## Hardware Environment

Both NDP and the Reference Switch are synthesized using NetFPGA-SUME release 1.7.1. 

Our setup is composed of two identical NetFPGA SUME boards, one configured as OSNT (release 1.7.0), and the other as the device under test. 

The boards are hosted within two identical i7-6700K machines running Ubuntu 14.04; although the host setup has no impact on the test, these are contained within the OSNT design hosted on the NetFPGA SUME board.

# Structure

The repository is structured as follows:

1. throughput_test - The throughput test folder covers the simulation experiments discussed in the  Architectural Limitations section.

2. hardware_test - The hardware test folder covers the hardware experiments discussed in the Implementation Limitations section.

3. fct_test - The fct test folder covers the simulation experiments discussed in the Evaluation Limitations section.

Please refer to the readme file under each folder for more information.

# License

All the information included in this repository is covered by an open source license.

Each folder inherits the license of the source artifact. Hardware experiments use the NetFPGA C.I.C license (http://netfpga-cic.org/), a modified version of Apache License Version 2.0 to support also hardware targets. Some of the scripts are covered by the BSD 3-Clause License.


# Citation

When referencing this work, please use the following citation:

[1] Noa Zilberman, "An Artifact Evaluation of NDP", ACM SIGCOMM Communication Review, Volume 50, Number 2, 2020.

