
** Global Multidimensional Poverty Index -  Nepal MICS 2014 **

clear all 
set more off
set maxvar 10000


global path_in "../rdta/Nepal MICS 2014" 		// folder path
global path_out "cdta"
global path_ado "ado"


**# step 1: data cleaning


**## child under 5	
	
use "$path_in/ch.dta", clear 

rename _all, lower

		
gen double ind_id = hh1*10000 + hh2*100 + ln 
format ind_id %20.0g


duplicates report ind_id								// qc: no duplicates



gen chelg=1 	
lab var chelg "child eligible for measurement" 
count


codebook hl4, ta (9) 									// sex
clonevar gender = hl4									// qc: 1=male; 2=female 



desc cage caged 						// qc: use age in days 

ta cage if caged>9000 					// qc: use age in mth if days missing
clonevar age = caged if caged<9000
replace age = trunc(cage*(365/12)) if caged>=9000 & cage<9000

su age									// qc: check min & max value


gen str6 ageunit = "days"
lab var ageunit "days"



codebook an3, ta (999) 					// qc: body weight in kg

clonevar weight = an3 if an3<99 		// qc: out of range value 
ta an2 an3 if an3>=99, m  				// qc: why missing	
su weight


codebook an4, ta (999) 				// qc: height in cm

clonevar height = an4 if an4<900  	// qc: out of range value
ta an2 an4 if an4>=999, m			// qc: why missing
su height


codebook an4a  									// how child was measured

gen measure = "l" if an4a==1 					// lying down
replace measure = "h" if an4a==2 				// standing up
replace measure = " " if an4a>=9 | an4a==0 		// " " if unknown
ta measure 


gen str1 oedema = "n"  								// oedema


gen sw = 1											// sampling weight


clonevar chswgt = chweight		
lab var chswgt "sample weight child u5"	



adopath + "$path_ado/igrowup_stata"					// compute z-score
gen str100 reflib = "$path_ado/igrowup_stata"
lab var reflib "Directory of reference tables"
gen str100 datalib = "$path_out" 
lab var datalib "Directory for datafiles"
gen str30 datalab = "ch_npl"
lab var datalab "Working file"


igrowup_restricted reflib datalib datalab gender age ageunit weight ///
height measure oedema sw


use "$path_out/ch_npl_z_rc.dta", clear 

		
foreach m of newlist wei len wfl {

	gen	`m'_a = (_z`m' < -2.0)    					// a = mpi
	replace `m'_a = . if _z`m' == . | _f`m'==1

	gen	`m'_u = (_z`m' < -3.0) 						// u = dst
	replace `m'_u = . if _z`m' == . | _f`m'==1
		
}


rename (wei_a len_a wfl_a) (underweight_a stunted_a wasted_a)
rename (wei_u len_u wfl_u) (underweight_u stunted_u wasted_u)

	
foreach i in underweight stunted wasted {	
	lab var `i'_a  "mpi: child is `i'"
	lab var `i'_u  "dst: child is `i'"
	
	ta `i'_a [aw=chswgt],m                     	// qc: % underweight; stunted 
	ta `i'_u [aw=chswgt],m 
}


										// union underweight-stunted
foreach v in a u {								

	gen uw_st_`v' = 1 if stunted_`v'==1 | underweight_`v'==1		
	replace uw_st_`v' = 0 if stunted_`v'==0 & underweight_`v'==0
	replace uw_st_`v' = . if stunted_`v'==. & underweight_`v'==.

}

lab var uw_st_a "mpi: child is uwgt/stunted"   			
lab var uw_st_u "dst: child is uwgt/stunted"  			



count if _fwei==1 | _flen==1 				// biologically implausible zscore


keep *_id chelg chswgt underweight* stunted* wasted* uw_st*
order *_id chelg chswgt underweight* stunted* wasted* uw_st*
sort ind_id

save "$path_out/NPL14_CH.dta", replace

	
erase "$path_out/ch_npl_z_rc.xls"				// erase files
erase "$path_out/ch_npl_prev_rc.xls"	
erase "$path_out/ch_npl_z_rc.dta"



**## birth history

use "$path_in/bh.dta", clear

rename _all, lower	

	
gen double ind_id = hh1*10000 + hh2*100 + ln 
format ind_id %20.0g


gen bh_id = 1
lab var bh_id "female birth recode" 

		

desc bh4c bh5 bh9c wdoi		// dob cmc; child is alive; age at dth mth; doi cmc

codebook bh5 				// qc: 1=alive; 2=not alive

sum bh9c 					// qc: child not alive; age at dth 

recode bh5 (1=0 "alive")(2=1 "not alive"), gen (chdth) 	// total child deceased 


bys ind_id: egen fchdth = sum(chdth)


recode chdth (1=1 "childu18 death") (0=0 "older/no death"), gen (ch18dth)
replace ch18dth=0 if bh9c>=216 & bh9c!=. 

ta ch18dth, m					// total child under 18 deceased


gen ydth_svy= (wdoi - (bh4c + bh9c)) / 12			// dod = bh4c + bh9c 
lab var ydth_svy "years deceased from svy year"
su ydth_svy


bys ind_id: egen fch18dth=sum(ch18dth) if ydth_svy<=5 

replace fch18dth=0 if fch18dth==. & fchdth>=0 & fchdth!=.
	/* note: all children who are alive or who died longer 
	than 5 years from the interview date are replaced as '0' */

replace fch18dth=. if ch18dth==1 & ydth_svy==.	// missing data on death year

ta fchdth fch18dth, m


bys ind_id: egen bh_cm = max(fch18dth)
lab var bh_cm "total cm reported by female"	
ta bh_cm,m


bys ind_id: gen id=1 if _n==1
keep if id==1							// keep one observation per female
drop id
duplicates report ind_id 					


keep *_id bh_cm		
order *_id bh_cm
sort ind_id
save "$path_out/NPL14_BH.dta", replace	


**## eligible female

use "$path_in/wm.dta", clear 

	
rename _all, lower	


gen double ind_id = hh1*10000 + hh2*100 + ln
format ind_id %20.0g

duplicates report ind_id				// qc: no duplicates


gen fm_id = 1 
lab var fm_id "female recode file"


ta wb2,m								// qc: age 15-49 

codebook cm1 cm8 cm9a cm9b, ta (999)		// qc: check why missing values 

ta cm1 cm8, m					// never gave birth, but reported cm
	

	
codebook mstatus ma6, ta (9)
ta mstatus ma6, m 

gen marf = 1 if mstatus==3 						// never married 
replace marf = 2 if mstatus==1					// married 
replace marf = 3 if ma6==1						// widowed
replace marf = 4 if ma6==2						// divorced 
replace marf = 5 if ma6==3						// separated
lab def la_ma 1"never married" 2"currently married" ///
3"widowed" 4"divorced" 5"not living together"
lab val marf la_ma	
lab var marf "marital status female"
ta marf, m
ta ma6 marf, m
ta mstatus marf, m


keep *_id cm1 cm8 cm9a cm9b marf 
order *_id cm1 cm8 cm9a cm9b marf 
sort ind_id
save "$path_out/NPL14_FM.dta", replace

	
	
**## hh recode

use "$path_in/hh.dta", clear 

rename _all, lower	


gen	double hh_id = hh1*100 + hh2 
format	hh_id %20.0g

duplicates report hh_id						// qc: no duplicates


save "$path_out/NPL14_HH.dta", replace



**## hh members

use "$path_in/hl.dta", clear 
	
rename _all, lower


gen double hh_id = hh1*100 + hh2 
format hh_id %20.0g
lab var hh_id "household id"


gen double ind_id = hh1*10000 + hh2*100 + hl1 
format ind_id %20.0g
lab var ind_id "individual id"


duplicates report ind_id 


sort ind_id


bys hh_id: gen id = _n
count if id==1					// qc: 12,405 hh - matches report



**## data merging

merge 1:1 ind_id using "$path_out/NPL14_BH.dta"			// bh recode
drop _merge
erase "$path_out/NPL14_BH.dta" 
  
  
merge 1:1 ind_id using "$path_out/NPL14_FM.dta"			// fem recode
drop _merge
erase "$path_out/NPL14_FM.dta"


merge 1:1 ind_id using "$path_out/NPL14_CH.dta"			// ch recode
drop _merge
erase "$path_out/NPL14_CH.dta"


merge m:1 hh_id using "$path_out/NPL14_HH.dta"			// hh recode
ta hh9 if _m==2 
drop if _merge==2								// drop hh not interviewed
drop _merge
erase "$path_out/NPL14_HH.dta"



sort ind_id



**## eligibility variables
						
															// elg for cm
																
count if fm_id==1						
count if hl7>0 & hl7!=.					// qc: match between wm & hl datafiles 

bys hh_id: egen no_f_elg = min(fm_id==.)
lab var no_f_elg "hh has no elg female"
ta no_f_elg,m



															// elg for nutr						
count if chelg==1
count if hl7b>0 & hl7b!=.			// qc: match between ch and hl datafiles

bys hh_id: egen no_ch_elg = min(chelg==.)
lab var no_ch_elg "hh has no elg child for nutr"
ta no_ch_elg,m


sort hh_id 



**## relevant variables 

clonevar weight = hhweight 								// sample weight 
lab var weight "sample weight"
				
			
lab var psu "primary sampling unit"					  	// sample design	

clonevar strata = stratum
lab var strata "sample strata"


svyset psu [pw=weight] , strata(strata)	 singleunit(centered)




desc hh5y hh5m hh5d 									// interview dates

clonevar intvw_y = hh5y 	
clonevar intvw_m = hh5m 
clonevar intvw_d = hh5d 




codebook hh6, ta (9)							   // area: urban-rural		

recode hh6 (1=1 "urban") (2=0 "rural"), gen (area)						 
lab var area "area: urban-rural"
ta hh6 area, m



codebook hl3, ta (99)									// relationship

recode hl3 (1=1 "head")(2=2 "spouse")(3 13=3 "child") ///
(4/12=4 "extended family")(96=5 "not related") ///
(14=6 "maid") (97/99 = .), gen (rship)
lab var rship "relationship"
ta hl3 rship, m	



codebook hl4 												// sex

recode hl4 (1=1 "male")	(2=2 "female"), gen (sex)						
lab var sex "sex"
ta hl4 sex,m



bys	hh_id: egen xhhead = min(rship) 						// headship
ta xhhead,m 

gen hhead = (rship==1 & sex==1) | (xhhead==2 & rship==2 & sex==1)  
replace hhead = 2 if (rship==1 & sex==2) | (xhhead==2 & rship==2 & sex==2)

bys hh_id: egen hship = sum(hhead)

replace hship = . if xhhead > 2 | hship==0  	// hh, no head
lab def la_hs 1"male-headed" 2"female-headed"
lab val hship la_hs
lab var hship "gender of hh head"
ta hship, m



codebook hl6, ta (999) 							// age; age group

clonevar age = hl6  if hl6<98
lab var age "age"


recode age (0/4 = 1 "0-4")(5/9 = 2 "5-9")(10/14 = 3 "10-14") ///
		   (15/17 = 4 "15-17")(18/59 = 5 "18-59")(60/max=6 "60+"), gen(agec7)
lab var agec7 "age groups (7 groups)"	
	   
recode age (0/9 = 1 "0-9") (10/17 = 2 "10-17")(18/59 = 3 "18-59") ///
		   (60/max=4 "60+") , gen(agec4)
lab var agec4 "age groups (4 groups)"

recode age (0/17 = 1 "0-17") (18/max = 2 "18+"), gen(agec2)		 		   
lab var agec2 "age groups (2 groups)"



gen member = 1 												// hh size
bys hh_id: egen hhsize = sum(member)
lab var hhsize "household size"
drop member



codebook hh7, ta (99)								// region

recode hh7 (5=1 "Central Hill") (4=2 "Central Mountain") ///
(6=3 "Central Terai") (2=4 "Eastern Hill") ///
(1=5 "Eastern Mountain") (3=6 "Eastern Terai") ///
(14=7 "Far-Western Hill") (13=8 "Far-Western Mountain") ///
(15=9 "Far-Western Terai") (11=10 "Mid-Western Hill") ///
(10=11 "Mid-Western Mountain") (12=12 "Mid-Western Terai") ///
(8=13 "Western Hill") (7=14 "Western Mountain") ///
(9=15 "Western Terai"), gen(region)


lab var region "subnational region"
codebook region, ta (99)



					/* subnational region, harmonised over time. 
					note: not able to regroup regions to match 
					most recent surveys since no variable on districts.*/

gen region_01 = .
lab var region_01 "hot: subnational region"




**# step 2: indicator construction


**## school attendance

codebook ed3 ed5, ta (99)

recode ed5 (1=1 "attending") (2=0 "not attending") (9=.), gen (att)
replace att = 0 if ed3==2 				
lab var att "sch att status"
ta att,m									// qc: missing replaced as '.'



gen scheg_a = (schage>=5 & schage<=13)		// qc: mpi - age range of elg
lab var scheg_a "mpi: elg for school att"



gen scheg_u = (schage>=5 & schage<=11)		// qc: dst - age range of elg
lab var scheg_u "dst: elg for school att"


								// policy: >=2/3 elg pop have non-missing data 
								
foreach v in a u {										// a=mpi; u=dst	 
	 	
	gen tmp_`v' = 1 if scheg_`v'==1 & att!=. 		
	bys hh_id: egen hsattdt_`v' = sum(tmp_`v')		// elg & no missing data
	drop tmp_`v'
	
	bys hh_id: egen hscheg_`v' = sum(scheg_`v')			// elg population

	replace hsattdt_`v' = hsattdt_`v'/hscheg_`v' 
	replace hsattdt_`v' = (hsattdt_`v'>=2/3)	 		
	ta hsattdt_`v', m									// qc: missing =0% 	
}	


foreach i in a u {							// school att indc (a=mpi; u=dst)

	gen tmp_`i' = (att==1) if scheg_`i'==1 & att!=.     		
	bys	hh_id: egen satt_`i' = min(tmp_`i') 
	replace satt_`i' = . if hsattdt_`i'==0	& satt_`i'==1		// policy
	replace satt_`i' = 1 if hscheg_`i'==0						// non-elg 
	drop tmp_`i'

	ta satt_`i', m
							
}

lab var satt_a "mpi: not deprived in satt"					
lab var satt_u "dst: not deprived in satt"



**## years of schooling 

codebook ed4b, ta (99)							// qc: check missing value

gen eduyr = ed4b if ed4b < 98 

replace eduyr = 0 if ed3==2 | ed4b==94		// never attended or preschool 

replace eduyr = . if age<=eduyr & age>0 

ta eduyr, m




	/* note: all those who should have completed 6 years 
	of schooling from their starting sch age are counted 
	as eligible, as well as early starters (from age of 10)
	who uniqely have up to six years of schooling are eligible. */
											
gen edueg = (age>=11 & age!=.) | ((age==10) &  ///
			(eduyr>=6 & eduyr!=.)) | (age==. & eduyr>=6 & eduyr!=.)	

lab var edueg "elg for years of schooling"
ta edueg,m


								// policy: >=2/3 elg pop have non-missing data 
								
gen tmp = 1 if eduyr!=. & edueg==1
bys	hh_id: egen hedudt = sum(tmp)				// elg pop with no missing data
drop tmp				
	
	
bys hh_id: egen hedueg = sum(edueg==1) 			// elg population

replace hedudt = hedudt/hedueg
replace hedudt = (hedudt>=2/3)		
ta hedudt, m									// qc: missing = 0% 	
lab var hedudt "non-missing edu" 
							
							
									// mpi: completed six years of schooling
gen	tmp_a = (eduyr>=6 & eduyr!=. & edueg==1)   	
replace tmp_a = . if eduyr==. & edueg==1

									// dst: completed one year of schooling
gen	tmp_u = (eduyr>=1 & eduyr!=. & edueg==1)		
replace tmp_u = . if eduyr==. & edueg==1								
	
	
								
foreach i in a u {							
	bys hh_id: egen educ_`i' = max(tmp_`i')
	replace educ_`i' = . if educ_`i'==0 & hedudt==0 			// policy
	drop tmp_`i'
	
	ta educ_`i', m							
}
																
lab var educ_a "mpi: not deprived in yos"
lab var educ_u "dst: not deprived in yos"



**## nutrition

foreach msr in uw_st_a uw_st_u {	

	bys hh_id: egen tmp = max(`msr')
	gen	no_`msr' = (tmp==0)	if tmp!=.			
	drop tmp
	replace no_`msr' = 1 if no_ch_elg==1				// hh no elg child 

	ta no_`msr',m 
}

lab var no_uw_st_a "mpi: no underweight/stunted child in hh"
lab var no_uw_st_u "dst: no underweight/stunted child in hh"	


foreach i in a u {								// nutr indc (a = mpi; u = dst)

	gen	nutr1_`i' = 1  														
	replace nutr1_`i' = 0 if no_uw_st_`i'==0
	replace nutr1_`i' = . if no_uw_st_`i'==.
	replace nutr1_`i' = 1 if no_ch_elg==1   	


	ta nutr1_`i', m

}

lab var nutr1_a "mpi: not deprived in nutr (u5)"
lab var nutr1_u "dst: not deprived in nutr (u5)"



**## child mortality

ta bh_cm,m   										// generated in bh recode
ta bh_cm if bh_id==1, m	
						

gen tmp = bh_cm


							// zero mortality = no child died; non-elg fem 
ta cm1 cm8,m				
											
replace tmp = 0 if cm8==2 | (cm1==2 & cm8==9) | no_f_elg==1
														

bys hh_id: egen cm = sum(tmp),m
	
recode cm (1/max=0) (0=1) if cm!=.
lab var cm "not deprived in cm"
ta cm, m 												// mpi = dst

drop tmp 



**## electricity 

codebook hc8a, ta (9)

															// mpi = dst
recode hc8a  (1 = 1 "yes") (2 = 0 "no") (9=.), gen(elct)	 
lab var elct "non deprived in elct"							

svy: prop elct						



**## sanitation

desc ws8 ws9

codebook ws8, ta(99) 	
	
recode ws8 (11/13 15/22 31 = 1 "yes") ///
(14 23 41 95/96 = 0 "no") (99=.), gen(sani_a)   						// mpi


codebook ws9

replace sani_a = 0 if ws9==1				
lab var sani_a "mpi: not deprived in sani"
ta ws8 sani_a, m


svy: prop sani_a				
	
	
recode ws8 (11/41 = 1 "yes") ///
(95 96 = 0 "no") (99=.), gen(sani_u)							// dst
	
lab var sani_u "dst: non deprived in sani"
ta ws8 sani_u, m



**## drinking water 

desc ws1 ws4 

codebook ws1, ta(99)

recode ws1 (11/31 41 51/61 91 = 1 "yes") ///
(32 42 81 96 = 0 "no"), gen(wtr_sdg)

lab var wtr_sdg "improved source of dwtr sdg"

ta ws1 wtr_sdg,m


codebook ws4, ta (999)									// time to water

clonevar wtr_a = wtr_sdg
replace wtr_a = 0 if ws4 >=30 & ws4 <=900				// mpi >=30 mins						 
lab var wtr_a "mpi: not deprived in dwtr"
ta wtr_a,m


clonevar wtr_u = wtr_sdg															   
replace wtr_u = 0 if ws4 >45 & ws4 <=900				// dst > 45 mins			  
lab var wtr_u "dst: not deprived in dwtr"
ta wtr_u,m 



**## housing

desc hc3 hc4 hc5


codebook hc3, ta (99)			// improved = rudimentary & finished floor 
recode hc3 (21/36 = 1 "yes") (11 12 96 = 0 "no") (99=.), gen(floor)
lab var floor "hh has improved floor"
ta hc3 floor,m

	
codebook hc4, ta (99)				// improved = finished roofing 
recode hc4 (31/36 = 1 "yes") (12/23 96 = 0 "no") (99=.), gen(roof)
lab var roof "hh has improved roof"
ta hc4 roof,m	


codebook hc5, ta (99)				// improved = finished walls 
recode hc5 (31/36 = 1 "yes") (11/26 96 = 0 "no"), gen(wall)
lab var wall "hh has improved wall"
ta hc5 wall,m


gen hsg_a = 1														// mpi
replace hsg_a = 0 if floor==0 | wall==0 | roof==0
replace hsg_a = . if floor==. & wall==. & roof==.
lab var hsg_a "mpi: not deprived in hsg"
ta hsg_a, m


gen hsg_u = 1														// dst
replace hsg_u = 0 if ///
(floor==0 & wall==0 & roof==1) | ///
(floor==0 & wall==1 & roof==0) | ///
(floor==1 & wall==0 & roof==0) | ///
(floor==0 & wall==0 & roof==0)

replace hsg_u = . if floor==. & wall==. & roof==.
lab var hsg_u "dst: non deprived in housing"
ta hsg_u, m



**## cooking fuel 

codebook hc6, ta(99)

															// mpi = dst
															
recode hc6 (1/5 95 96 = 1 "yes") (6/11 = 0 "no")(99=.), gen(ckfl) 
							
lab var ckfl "not deprived in ckfl"	

ta hc6 ckfl,m				



**## assets

lookfor car voiture truck van carro
codebook hc9f 	
clonevar car = hc9f
lab var car "hh has car"



lookfor telephone téléphone mobilephone ipod telefone telemóvel
ta hc8d hc9b,m nol
gen phone = (hc8d==1 | hc9b==1)
lab var phone "hh has telephone"			
ta hc8d hc9b if phone==1,m			



lookfor radio walkman stereo stéréo
codebook hc8b
clonevar radio = hc8b 
lab var radio "hh has radio"



lookfor tv television plasma lcd télé 
codebook hc8c
clonevar tv = hc8c 
lab var tv "hh has television"								



lookfor refrigerator réfrigérateur 
codebook hc8e
clonevar fridge = hc8e
lab var fridge "hh has refrigerator"							

		
	
lookfor bicycle bicyclette bicicleta
codebook hc9c
clonevar bike = hc9c
lab var bike "hh has bicycle"		
	

	
lookfor motorbike moto
codebook hc9d	
clonevar mbike = hc9d
lab var mbike "hh has motorbike"
	
	
	
lookfor brouette cart carro carreta
codebook hc9e
clonevar acart = hc9e
lab var acart "hh has animal cart"	


	
lookfor computer ordinateur laptop ipad tablet 
ta hc8l hc9h,m nol
gen comp = (hc8l==1 | hc9h==1)
lab var comp "hh has computer"			
ta hc8l hc9h if comp==1,m	


	
lab def la_at 0"no" 1"yes" 
foreach var in car tv radio phone fridge bike mbike comp acart {
	replace `var' = 0 if `var'==2 
	lab val `var' la_at			   
	replace `var' = . if `var'==9 | `var'==99 | `var'==8 | `var'==98 
}


egen n_bast = rowtotal (tv radio phone fridge bike mbike comp acart), m
lab var n_bast "small assets owned by hh" 
   
   
gen asst_a = (car==1 | n_bast > 1)								// mpi
replace asst_a = . if car==. & n_bast==.   								
lab var asst_a "mpi: not deprived in assets"


gen	asst_u = (car==1 | n_bast >0)								// dst
replace asst_u = . if car==. & n_bast==.  								
lab var asst_u "dst: not deprived in assets"



**# step 3: spec & flav

recode cm   	(0=1)(1=0) , gen(d_cm)						// mpi est 
recode nutr1_a 	(0=1)(1=0) , gen(d_nutr)
recode satt_a 	(0=1)(1=0) , gen(d_satt)
recode educ_a 	(0=1)(1=0) , gen(d_educ)
recode elct		(0=1)(1=0) , gen(d_elct)
recode sani_a	(0=1)(1=0) , gen(d_sani)
recode wtr_a 	(0=1)(1=0) , gen(d_wtr)
recode hsg_a 	(0=1)(1=0) , gen(d_hsg)
recode ckfl 	(0=1)(1=0) , gen(d_ckfl)
recode asst_a 	(0=1)(1=0) , gen(d_asst)


recode cm   	(0=1)(1=0) , gen(d_cm_01)	 			    // hot mpi est 
recode nutr1_a 	(0=1)(1=0) , gen(d_nutr_01)
recode satt_a 	(0=1)(1=0) , gen(d_satt_01)
recode educ_a 	(0=1)(1=0) , gen(d_educ_01)
recode elct		(0=1)(1=0) , gen(d_elct_01)
recode wtr_a 	(0=1)(1=0) , gen(d_wtr_01)
recode sani_a	(0=1)(1=0) , gen(d_sani_01)
recode hsg_a 	(0=1)(1=0) , gen(d_hsg_01)
recode ckfl 	(0=1)(1=0) , gen(d_ckfl_01)
recode asst_a 	(0=1)(1=0) , gen(d_asst_01)




recode cm   	(0=1)(1=0) , gen(dst_cm)					// dst est
recode nutr1_u 	(0=1)(1=0) , gen(dst_nutr)
recode satt_u 	(0=1)(1=0) , gen(dst_satt)
recode educ_u 	(0=1)(1=0) , gen(dst_educ)
recode elct 	(0=1)(1=0) , gen(dst_elct)
recode sani_u 	(0=1)(1=0) , gen(dst_sani)
recode wtr_u  	(0=1)(1=0) , gen(dst_wtr)
recode hsg_u  	(0=1)(1=0) , gen(dst_hsg)
recode ckfl 	(0=1)(1=0) , gen(dst_ckfl)
recode asst_u 	(0=1)(1=0) , gen(dst_asst) 


recode cm   	(0=1)(1=0) , gen(dst_cm_01)				   	// hot dst est
recode nutr1_u	(0=1)(1=0) , gen(dst_nutr_01)
recode satt_u 	(0=1)(1=0) , gen(dst_satt_01)
recode educ_u 	(0=1)(1=0) , gen(dst_educ_01)
recode elct 	(0=1)(1=0) , gen(dst_elct_01)
recode wtr_u  	(0=1)(1=0) , gen(dst_wtr_01)
recode sani_u 	(0=1)(1=0) , gen(dst_sani_01)
recode hsg_u  	(0=1)(1=0) , gen(dst_hsg_01)
recode ckfl 	(0=1)(1=0) , gen(dst_ckfl_01)
recode asst_u 	(0=1)(1=0) , gen(dst_asst_01) 



lab def la_dp 1"yes" 0"no"
foreach var in d_* dst_* d_*_* dst_*_* {
lab val `var' la_dp
}

foreach var in cm nutr satt educ elct wtr sani hsg ckfl asst {
lab var d_`var' "deprived in `var'"
lab var d_`var'_01 "hot: deprived in `var'"
lab var dst_`var' "dst: deprived in `var'"
lab var dst_`var'_01 "hot-dst: deprived in `var'"
}


keep hh_id ind_id strata psu weight chswgt ///
sex age agec* area region* hship intvw_* ///
scheg_a att edueg eduyr chelg uw_st_a ///
d_* dst_* wtr_sdg ws4

	 
order hh_id ind_id strata psu weight chswgt ///
sex age agec* area region* hship intvw_* ///
scheg_a att edueg eduyr chelg uw_st_a ///
d_* dst_* wtr_sdg ws4


mdesc psu strata area age hship region* d_* dst_*


char _dta[cty] "Nepal"
char _dta[ccty] "NPL"
char _dta[year] "2014" 	
char _dta[survey] "MICS"
char _dta[ccnum] "524"
char _dta[type] "micro"


sort ind_id
compress
la da "Micro data for `_dta[ccty]' (`_dta[ccnum]') from `c(current_date)' (`c(current_time)')."
save "$path_out/npl_mics14.dta", replace 
	
